/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.util.IReorderingProcessor;

public class ScrollListPane<T extends Slot>
extends AbstractList {
    private final JmUI parent;
    public SlotMetadata lastTooltipMetadata;
    public List<IReorderingProcessor> lastTooltip;
    public long lastTooltipTime;
    public long hoverDelay = 400L;
    private int hpad = 12;
    private List<T> rootSlots;
    private SlotMetadata lastPressed;
    private int lastClickedIndex;
    private int scrollbarX;
    private int listWidth;
    private boolean alignTop;

    public ScrollListPane(JmUI parent, Minecraft mc, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        this.parent = parent;
        this.func_230940_a_(width, height, top, bottom);
    }

    public void setHover(boolean hover) {
        for (Slot slot : this.rootSlots) {
            slot.displayHover(hover);
        }
    }

    public void func_230940_a_(int width, int height, int top, int bottom) {
        super.func_230940_a_(width, height, top, bottom);
        this.scrollbarX = this.field_230670_d_ - this.hpad;
        this.listWidth = this.field_230670_d_ - this.hpad * 4;
    }

    public void setSlots(List<T> slots) {
        this.rootSlots = slots;
        this.updateSlots();
    }

    public List<T> getRootSlots() {
        return this.rootSlots;
    }

    public void updateSlots() {
        int sizeBefore = this.func_230965_k_();
        this.func_231039_at__().clear();
        int columnWidth = 0;
        for (Slot slot : this.rootSlots) {
            columnWidth = Math.max(columnWidth, slot.getColumnWidth());
            super.func_230513_b_((AbstractList.AbstractListEntry)slot);
            List<? extends Slot> childSlots = slot.getChildSlots(this.listWidth, columnWidth);
            if (childSlots == null || childSlots.isEmpty()) continue;
            for (Slot slot2 : childSlots) {
                super.func_230513_b_((AbstractList.AbstractListEntry)slot2);
            }
        }
        int sizeAfter = this.func_230965_k_();
        if (sizeBefore < sizeAfter) {
            this.func_230937_a_(-(sizeAfter * this.field_230669_c_));
            this.func_230937_a_(this.lastClickedIndex * this.field_230669_c_);
        }
    }

    public void scrollTo(Slot slot) {
        this.func_230937_a_(-(this.func_231039_at__().size() * this.field_230671_e_));
        this.func_230937_a_(this.func_231039_at__().indexOf((Object)slot) * this.field_230671_e_);
    }

    public boolean func_230957_f_(int index) {
        return super.func_230957_f_(index);
    }

    protected int func_230962_i_(int slotIndex) {
        return super.func_230962_i_(slotIndex);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        try {
            super.func_244605_b(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_238478_a_(MatrixStack mStack, int rowLeft, int rowTop, int mouseX, int mouseY, float partialTicks) {
        SlotMetadata tooltipMetadata;
        super.func_238478_a_(mStack, rowLeft, rowTop, mouseX, mouseY, partialTicks);
        Slot slot = (Slot)this.func_230933_a_(mouseX, mouseY);
        if (slot != null && (tooltipMetadata = slot.getCurrentTooltip()) != null && !tooltipMetadata.getTooltip().equals(this.lastTooltip)) {
            this.lastTooltipMetadata = tooltipMetadata;
            this.lastTooltip = tooltipMetadata.getTooltip();
            this.lastTooltipTime = System.currentTimeMillis();
        }
    }

    public int func_230949_c_() {
        return this.listWidth;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean clicked = super.func_231044_a_(mouseX, mouseY, button);
        if (super.func_231047_b_(mouseY, mouseY)) {
            Slot slot = (Slot)this.func_230933_a_(mouseX, mouseY);
            if (slot == null) {
                return false;
            }
            this.lastClickedIndex = this.func_231039_at__().indexOf((Object)slot);
            this.lastPressed = slot.getLastPressed();
            if (slot instanceof CategorySlot) {
                this.updateSlots();
            }
        }
        return clicked;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        for (int slotIndex = 0; slotIndex < this.func_230965_k_(); ++slotIndex) {
            Slot slot;
            if (slotIndex != this.lastClickedIndex || !(slot = this.getSlot(this.lastClickedIndex)).func_231048_c_(mouseX, mouseY, mouseButton)) continue;
            this.lastPressed = null;
            return true;
        }
        return false;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.func_231039_at__().isEmpty()) {
            return false;
        }
        if (this.lastClickedIndex > -1 && this.getSlot(this.lastClickedIndex) != null && this.getSlot(this.lastClickedIndex).func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public Slot getSlot(int index) {
        if (super.func_230965_k_() > index) {
            return (Slot)((Object)this.func_231039_at__().get(index));
        }
        return null;
    }

    public SlotMetadata getLastPressed() {
        return this.lastPressed;
    }

    public void resetLastPressed() {
        this.lastPressed = null;
    }

    public Slot getLastPressedParentSlot() {
        if (this.lastPressed != null) {
            for (Slot slot : this.rootSlots) {
                if (!slot.contains(this.lastPressed)) continue;
                return slot;
            }
        }
        return null;
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        for (int slotIndex = 0; slotIndex < this.func_230965_k_(); ++slotIndex) {
            if (slotIndex != this.lastClickedIndex) continue;
            return this.getSlot(this.lastClickedIndex).func_231042_a_(typedChar, keyCode);
        }
        return false;
    }

    public boolean func_231046_a_(int key, int value, int modifier) {
        for (int slotIndex = 0; slotIndex < this.func_230965_k_(); ++slotIndex) {
            if (slotIndex != this.lastClickedIndex) continue;
            return this.getSlot(this.lastClickedIndex).func_231046_a_(key, value, modifier);
        }
        return false;
    }

    protected int func_230952_d_() {
        return this.scrollbarX;
    }

    protected void func_230433_a_(MatrixStack mStack) {
        this.func_238468_a_(mStack, 0, 0, this.field_230670_d_, this.field_230671_e_, -1072689136, -804253680);
    }

    protected int func_230945_b_() {
        int contentHeight = super.func_230945_b_();
        if (this.alignTop) {
            contentHeight = Math.max(this.getBottom() - this.getTop() - 4, contentHeight);
        }
        return contentHeight;
    }

    public int getTop() {
        return this.field_230672_i_;
    }

    public int getBottom() {
        return this.field_230673_j_;
    }

    public int getHeight() {
        return this.field_230671_e_;
    }

    public void setAlignTop(boolean alignTop) {
        this.alignTop = alignTop;
    }
}

