/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.GridSpec;
import journeymap.client.model.GridSpecs;
import journeymap.client.model.MapType;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.CheckBox;
import journeymap.client.ui.component.IntSliderButton;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.ListPropertyButton;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GridEditor
extends JmUI {
    private final TextureImpl colorPickTexture;
    private final int tileSize = 128;
    private final int sampleTextureSize = 128;
    private GridSpecs gridSpecs;
    private ListPropertyButton<GridSpec.Style> buttonStyle;
    private IntSliderButton buttonOpacity;
    private CheckBox checkDay;
    private CheckBox checkNight;
    private CheckBox checkUnderground;
    private ThemeToggle buttonDay;
    private ThemeToggle buttonNight;
    private ThemeToggle buttonUnderground;
    private Integer activeColor;
    private MapType activeMapType;
    private Button buttonReset;
    private Button buttonCancel;
    private Button buttonClose;
    private Rectangle2D.Double colorPickRect;
    private BufferedImage colorPickImg;
    private ButtonList topButtons;
    private ButtonList leftButtons;
    private ButtonList leftChecks;
    private ButtonList bottomButtons;
    private ResourceLocation colorPicResource = Constants.birthdayMessage() == null ? TextureCache.ColorPicker : TextureCache.ColorPicker2;

    public GridEditor(JmUI returnDisplay) {
        super(Constants.getString("jm.common.grid_editor"), returnDisplay);
        this.colorPickImg = TextureCache.resolveImage(this.colorPicResource);
        this.colorPickTexture = TextureCache.getTexture(this.colorPicResource);
        this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, this.colorPickTexture.getWidth(), this.colorPickTexture.getHeight());
        this.gridSpecs = JourneymapClient.getInstance().getCoreProperties().gridSpecs.clone();
        this.activeMapType = MapType.day((RegistryKey<World>)World.field_234918_g_);
        this.activeColor = this.gridSpecs.getSpec(this.activeMapType).getColor();
        this.getMinecraft().field_195559_v.func_197967_a(true);
    }

    @Override
    public void func_231160_c_() {
        try {
            if (this.field_230710_m_.isEmpty()) {
                GridSpec spec = this.gridSpecs.getSpec(this.activeMapType);
                this.buttonStyle = new ListPropertyButton<GridSpec.Style>(EnumSet.allOf(GridSpec.Style.class), Constants.getString("jm.common.grid_style"), new EnumField<GridSpec.Style>(Category.Hidden, "", spec.style), b -> this.updateGridSpecs());
                this.func_230480_a_((Widget)this.buttonStyle);
                this.buttonOpacity = new IntSliderButton(new IntegerField(Category.Hidden, "", 0, 100, (int)Math.ceil(spec.alpha * 100.0f)), Constants.getString("jm.common.grid_opacity") + " : ", "", 0, 100, true);
                this.func_230480_a_((Widget)this.buttonOpacity);
                this.topButtons = new ButtonList(this.buttonStyle, this.buttonOpacity);
                this.topButtons.equalizeWidths(this.getFontRenderer());
                this.checkDay = new CheckBox("", this.activeMapType == MapType.day((RegistryKey<World>)World.field_234918_g_), b -> this.updatePreview(MapType.day((RegistryKey<World>)World.field_234918_g_)));
                this.func_230480_a_((Widget)this.checkDay);
                this.checkNight = new CheckBox("", this.activeMapType == MapType.night((RegistryKey<World>)World.field_234918_g_), b -> this.updatePreview(MapType.night((RegistryKey<World>)World.field_234918_g_)));
                this.func_230480_a_((Widget)this.checkNight);
                this.checkUnderground = new CheckBox("", this.activeMapType.isUnderground(), b -> this.updatePreview(MapType.underground(0, (RegistryKey<World>)World.field_234918_g_)));
                this.func_230480_a_((Widget)this.checkUnderground);
                this.leftChecks = new ButtonList(this.checkDay, this.checkNight, this.checkUnderground);
                Theme theme = ThemeLoader.getCurrentTheme();
                this.buttonDay = new ThemeToggle(theme, "jm.fullscreen.map_day", "day", b -> this.updatePreview(MapType.day((RegistryKey<World>)World.field_234918_g_)));
                this.func_230480_a_((Widget)this.buttonDay);
                this.buttonNight = new ThemeToggle(theme, "jm.fullscreen.map_night", "night", b -> this.updatePreview(MapType.night((RegistryKey<World>)World.field_234918_g_)));
                this.func_230480_a_((Widget)this.buttonNight);
                this.buttonUnderground = new ThemeToggle(theme, "jm.fullscreen.map_caves", "caves", b -> this.updatePreview(MapType.underground(0, (RegistryKey<World>)World.field_234918_g_)));
                this.func_230480_a_((Widget)this.buttonUnderground);
                this.leftButtons = new ButtonList(this.buttonDay, this.buttonNight, this.buttonUnderground);
                this.buttonReset = new Button(Constants.getString("jm.waypoint.reset"), b -> this.resetGridSpecs());
                this.func_230480_a_((Widget)this.buttonReset);
                this.buttonCancel = new Button(Constants.getString("jm.waypoint.cancel"), b -> {
                    this.resetGridSpecs();
                    this.closeAndReturn();
                });
                this.func_230480_a_((Widget)this.buttonCancel);
                this.buttonClose = new Button(Constants.getString("jm.waypoint.save"), b -> this.saveAndClose());
                this.func_230480_a_((Widget)this.buttonClose);
                this.bottomButtons = new ButtonList(this.buttonReset, this.buttonCancel, this.buttonClose);
                this.bottomButtons.equalizeWidths(this.getFontRenderer());
                this.field_230710_m_.addAll(this.topButtons);
                this.field_230710_m_.addAll(this.leftChecks);
                this.field_230710_m_.addAll(this.leftButtons);
                this.field_230710_m_.addAll(this.bottomButtons);
                this.updatePreview(this.activeMapType);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    protected void layoutButtons(MatrixStack mStack) {
        try {
            this.func_231160_c_();
            int hgap = 6;
            int vgap = 6;
            int startY = Math.max(40, (this.field_230709_l_ - 230) / 2);
            int centerX = this.field_230708_k_ / 2;
            int cpSize = this.topButtons.getHeight(6);
            int topRowWidth = 6 + cpSize + ((Button)this.topButtons.get(0)).func_230998_h_();
            int topRowLeft = centerX - topRowWidth / 2;
            this.topButtons.layoutVertical(topRowLeft + 6 + cpSize, startY, true, 6);
            this.drawColorPicker(mStack, topRowLeft, this.topButtons.getTopY(), cpSize);
            int tileX = centerX - 64;
            int tileY = this.topButtons.getBottomY() + 12;
            this.drawMapTile(mStack, tileX, tileY);
            this.leftButtons.layoutVertical(tileX - ((Button)this.leftButtons.get(0)).func_230998_h_() - 6, tileY + 6, true, 6);
            this.leftChecks.setHeights(((Button)this.leftButtons.get(0)).func_238483_d_());
            this.leftChecks.setWidths(15);
            this.leftChecks.layoutVertical(this.leftButtons.getLeftX() - this.checkDay.func_230998_h_(), this.leftButtons.getTopY(), true, 6);
            int bottomY = Math.min(tileY + 128 + 12, this.field_230709_l_ - 10 - this.buttonClose.func_238483_d_());
            this.bottomButtons.equalizeWidths(this.getFontRenderer(), 6, ((Button)this.topButtons.get(0)).getRightX() - topRowLeft);
            this.bottomButtons.layoutCenteredHorizontal(centerX, bottomY, true, 6);
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.layoutButtons: " + LogFormatter.toString(t));
        }
    }

    @Override
    public void func_230430_a_(MatrixStack mStack, int x, int y, float par3) {
        try {
            this.func_238651_a_(mStack, 0);
            this.layoutButtons(mStack);
            for (int k = 0; k < this.field_230710_m_.size(); ++k) {
                net.minecraft.client.gui.widget.button.Button guibutton = (net.minecraft.client.gui.widget.button.Button)this.field_230710_m_.get(k);
                guibutton.func_230430_a_(mStack, x, y, 0.0f);
            }
            this.drawTitle(mStack);
            this.drawLogo(mStack);
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.render: " + LogFormatter.toString(t));
        }
    }

    protected void drawColorPicker(MatrixStack mStack, int x, int y, float size) {
        int sizeI = (int)size;
        GridEditor.func_238467_a_((MatrixStack)mStack, (int)(x - 1), (int)(y - 1), (int)(x + sizeI + 1), (int)(y + sizeI + 1), (int)-6250336);
        if (this.colorPickRect.width != (double)size) {
            Image image = this.colorPickTexture.getImage().getScaledInstance(sizeI, sizeI, 2);
            this.colorPickImg = new BufferedImage(sizeI, sizeI, 1);
            Graphics2D g = this.colorPickImg.createGraphics();
            g.drawImage(image, 0, 0, sizeI, sizeI, null);
            g.dispose();
        }
        this.colorPickRect.setRect(x, y, size, size);
        float scale = size / (float)this.colorPickTexture.getWidth();
        DrawUtil.drawImage(mStack, this.colorPickTexture, x, y, false, scale, 0.0);
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        if (colorX > 0 && colorY > 0) {
            DrawUtil.drawRectangle(mStack, (colorX += x) - 2, (colorY += y) - 2, 5.0, 5.0, Color.darkGray.getRGB(), 0.8f);
            DrawUtil.drawRectangle(mStack, colorX - 1, colorY, 3.0, 1.0, this.activeColor, 1.0f);
            DrawUtil.drawRectangle(mStack, colorX, colorY - 1, 1.0, 3.0, this.activeColor, 1.0f);
        }
    }

    protected void drawMapTile(MatrixStack mStack, int x, int y) {
        float scale = 1.0f;
        GridEditor.func_238467_a_((MatrixStack)mStack, (int)(x - 1), (int)(y - 1), (int)(x + 128 + 1), (int)(y + 128 + 1), (int)-6250336);
        TextureImpl tileTex = this.getTileSample(this.activeMapType);
        DrawUtil.drawImage(mStack, tileTex, x, y, false, 1.0f, 0.0);
        if (scale == 2.0f) {
            DrawUtil.drawImage(mStack, tileTex, x + 128, y, true, 1.0f, 0.0);
            DrawUtil.drawImage(mStack, tileTex, x, y + 128, true, 1.0f, 180.0);
            DrawUtil.drawImage(mStack, tileTex, x + 128, y + 128, false, 1.0f, 180.0);
        }
        GridSpec gridSpec = this.gridSpecs.getSpec(this.activeMapType);
        gridSpec.beginTexture(9728, 33071, 1.0f);
        DrawUtil.drawBoundTexture(mStack, 0.0, 0.0, x, y, 0.0, 0.25, 0.25, x + 128, y + 128);
        gridSpec.finishTexture();
    }

    protected void drawLabel(MatrixStack mStack, String label, int x, int y) {
        GridEditor.func_238476_c_((MatrixStack)mStack, (FontRenderer)this.getFontRenderer(), (String)label, (int)x, (int)y, (int)Color.cyan.getRGB());
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        try {
            switch (keyCode) {
                case 256: {
                    this.closeAndReturn();
                    return true;
                }
                case 257: {
                    this.saveAndClose();
                    return true;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.keyTyped: " + LogFormatter.toString(t));
        }
        return false;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        try {
            if (this.buttonOpacity.dragging) {
                this.updateGridSpecs();
            } else {
                this.checkColorPicker(mouseX, mouseY);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.mouseClickMove: " + LogFormatter.toString(t));
        }
        return super.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        try {
            super.func_231044_a_(mouseX, mouseY, mouseButton);
            if (mouseButton == 0) {
                this.checkColorPicker(mouseX, mouseY);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.mouseClicked: " + LogFormatter.toString(t));
        }
        return true;
    }

    protected void checkColorPicker(double mouseX, double mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            int x = (int)(mouseX - (double)((int)this.colorPickRect.x));
            int y = (int)(mouseY - (double)((int)this.colorPickRect.y));
            this.activeColor = this.colorPickImg.getRGB(x, y);
            GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
            activeSpec.setColorCoords(x, y);
            this.updateGridSpecs();
        }
    }

    protected void updatePreview(MapType mapType) {
        this.activeMapType = mapType;
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        this.activeColor = activeSpec.getColor();
        this.buttonOpacity.setValue((int)(activeSpec.alpha * 100.0f));
        this.buttonStyle.setValue(activeSpec.style);
        this.checkDay.setToggled(mapType.isDay());
        this.checkNight.setToggled(mapType.isNight());
        this.checkUnderground.setToggled(mapType.isUnderground());
        this.buttonDay.setToggled(mapType.isDay());
        this.buttonNight.setToggled(mapType.isNight());
        this.buttonUnderground.setToggled(mapType.isUnderground());
    }

    protected void updateGridSpecs() {
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        GridSpec newSpec = new GridSpec(this.buttonStyle.getField().get(), new Color(this.activeColor), (float)this.buttonOpacity.getValue() / 100.0f).setColorCoords(colorX, colorY);
        if (this.checkDay.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.day((RegistryKey<World>)World.field_234918_g_), newSpec);
        }
        if (this.checkNight.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.night((RegistryKey<World>)World.field_234918_g_), newSpec);
        }
        if (this.checkUnderground.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.underground(0, (RegistryKey<World>)World.field_234918_g_), newSpec);
        }
    }

    protected void saveAndClose() {
        this.updateGridSpecs();
        JourneymapClient.getInstance().getCoreProperties().gridSpecs.updateFrom(this.gridSpecs);
        JourneymapClient.getInstance().getCoreProperties().save();
        this.closeAndReturn();
    }

    protected void resetGridSpecs() {
        if (this.checkDay.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.day((RegistryKey<World>)World.field_234918_g_), GridSpecs.DEFAULT_DAY.clone());
        }
        if (this.checkNight.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.night((RegistryKey<World>)World.field_234918_g_), GridSpecs.DEFAULT_NIGHT.clone());
        }
        if (this.checkUnderground.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.underground(0, (RegistryKey<World>)World.field_234918_g_), GridSpecs.DEFAULT_UNDERGROUND.clone());
        }
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        this.func_231160_c_();
    }

    @Override
    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((Screen)returnDisplayStack.pop());
        }
    }

    public TextureImpl getTileSample(MapType mapType) {
        if (mapType.isNight()) {
            return TextureCache.getTexture(TextureCache.TileSampleNight);
        }
        if (mapType.isUnderground()) {
            return TextureCache.getTexture(TextureCache.TileSampleUnderground);
        }
        return TextureCache.getTexture(TextureCache.TileSampleDay);
    }
}

