/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.component.BooleanPropertyButton;
import journeymap.client.ui.theme.Theme;
import journeymap.common.properties.config.BooleanField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.opengl.GL11;

public class ThemeButton
extends BooleanPropertyButton {
    protected Theme theme;
    protected Theme.Control.ButtonSpec buttonSpec;
    protected TextureImpl textureOn;
    protected TextureImpl textureHover;
    protected TextureImpl textureOff;
    protected TextureImpl textureDisabled;
    protected TextureImpl textureIcon;
    protected String iconName;
    protected List<IReorderingProcessor> additionalTooltips;
    protected boolean staysOn;
    private boolean displayClickToggle = true;

    public void setDisplayClickToggle(boolean displayClickToggle) {
        this.displayClickToggle = displayClickToggle;
    }

    public ThemeButton(Theme theme, String rawLabel, String iconName, Button.IPressable onPress) {
        this(theme, Constants.getString(rawLabel), Constants.getString(rawLabel), false, iconName, onPress);
    }

    public ThemeButton(Theme theme, String labelOn, String labelOff, boolean toggled, String iconName, Button.IPressable onPress) {
        super(labelOn, labelOff, null, onPress);
        this.iconName = iconName;
        this.setToggled(toggled);
        this.updateTheme(theme);
    }

    protected ThemeButton(Theme theme, String labelOn, String labelOff, String iconName, BooleanField field, Button.IPressable onPress) {
        super(labelOn, labelOff, field, onPress);
        this.iconName = iconName;
        this.updateTheme(theme);
    }

    public boolean isStaysOn() {
        return this.staysOn;
    }

    public void setStaysOn(boolean staysOn) {
        this.staysOn = staysOn;
    }

    public void updateTheme(Theme theme) {
        this.theme = theme;
        this.buttonSpec = this.getButtonSpec(theme);
        if (this.buttonSpec.useThemeImages) {
            String pattern = this.getPathPattern();
            String prefix = this.buttonSpec.prefix;
            this.textureOn = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "on"));
            this.textureOff = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "off"));
            this.textureHover = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "hover"));
            this.textureDisabled = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "disabled"));
        } else {
            this.textureOn = null;
            this.textureOff = null;
            this.textureHover = null;
            this.textureDisabled = null;
        }
        this.textureIcon = TextureCache.getThemeTexture(theme, String.format("icon/%s.png", this.iconName));
        this.func_230991_b_(this.buttonSpec.width);
        this.setHeight(this.buttonSpec.height);
        this.setToggled(false, false);
    }

    public boolean hasValidTextures() {
        if (this.buttonSpec.useThemeImages) {
            return GL11.glIsTexture((int)this.textureOn.getGlTextureId(false)) && GL11.glIsTexture((int)this.textureOff.getGlTextureId(false));
        }
        return true;
    }

    protected String getPathPattern() {
        return "control/%sbutton_%s.png";
    }

    protected Theme.Control.ButtonSpec getButtonSpec(Theme theme) {
        return theme.control.button;
    }

    public Theme.Control.ButtonSpec getButtonSpec() {
        return this.buttonSpec;
    }

    protected TextureImpl getActiveTexture(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.textureDisabled;
        }
        return this.toggled != false ? this.textureOn : this.textureOff;
    }

    protected Theme.ColorSpec getIconColor(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.buttonSpec.iconDisabled;
        }
        if (isMouseOver) {
            return this.toggled != false ? this.buttonSpec.iconHoverOn : this.buttonSpec.iconHoverOff;
        }
        return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.iconOn : this.buttonSpec.iconOff) : this.buttonSpec.iconOff;
    }

    protected Theme.ColorSpec getButtonColor(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.buttonSpec.buttonDisabled;
        }
        if (isMouseOver) {
            return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.buttonHoverOn : this.buttonSpec.buttonHoverOff) : this.buttonSpec.buttonHoverOff;
        }
        return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.buttonOn : this.buttonSpec.buttonOff) : this.buttonSpec.buttonOff;
    }

    @Override
    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float ticks) {
        if (!this.isVisible()) {
            return;
        }
        boolean hover = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
        this.setMouseOver(hover);
        TextureImpl activeTexture = this.getActiveTexture(this.field_230692_n_);
        Theme.ColorSpec iconColorSpec = this.getIconColor(this.field_230692_n_);
        int drawX = this.getX();
        int drawY = this.getY();
        if (this.buttonSpec.useThemeImages) {
            Theme.ColorSpec buttonColorSpec = this.getButtonColor(this.field_230692_n_);
            float buttonScale = 1.0f;
            if (this.buttonSpec.width != activeTexture.getWidth()) {
                buttonScale = 1.0f * (float)this.buttonSpec.width / (float)activeTexture.getWidth();
            }
            DrawUtil.drawColoredImage(mStack, activeTexture, buttonColorSpec.getColor(), buttonColorSpec.alpha, drawX, drawY, buttonScale, 0.0);
        } else {
            this.drawNativeButton(mStack, mouseX, mouseY);
        }
        float iconScale = 1.0f;
        if (this.theme.icon.width != this.textureIcon.getWidth()) {
            iconScale = 1.0f * (float)this.theme.icon.width / (float)this.textureIcon.getWidth();
        }
        if (!this.buttonSpec.useThemeImages) {
            DrawUtil.drawColoredImage(mStack, this.textureIcon, 0, iconColorSpec.alpha, (double)drawX + 0.5, (double)drawY + 0.5, iconScale, 0.0);
        }
        DrawUtil.drawColoredImage(mStack, this.textureIcon, iconColorSpec.getColor(), iconColorSpec.alpha, drawX, drawY, iconScale, 0.0);
    }

    public void drawNativeButton(MatrixStack mStack, int mouseX, int mouseY) {
        int magic = 20;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(field_230687_i_);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = this.isEnabled() ? (this.func_230449_g_() ? 2 : 1) : 0;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        GuiUtils.drawTexturedModalRect((int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (int)(46 + k * magic), (int)(this.field_230688_j_ / 2), (int)this.field_230689_k_, (float)this.func_230927_p_());
        GuiUtils.drawTexturedModalRect((int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)this.field_230691_m_, (int)(200 - this.field_230688_j_ / 2), (int)(46 + k * magic), (int)(this.field_230688_j_ / 2), (int)this.field_230689_k_, (float)this.func_230927_p_());
        this.func_231045_a_(mouseX, mouseY, 0, this.field_230690_l_, this.field_230691_m_);
        int l = 0xE0E0E0;
    }

    public void setAdditionalTooltips(List<IReorderingProcessor> additionalTooltips) {
        this.additionalTooltips = additionalTooltips;
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        if (!this.field_230694_p_) {
            return null;
        }
        List<IReorderingProcessor> list = super.getTooltip();
        String styleCode = null;
        styleCode = !this.isEnabled() ? this.buttonSpec.tooltipDisabledStyle : (this.toggled != false ? this.buttonSpec.tooltipOnStyle : this.buttonSpec.tooltipOffStyle);
        Style style = styleCode.isEmpty() || "".equals(styleCode) ? Style.field_240709_b_ : Style.field_240709_b_.func_240721_b_(TextFormatting.func_211165_a((char)styleCode.charAt(1)));
        list.add(0, IReorderingProcessor.func_242239_a((String)this.func_230458_i_().getString(), (Style)style));
        if (this.additionalTooltips != null) {
            list.addAll(this.additionalTooltips);
        }
        return list;
    }
}

