/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.function.Supplier;
import journeymap.common.Journeymap;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ServerAdminSavePropPacket {
    private Integer type;
    private String payload;
    private String dimension;

    public ServerAdminSavePropPacket() {
    }

    public ServerAdminSavePropPacket(Integer type, String payload, String dimension) {
        this.payload = payload;
        this.type = type;
        this.dimension = dimension;
    }

    public int getType() {
        return this.type;
    }

    public String getPayload() {
        return this.payload;
    }

    public ServerAdminSavePropPacket(PacketBuffer buf) {
        try {
            if (buf.capacity() > 1) {
                buf.readByte();
                this.type = buf.readInt();
                this.dimension = buf.func_150789_c(Short.MAX_VALUE);
                this.payload = buf.func_150789_c(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for admin save: %s", t));
        }
    }

    public void encode(PacketBuffer buf) {
        try {
            if (this.payload != null && this.type != null && this.dimension != null) {
                buf.writeByte(42);
                buf.writeInt(this.type.intValue());
                buf.func_180714_a(this.dimension);
                buf.func_180714_a(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for admin save:" + t);
        }
    }

    public static void handle(ServerAdminSavePropPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Journeymap.getInstance().getPacketHandler().onServerAdminSave(((NetworkEvent.Context)ctx.get()).getSender(), packet.type, packet.payload, packet.dimension);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

