/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.tile.ToolRackTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ToolRackBlock
extends BlockKitchen {
    public static final String name = "tool_rack";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "tool_rack");
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.func_208617_a((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] RENDER_SHAPES = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), Block.func_208617_a((double)14.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0)};

    public ToolRackBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(2.5f), registryName);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ToolRackTileEntity();
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        return SHAPES[facing.func_176745_a() - 2];
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        return RENDER_SHAPES[facing.func_176745_a() - 2];
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196000_l();
        if (facing == Direction.UP || facing == Direction.DOWN) {
            facing = Direction.NORTH;
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.SUCCESS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof BlockItem) {
            return ActionResultType.SUCCESS;
        }
        if (rayTraceResult.func_216347_e().field_72448_b > 0.25) {
            Direction stateFacing = (Direction)state.func_177229_b((Property)FACING);
            double hitX = rayTraceResult.func_216347_e().field_72450_a - (double)pos.func_177958_n();
            double hitZ = rayTraceResult.func_216347_e().field_72449_c - (double)pos.func_177952_p();
            double hit = hitX;
            switch (stateFacing) {
                case NORTH: {
                    hit = hitX;
                    break;
                }
                case SOUTH: {
                    hit = 1.0 - hitX;
                    break;
                }
                case WEST: {
                    hit = 1.0 - hitZ;
                    break;
                }
                case EAST: {
                    hit = hitZ;
                }
            }
            int hitSlot = hit > 0.5 ? 0 : 1;
            ToolRackTileEntity tileToolRack = (ToolRackTileEntity)world.func_175625_s(pos);
            if (tileToolRack != null) {
                if (!heldItem.func_190926_b()) {
                    ItemStack oldToolItem = tileToolRack.getItemHandler().getStackInSlot(hitSlot);
                    ItemStack toolItem = heldItem.func_77979_a(1);
                    if (!oldToolItem.func_190926_b()) {
                        if (!player.field_71071_by.func_70441_a(oldToolItem)) {
                            player.func_71019_a(oldToolItem, false);
                        }
                        tileToolRack.getItemHandler().setStackInSlot(hitSlot, toolItem);
                    } else {
                        tileToolRack.getItemHandler().setStackInSlot(hitSlot, toolItem);
                    }
                } else {
                    ItemStack itemStack = tileToolRack.getItemHandler().getStackInSlot(hitSlot);
                    if (!itemStack.func_190926_b()) {
                        tileToolRack.getItemHandler().setStackInSlot(hitSlot, ItemStack.field_190927_a);
                        player.func_184611_a(hand, itemStack);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.SUCCESS;
    }
}

