/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.blay09.mods.cookingforblockheads.tile.FruitBasketTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class FruitBasketRenderer
extends TileEntityRenderer<FruitBasketTileEntity> {
    public FruitBasketRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(FruitBasketTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World world = tileEntity.func_145831_w();
        if (world == null) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.5, 0.0);
        RenderUtils.applyBlockAngle(matrixStack, tileEntity.func_195044_w());
        matrixStack.func_227862_a_(0.25f, 0.25f, 0.25f);
        int itemsPerRow = 7;
        for (int i = 0; i < tileEntity.getItemHandler().getSlots(); ++i) {
            ItemStack itemStack = tileEntity.getItemHandler().getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            int rowIndex = i % itemsPerRow;
            int colIndex = i / itemsPerRow;
            float antiZFight = (rowIndex % 2 != 0 ? 0.1f : 0.0f) + (float)i * 0.01f;
            float curX = -0.75f + (float)rowIndex * 0.25f + (colIndex == 3 ? 0.15f : 0.0f);
            float curY = -1.35f;
            if (BlockKitchen.shouldBlockRenderLowered((IBlockReader)world, tileEntity.func_174877_v())) {
                curY -= 0.2f;
            }
            float curZ = -0.75f + (float)colIndex * 0.35f + antiZFight;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)curX, (double)curY, (double)curZ);
            matrixStack.func_227863_a_(new Quaternion(25.0f, 0.0f, 0.0f, true));
            RenderUtils.renderItem(itemStack, combinedLight, matrixStack, buffer);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }
}

