/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.KitchenCounterBlock;
import net.blay09.mods.cookingforblockheads.container.CounterContainer;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModTileEntities;
import net.blay09.mods.cookingforblockheads.tile.util.DoorAnimator;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CounterTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider,
IMutableNameable {
    private final ItemStackHandler itemHandler;
    private final KitchenItemProvider itemProvider;
    private final DoorAnimator doorAnimator;
    private final LazyOptional<IItemHandler> itemHandlerCap;
    private final LazyOptional<IKitchenItemProvider> itemProviderCap;
    private ITextComponent customName;
    private boolean isFirstTick;
    private boolean isDirty;
    private DyeColor color;
    private Direction cachedFacing;
    private boolean cachedFlipped;

    public CounterTileEntity() {
        this(ModTileEntities.counter);
    }

    public CounterTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.itemHandler = new ItemStackHandler((Boolean)CookingForBlockheadsConfig.COMMON.largeCounters.get() != false ? 54 : 27){

            protected void onContentsChanged(int slot) {
                CounterTileEntity.this.isDirty = true;
                CounterTileEntity.this.func_70296_d();
            }
        };
        this.itemProvider = new KitchenItemProvider((IItemHandler)this.itemHandler);
        this.doorAnimator = new DoorAnimator(this, 1, 2);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
        this.itemProviderCap = LazyOptional.of(() -> this.itemProvider);
        this.isFirstTick = true;
        this.color = DyeColor.WHITE;
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen(SoundEvents.field_187657_V);
        this.doorAnimator.setSoundEventClose(SoundEvents.field_187651_T);
    }

    public void func_73660_a() {
        BlockState state;
        if (this.isFirstTick && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof KitchenCounterBlock) {
            this.cachedFacing = (Direction)state.func_177229_b((Property)KitchenCounterBlock.FACING);
            this.cachedFlipped = (Boolean)state.func_177229_b((Property)KitchenCounterBlock.FLIPPED);
            this.isFirstTick = false;
        }
        this.doorAnimator.update();
        if (this.isDirty) {
            VanillaPacketHandler.sendTileEntityUpdate(this);
            this.isDirty = false;
        }
    }

    public boolean func_145842_c(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.func_145842_c(id, type);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        CompoundNBT itemHandlerCompound = tagCompound.func_74775_l("ItemHandler");
        if (((Boolean)CookingForBlockheadsConfig.COMMON.largeCounters.get()).booleanValue() && itemHandlerCompound.func_74762_e("Size") < 54) {
            itemHandlerCompound.func_74768_a("Size", 54);
        }
        this.itemHandler.deserializeNBT(itemHandlerCompound);
        this.color = DyeColor.func_196056_a((int)tagCompound.func_74771_c("Color"));
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)tagCompound.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_218657_a("ItemHandler", (INBT)this.itemHandler.serializeNBT());
        tagCompound.func_74774_a("Color", (byte)this.color.func_196059_a());
        if (this.customName != null) {
            tagCompound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        this.doorAnimator.setForcedOpen(pkt.func_148857_g().func_74767_n("IsForcedOpen"));
        this.doorAnimator.setNumPlayersUsing(pkt.func_148857_g().func_74771_c("NumPlayersUsing"));
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tagCompound = new CompoundNBT();
        this.func_189515_b(tagCompound);
        tagCompound.func_74757_a("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tagCompound.func_74774_a("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
        return tagCompound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        LazyOptional result = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.itemHandlerCap);
        if (!result.isPresent()) {
            result = CapabilityKitchenItemProvider.CAPABILITY.orEmpty(capability, this.itemProviderCap);
        }
        if (result.isPresent()) {
            return result;
        }
        return super.getCapability(capability, facing);
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public Direction getFacing() {
        return this.cachedFacing == null ? Direction.NORTH : this.cachedFacing;
    }

    public boolean isFlipped() {
        return this.cachedFlipped;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new CounterContainer(i, playerInventory, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 1, 2));
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
        this.func_70296_d();
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Override
    public ITextComponent getDefaultName() {
        return new TranslationTextComponent("container.cookingforblockheads.counter");
    }
}

