/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.container.SpiceRackContainer;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModTileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SpiceRackTileEntity
extends TileEntity
implements INamedContainerProvider,
IMutableNameable {
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            SpiceRackTileEntity.this.func_70296_d();
            BlockState blockState = SpiceRackTileEntity.this.field_145850_b.func_180495_p(SpiceRackTileEntity.this.field_174879_c);
            SpiceRackTileEntity.this.field_145850_b.markAndNotifyBlock(SpiceRackTileEntity.this.field_174879_c, SpiceRackTileEntity.this.field_145850_b.func_175726_f(SpiceRackTileEntity.this.field_174879_c), blockState, blockState, 3, 512);
        }
    };
    private final KitchenItemProvider itemProvider = new KitchenItemProvider((IItemHandler)this.itemHandler);
    private final LazyOptional<IItemHandler> itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IKitchenItemProvider> itemProviderCap = LazyOptional.of(() -> this.itemProvider);
    private ITextComponent customName;

    public SpiceRackTileEntity() {
        super(ModTileEntities.spiceRack);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)tagCompound.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_218657_a("ItemHandler", (INBT)this.itemHandler.serializeNBT());
        if (this.customName != null) {
            tagCompound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        LazyOptional result = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.itemHandlerCap);
        if (!result.isPresent()) {
            result = CapabilityKitchenItemProvider.CAPABILITY.orEmpty(capability, this.itemProviderCap);
        }
        if (result.isPresent()) {
            return result;
        }
        return super.getCapability(capability, facing);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new SpiceRackContainer(i, playerInventory, this);
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
        this.func_70296_d();
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Override
    public ITextComponent getDefaultName() {
        return new TranslationTextComponent("container.cookingforblockheads.spice_rack");
    }
}

