/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.ExtraHeartRenderHandler;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.model.FallbackModelLoader;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.connected.ConnectedModel;
import slimeknights.mantle.client.model.fluid.FluidTextureModel;
import slimeknights.mantle.client.model.fluid.FluidsModel;
import slimeknights.mantle.client.model.inventory.InventoryModel;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.data.MantleTags;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.util.OffhandCooldownTracker;

@Mod.EventBusSubscriber(modid="mantle", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_219534_a((IFutureReloadListener)ModelHelper.LISTENER);
        }
        event.enqueueWork(() -> RegistrationHelper.forEachWoodType(Atlases::addWoodType));
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("connected"), (IModelLoader)ConnectedModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("item_layer"), (IModelLoader)MantleItemLayerModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("colored_block"), (IModelLoader)ColoredBlockModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("fallback"), (IModelLoader)FallbackModelLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("nbt_key"), (IModelLoader)NBTKeyModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("retextured"), (IModelLoader)RetexturedModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("fluid_texture"), (IModelLoader)FluidTextureModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("inventory"), (IModelLoader)InventoryModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Mantle.getResource("fluids"), (IModelLoader)FluidsModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_219534_a((IFutureReloadListener)new BookLoader());
        }
        MinecraftForge.EVENT_BUS.register((Object)new ExtraHeartRenderHandler());
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderGameOverlayEvent.Post.class, ClientEvents::renderOffhandAttackIndicator);
    }

    private static void renderOffhandAttackIndicator(RenderGameOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        GameSettings settings = minecraft.field_71474_y;
        if (minecraft.field_71439_g == null || minecraft.field_71442_b == null || minecraft.field_71442_b.func_178889_l() == GameType.SPECTATOR || settings.field_186716_M == AttackIndicatorStatus.OFF) {
            return;
        }
        ItemStack held = minecraft.field_71439_g.func_184592_cb();
        if (!MantleTags.Items.OFFHAND_COOLDOWN.func_230235_a_((Object)held.func_77973_b())) {
            return;
        }
        float cooldown = OffhandCooldownTracker.getCooldown((PlayerEntity)minecraft.field_71439_g);
        if (cooldown >= 1.0f) {
            return;
        }
        MatrixStack matrixStack = event.getMatrixStack();
        switch (settings.field_186716_M) {
            case CROSSHAIR: {
                if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS || !minecraft.field_71474_y.func_243230_g().func_243192_a() || settings.field_74330_P && !settings.field_74319_N && !minecraft.field_71439_g.func_175140_cp() && !settings.field_178879_v) break;
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int scaledHeight = minecraft.func_228018_at_().func_198087_p();
                int y = scaledHeight / 2 - 14 + 2 * (scaledHeight % 2);
                int x = minecraft.func_228018_at_().func_198107_o() / 2 - 8;
                int width = (int)(cooldown * 17.0f);
                minecraft.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                minecraft.field_71456_v.func_238474_b_(matrixStack, x, y, 36, 94, 16, 4);
                minecraft.field_71456_v.func_238474_b_(matrixStack, x, y, 52, 94, width, 4);
                break;
            }
            case HOTBAR: {
                if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR || minecraft.field_175622_Z != minecraft.field_71439_g) break;
                int centerWidth = minecraft.func_228018_at_().func_198107_o() / 2;
                int y = minecraft.func_228018_at_().func_198087_p() - 20;
                int x = minecraft.field_71439_g.func_184591_cq() == HandSide.RIGHT ? centerWidth - 91 - 22 - 32 : centerWidth + 91 + 6 + 32;
                minecraft.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                int l1 = (int)(cooldown * 19.0f);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                minecraft.field_71456_v.func_238474_b_(matrixStack, x, y, 0, 94, 18, 18);
                minecraft.field_71456_v.func_238474_b_(matrixStack, x, y + 18 - l1, 18, 112 - l1, 18, l1);
            }
        }
    }
}

