/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.element.ItemStackData;
import slimeknights.mantle.client.screen.book.ArrowButton;
import slimeknights.mantle.client.screen.book.Textures;
import slimeknights.mantle.client.screen.book.element.BookElement;

@OnlyIn(value=Dist.CLIENT)
public class BookScreen
extends Screen {
    public static boolean debug = false;
    public static final int TEX_SIZE = 512;
    public static int PAGE_MARGIN = 8;
    public static int PAGE_PADDING_TOP = 4;
    public static int PAGE_PADDING_BOT = 4;
    public static int PAGE_PADDING_LEFT = 8;
    public static int PAGE_PADDING_RIGHT = 0;
    public static float PAGE_SCALE = 1.0f;
    public static int PAGE_WIDTH_UNSCALED = 206;
    public static int PAGE_HEIGHT_UNSCALED = 200;
    public static int PAGE_WIDTH;
    public static int PAGE_HEIGHT;
    private ArrowButton previousArrow;
    private ArrowButton nextArrow;
    private ArrowButton backArrow;
    private ArrowButton indexArrow;
    public final BookData book;
    @Nullable
    private Consumer<String> pageUpdater;
    @Nullable
    private Consumer<?> bookPickup;
    private int page = -1;
    private int oldPage = -2;
    private final ArrayList<BookElement> leftElements = new ArrayList();
    private final ArrayList<BookElement> rightElements = new ArrayList();
    public AdvancementCache advancementCache;
    private double[] lastClick;
    private double[] lastDrag;

    public static void initWidthsAndHeights() {
        PAGE_WIDTH = (int)((float)(PAGE_WIDTH_UNSCALED - (PAGE_PADDING_LEFT + PAGE_PADDING_RIGHT + PAGE_MARGIN + PAGE_MARGIN)) / PAGE_SCALE);
        PAGE_HEIGHT = (int)((float)(PAGE_HEIGHT_UNSCALED - (PAGE_PADDING_TOP + PAGE_PADDING_BOT + PAGE_MARGIN + PAGE_MARGIN)) / PAGE_SCALE);
    }

    public BookScreen(ITextComponent title, BookData book, String page, @Nullable Consumer<String> pageUpdater, @Nullable Consumer<?> bookPickup) {
        super(title);
        this.book = book;
        this.pageUpdater = pageUpdater;
        this.bookPickup = bookPickup;
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.field_230712_o_ = this.field_230706_i_.field_71466_p;
        BookScreen.initWidthsAndHeights();
        this.advancementCache = new AdvancementCache();
        if (this.field_230706_i_.field_71439_g != null) {
            this.field_230706_i_.field_71439_g.field_71174_a.func_191982_f().func_192798_a((ClientAdvancementManager.IListener)this.advancementCache);
        }
        this.openPage(book.findPageNumber(page, this.advancementCache));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230706_i_ == null) {
            return;
        }
        BookScreen.initWidthsAndHeights();
        FontRenderer fontRenderer = this.book.fontRenderer;
        if (fontRenderer == null) {
            fontRenderer = this.field_230706_i_.field_71466_p;
        }
        if (debug) {
            int n = fontRenderer.func_78256_a("DEBUG") + 4;
            fontRenderer.getClass();
            BookScreen.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)n, (int)(9 + 4), (int)0x55000000);
            fontRenderer.func_238421_b_(matrixStack, "DEBUG", 2.0f, 2.0f, -1);
        }
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.pushMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        float coverR = (float)(this.book.appearance.coverColor >> 16 & 0xFF) / 255.0f;
        float coverG = (float)(this.book.appearance.coverColor >> 8 & 0xFF) / 255.0f;
        float coverB = (float)(this.book.appearance.coverColor & 0xFF) / 255.0f;
        TextureManager render = this.field_230706_i_.field_71446_o;
        if (this.page == -1) {
            render.func_110577_a(Textures.TEX_BOOKFRONT);
            RenderHelper.func_74518_a();
            RenderSystem.color3f((float)coverR, (float)coverG, (float)coverB);
            BookScreen.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ / 2 - PAGE_WIDTH_UNSCALED / 2), (int)(this.field_230709_l_ / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)0.0f, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (int)512, (int)512);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.book.appearance.title.isEmpty()) {
                BookScreen.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ / 2 - PAGE_WIDTH_UNSCALED / 2), (int)(this.field_230709_l_ / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (int)512, (int)512);
                RenderSystem.pushMatrix();
                float scale = fontRenderer.func_78256_a(this.book.appearance.title) <= 67 ? 2.5f : 2.0f;
                RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
                String string = this.book.appearance.title;
                float f = (float)(this.field_230708_k_ / 2) / scale + 3.0f - (float)(fontRenderer.func_78256_a(this.book.appearance.title) / 2);
                int n = this.field_230709_l_ / 2;
                fontRenderer.getClass();
                fontRenderer.func_238405_a_(matrixStack, string, f, (float)(n - 9 / 2) / scale - 4.0f, 11436032);
                RenderSystem.popMatrix();
            }
            if (!this.book.appearance.subtitle.isEmpty()) {
                RenderSystem.pushMatrix();
                RenderSystem.scalef((float)1.5f, (float)1.5f, (float)1.0f);
                String string = this.book.appearance.subtitle;
                float f = (float)(this.field_230708_k_ / 2) / 1.5f + 7.0f - (float)(fontRenderer.func_78256_a(this.book.appearance.subtitle) / 2);
                int n = this.field_230709_l_ / 2 + 100;
                fontRenderer.getClass();
                fontRenderer.func_238405_a_(matrixStack, string, f, (float)(n - 9 * 2) / 1.5f, 11436032);
                RenderSystem.popMatrix();
            }
        } else {
            render.func_110577_a(Textures.TEX_BOOK);
            RenderHelper.func_74518_a();
            RenderSystem.color3f((float)coverR, (float)coverG, (float)coverB);
            BookScreen.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ / 2 - PAGE_WIDTH_UNSCALED), (int)(this.field_230709_l_ / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)0.0f, (int)(PAGE_WIDTH_UNSCALED * 2), (int)PAGE_HEIGHT_UNSCALED, (int)512, (int)512);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.page != 0) {
                BookElement element;
                int i;
                BookScreen.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ / 2 - PAGE_WIDTH_UNSCALED), (int)(this.field_230709_l_ / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)0.0f, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (int)512, (int)512);
                RenderSystem.pushMatrix();
                this.drawerTransform(false);
                RenderSystem.scalef((float)PAGE_SCALE, (float)PAGE_SCALE, (float)1.0f);
                if (this.book.appearance.drawPageNumbers) {
                    String pNum = (this.page - 1) * 2 + 2 + "";
                    fontRenderer.func_238421_b_(matrixStack, pNum, (float)(PAGE_WIDTH / 2 - fontRenderer.func_78256_a(pNum) / 2), (float)(PAGE_HEIGHT - 10), -5592406);
                }
                int mX = this.getMouseX(false);
                int mY = this.getMouseY();
                for (i = 0; i < this.leftElements.size(); ++i) {
                    element = this.leftElements.get(i);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.draw(matrixStack, mX, mY, partialTicks, fontRenderer);
                }
                for (i = 0; i < this.leftElements.size(); ++i) {
                    element = this.leftElements.get(i);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.drawOverlay(matrixStack, mX, mY, partialTicks, fontRenderer);
                }
                RenderSystem.popMatrix();
            }
            render.func_110577_a(Textures.TEX_BOOK);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74518_a();
            int fullPageCount = this.book.getFullPageCount(this.advancementCache);
            if (this.page < fullPageCount - 1 || this.book.getPageCount(this.advancementCache) % 2 != 0) {
                BookElement element;
                int i;
                BookScreen.func_238463_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - PAGE_HEIGHT_UNSCALED / 2), (float)PAGE_WIDTH_UNSCALED, (float)PAGE_HEIGHT_UNSCALED, (int)PAGE_WIDTH_UNSCALED, (int)PAGE_HEIGHT_UNSCALED, (int)512, (int)512);
                RenderSystem.pushMatrix();
                this.drawerTransform(true);
                RenderSystem.scalef((float)PAGE_SCALE, (float)PAGE_SCALE, (float)1.0f);
                if (this.book.appearance.drawPageNumbers) {
                    String pNum = (this.page - 1) * 2 + 3 + "";
                    fontRenderer.func_238421_b_(matrixStack, pNum, (float)(PAGE_WIDTH / 2 - fontRenderer.func_78256_a(pNum) / 2), (float)(PAGE_HEIGHT - 10), -5592406);
                }
                int mX = this.getMouseX(true);
                int mY = this.getMouseY();
                for (i = 0; i < this.rightElements.size(); ++i) {
                    element = this.rightElements.get(i);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.draw(matrixStack, mX, mY, partialTicks, fontRenderer);
                }
                for (i = 0; i < this.rightElements.size(); ++i) {
                    element = this.rightElements.get(i);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    element.drawOverlay(matrixStack, mX, mY, partialTicks, fontRenderer);
                }
                RenderSystem.popMatrix();
            }
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.previousArrow = (ArrowButton)this.func_230480_a_((Widget)new ArrowButton(-50, -50, ArrowButton.ArrowType.PREV, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            --this.page;
            if (this.page < -1) {
                this.page = -1;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.nextArrow = (ArrowButton)this.func_230480_a_((Widget)new ArrowButton(-50, -50, ArrowButton.ArrowType.NEXT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            ++this.page;
            int fullPageCount = this.book.getFullPageCount(this.advancementCache);
            if (this.page >= fullPageCount) {
                this.page = fullPageCount - 1;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.backArrow = (ArrowButton)this.func_230480_a_((Widget)new ArrowButton(this.field_230708_k_ / 2 - 9, this.field_230709_l_ / 2 + 5 + PAGE_HEIGHT / 2, ArrowButton.ArrowType.LEFT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            if (this.oldPage >= -1) {
                this.page = this.oldPage;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.indexArrow = (ArrowButton)this.func_230480_a_((Widget)new ArrowButton(this.field_230708_k_ / 2 - PAGE_WIDTH_UNSCALED - 9, this.field_230709_l_ / 2 - PAGE_HEIGHT_UNSCALED / 2, ArrowButton.ArrowType.BACK_UP, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            this.openPage(this.book.findPageNumber("index.page1"));
            this.oldPage = -2;
            this.buildPages();
        }));
        if (this.bookPickup != null) {
            int margin = 10;
            if (this.field_230709_l_ / 2 + PAGE_HEIGHT_UNSCALED / 2 + margin + 20 >= this.field_230709_l_) {
                margin = 0;
            }
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 98, this.field_230709_l_ / 2 + PAGE_HEIGHT_UNSCALED / 2 + margin, 196, 20, (ITextComponent)new TranslationTextComponent("lectern.take_book"), p_212998_1_ -> {
                this.func_231175_as__();
                this.bookPickup.accept(null);
            }));
        }
        this.buildPages();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.previousArrow.field_230694_p_ = this.page != -1;
        this.nextArrow.field_230694_p_ = this.page + 1 < this.book.getFullPageCount(this.advancementCache);
        boolean bl = this.backArrow.field_230694_p_ = this.oldPage >= -1;
        if (this.page == -1) {
            this.nextArrow.field_230690_l_ = this.field_230708_k_ / 2 + 80;
            this.indexArrow.field_230694_p_ = false;
        } else {
            this.previousArrow.field_230690_l_ = this.field_230708_k_ / 2 - 184;
            this.nextArrow.field_230690_l_ = this.field_230708_k_ / 2 + 165;
            this.indexArrow.field_230694_p_ = this.book.findSection("index") != null && (this.page - 1) * 2 + 2 > this.book.findSection("index").getPageCount();
        }
        this.previousArrow.field_230691_m_ = this.field_230709_l_ / 2 + 75;
        this.nextArrow.field_230691_m_ = this.field_230709_l_ / 2 + 75;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        super.func_231046_a_(keyCode, scanCode, modifiers);
        switch (keyCode) {
            case 65: 
            case 263: {
                --this.page;
                if (this.page < -1) {
                    this.page = -1;
                }
                this.oldPage = -2;
                this.buildPages();
                return true;
            }
            case 68: 
            case 262: {
                ++this.page;
                int fullPageCount = this.book.getFullPageCount(this.advancementCache);
                if (this.page >= fullPageCount) {
                    this.page = fullPageCount - 1;
                }
                this.oldPage = -2;
                this.buildPages();
                return true;
            }
            case 292: {
                debug = !debug;
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231043_a_(double unKnown1, double unKnown2, double scrollDelta) {
        if (scrollDelta < 0.0) {
            ++this.page;
            int fullPageCount = this.book.getFullPageCount(this.advancementCache);
            if (this.page >= fullPageCount) {
                this.page = fullPageCount - 1;
            }
            this.oldPage = -2;
            this.buildPages();
            return true;
        }
        if (scrollDelta > 0.0) {
            --this.page;
            if (this.page < -1) {
                this.page = -1;
            }
            this.oldPage = -2;
            this.buildPages();
            return true;
        }
        return super.func_231043_a_(scrollDelta, unKnown1, unKnown2);
    }

    public boolean func_231044_a_(double originalMouseX, double originalMouseY, int mouseButton) {
        boolean right = false;
        double mouseX = this.getMouseX(false);
        double mouseY = this.getMouseY();
        if (mouseX > (double)((float)PAGE_WIDTH + (float)(PAGE_MARGIN + PAGE_PADDING_LEFT) / PAGE_SCALE)) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        this.lastClick = new double[]{mouseX, mouseY};
        int oldPage = this.page;
        ImmutableList elementList = ImmutableList.copyOf(right ? this.rightElements : this.leftElements);
        for (BookElement element : elementList) {
            element.mouseClicked(mouseX, mouseY, mouseButton);
            if (this.page == oldPage) continue;
            return true;
        }
        return super.func_231044_a_(originalMouseX, originalMouseY, mouseButton);
    }

    public boolean func_231048_c_(double originalMouseX, double originalMouseY, int mouseButton) {
        boolean right = false;
        double mouseX = this.getMouseX(false);
        double mouseY = this.getMouseY();
        if (mouseX > (double)((float)PAGE_WIDTH + (float)(PAGE_MARGIN + PAGE_PADDING_LEFT) / PAGE_SCALE)) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int i = 0;
        while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
            BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
            element.mouseReleased(mouseX, mouseY, mouseButton);
            ++i;
        }
        this.lastClick = null;
        this.lastDrag = null;
        return super.func_231048_c_(originalMouseX, originalMouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean right = false;
        mouseX = this.getMouseX(false);
        mouseY = this.getMouseY();
        if (mouseX > (double)((float)PAGE_WIDTH + (float)(PAGE_MARGIN + PAGE_PADDING_LEFT) / PAGE_SCALE)) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        if (this.lastClick != null) {
            if (this.lastDrag == null) {
                this.lastDrag = new double[]{mouseX, mouseY};
            }
            int i = 0;
            while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
                BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
                element.mouseDragged(this.lastClick[0], this.lastClick[1], mouseX, mouseY, this.lastDrag[0], this.lastDrag[1], button);
                ++i;
            }
            this.lastDrag = new double[]{mouseX, mouseY};
        }
        return true;
    }

    public void func_231164_f_() {
        if (this.field_230706_i_ == null || this.field_230706_i_.field_71439_g == null) {
            return;
        }
        if (this.pageUpdater != null) {
            String pageStr = "";
            if (this.page >= 0) {
                PageData page;
                PageData pageData = page = this.page == 0 ? this.book.findPage(0, this.advancementCache) : this.book.findPage((this.page - 1) * 2 + 1, this.advancementCache);
                if (page == null) {
                    page = this.book.findPage((this.page - 1) * 2 + 2, this.advancementCache);
                }
                if (page != null && page.parent != null) {
                    pageStr = page.parent.name + "." + page.name;
                }
            }
            this.pageUpdater.accept(pageStr);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void drawerTransform(boolean rightSide) {
        if (rightSide) {
            RenderSystem.translatef((float)(this.field_230708_k_ / 2 + PAGE_PADDING_RIGHT + PAGE_MARGIN), (float)(this.field_230709_l_ / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN), (float)0.0f);
        } else {
            RenderSystem.translatef((float)(this.field_230708_k_ / 2 - PAGE_WIDTH_UNSCALED + PAGE_PADDING_LEFT + PAGE_MARGIN), (float)(this.field_230709_l_ / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN), (float)0.0f);
        }
    }

    protected float leftOffset(boolean rightSide) {
        if (rightSide) {
            return this.field_230708_k_ / 2 + PAGE_PADDING_RIGHT + PAGE_MARGIN;
        }
        return this.field_230708_k_ / 2 - PAGE_WIDTH_UNSCALED + PAGE_PADDING_LEFT + PAGE_MARGIN;
    }

    protected float topOffset() {
        return this.field_230709_l_ / 2 - PAGE_HEIGHT_UNSCALED / 2 + PAGE_PADDING_TOP + PAGE_MARGIN;
    }

    protected int getMouseX(boolean rightSide) {
        return (int)((Minecraft.func_71410_x().field_71417_B.func_198024_e() * (double)this.field_230708_k_ / (double)this.field_230706_i_.func_228018_at_().func_198109_k() - (double)this.leftOffset(rightSide)) / (double)PAGE_SCALE);
    }

    protected int getMouseY() {
        return (int)((Minecraft.func_71410_x().field_71417_B.func_198026_f() * (double)this.field_230709_l_ / (double)this.field_230706_i_.func_228018_at_().func_198091_l() - 1.0 - (double)this.topOffset()) / (double)PAGE_SCALE);
    }

    public int openPage(int page) {
        return this.openPage(page, false);
    }

    public int openPage(int page, boolean returner) {
        if (page < 0) {
            return -1;
        }
        int bookPage = page == 1 ? 0 : (page % 2 == 0 ? (page - 1) / 2 + 1 : (page - 2) / 2 + 1);
        if (bookPage >= -1 && bookPage < this.book.getFullPageCount(this.advancementCache)) {
            if (returner) {
                this.oldPage = this.page;
            }
            this._setPage(bookPage);
        }
        return page % 2 == 0 ? 0 : 1;
    }

    public void _setPage(int page) {
        this.page = page;
        this.buildPages();
    }

    public int getPage(int side) {
        if (this.page == 0 && side == 0) {
            return -1;
        }
        if (this.page == 0 && side == 1) {
            return 0;
        }
        if (side == 0) {
            return (this.page - 1) * 2 + 1;
        }
        if (side == 1) {
            return (this.page - 2) * 2 + 2;
        }
        return -1;
    }

    public int getPage_() {
        return this.page;
    }

    public ArrayList<BookElement> getElements(int side) {
        return side == 0 ? this.leftElements : (side == 1 ? this.rightElements : null);
    }

    public void openCover() {
        this._setPage(-1);
        this.leftElements.clear();
        this.rightElements.clear();
        this.buildPages();
    }

    public void itemClicked(ItemStack item) {
        StringActionProcessor.process(this.book.getItemAction(ItemStackData.getItemStackData(item, true)), this);
    }

    private void buildPages() {
        this.leftElements.clear();
        this.rightElements.clear();
        if (this.page == -1) {
            return;
        }
        if (this.page == 0) {
            PageData page = this.book.findPage(0, this.advancementCache);
            if (page != null) {
                page.content.build(this.book, this.rightElements, false);
            }
        } else {
            PageData leftPage = this.book.findPage((this.page - 1) * 2 + 1, this.advancementCache);
            PageData rightPage = this.book.findPage((this.page - 1) * 2 + 2, this.advancementCache);
            if (leftPage != null) {
                leftPage.content.build(this.book, this.leftElements, false);
            }
            if (rightPage != null) {
                rightPage.content.build(this.book, this.rightElements, true);
            }
        }
        for (BookElement element : this.leftElements) {
            element.parent = this;
        }
        for (BookElement element : this.rightElements) {
            element.parent = this;
        }
    }

    static {
        BookScreen.initWidthsAndHeights();
    }

    public static class AdvancementCache
    implements ClientAdvancementManager.IListener {
        private final HashMap<Advancement, AdvancementProgress> progress = new HashMap();
        private final HashMap<ResourceLocation, Advancement> nameCache = new HashMap();

        @Nullable
        public AdvancementProgress getProgress(String id) {
            return this.getProgress(this.getAdvancement(id));
        }

        @Nullable
        public AdvancementProgress getProgress(Advancement advancement) {
            return this.progress.get(advancement);
        }

        public Advancement getAdvancement(String id) {
            return this.nameCache.get(new ResourceLocation(id));
        }

        public void func_191933_a(Advancement advancement, AdvancementProgress advancementProgress) {
            this.progress.put(advancement, advancementProgress);
        }

        public void func_193982_e(@Nullable Advancement advancement) {
        }

        public void func_191931_a(Advancement advancement) {
            this.nameCache.put(advancement.func_192067_g(), advancement);
        }

        public void func_191928_b(Advancement advancement) {
            this.progress.remove(advancement);
            this.nameCache.remove(advancement.func_192067_g());
        }

        public void func_191932_c(Advancement advancement) {
            this.nameCache.put(advancement.func_192067_g(), advancement);
        }

        public void func_191929_d(Advancement advancement) {
            this.progress.remove(advancement);
            this.nameCache.remove(advancement.func_192067_g());
        }

        public void func_191930_a() {
            this.progress.clear();
            this.nameCache.clear();
        }
    }
}

