/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import slimeknights.mantle.recipe.RecipeHelper;

public class ReplaceItemLootModifier
extends LootModifier {
    private final Item original;
    private final Item replacement;

    protected ReplaceItemLootModifier(ILootCondition[] conditionsIn, Item original, Item replacement) {
        super(conditionsIn);
        this.original = original;
        this.replacement = replacement;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        return generatedLoot.stream().map(stack -> {
            if (stack.func_77973_b() == this.original) {
                return new ItemStack((IItemProvider)this.replacement, stack.func_190916_E());
            }
            return stack;
        }).collect(Collectors.toList());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ReplaceItemLootModifier> {
        public ReplaceItemLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            Item original = RecipeHelper.deserializeItem(JSONUtils.func_151200_h((JsonObject)object, (String)"original"), "original", Item.class);
            Item replacement = RecipeHelper.deserializeItem(JSONUtils.func_151200_h((JsonObject)object, (String)"replacement"), "replacement", Item.class);
            return new ReplaceItemLootModifier(conditions, original, replacement);
        }

        public JsonObject write(ReplaceItemLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.addProperty("original", Objects.requireNonNull(instance.original.getRegistryName()).toString());
            object.addProperty("replacement", Objects.requireNonNull(instance.replacement.getRegistryName()).toString());
            return object;
        }
    }
}

