/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.client;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.client.ClientConfig;
import com.craftingdead.core.client.renderer.entity.grenade.CylinderGrenadeRenderer;
import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.survival.ModDist;
import com.craftingdead.survival.client.renderer.entity.AdvancedZombieRenderer;
import com.craftingdead.survival.client.renderer.entity.GiantZombieRenderer;
import com.craftingdead.survival.client.renderer.entity.SupplyDropRenderer;
import com.craftingdead.survival.particles.SurvivalParticleTypes;
import com.craftingdead.survival.world.effect.SurvivalMobEffects;
import com.craftingdead.survival.world.entity.SurvivalEntityTypes;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class ClientDist
implements ModDist {
    public static final ClientConfig clientConfig;
    public static final ForgeConfigSpec clientConfigSpec;
    private static final ResourceLocation BLOOD;
    private static final ResourceLocation BLOOD_2;
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public ClientDist() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleClientSetup);
        modEventBus.addListener(this::handleParticleFactoryRegisterEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientConfigSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void handleClientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SurvivalEntityTypes.PIPE_GRENADE.get()), CylinderGrenadeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SurvivalEntityTypes.SUPPLY_DROP.get()), SupplyDropRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SurvivalEntityTypes.advancedZombie, AdvancedZombieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SurvivalEntityTypes.fastZombie, AdvancedZombieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SurvivalEntityTypes.tankZombie, AdvancedZombieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SurvivalEntityTypes.weakZombie, AdvancedZombieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SurvivalEntityTypes.policeZombie, AdvancedZombieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SurvivalEntityTypes.doctorZombie, AdvancedZombieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SurvivalEntityTypes.giantZombie, GiantZombieRenderer::new);
    }

    private void handleParticleFactoryRegisterEvent(ParticleFactoryRegisterEvent event) {
        ParticleManager particleEngine = this.minecraft.field_71452_i;
        particleEngine.func_215234_a((ParticleType)SurvivalParticleTypes.MILITARY_LOOT_GEN.get(), SpellParticle.Factory::new);
        particleEngine.func_215234_a((ParticleType)SurvivalParticleTypes.MEDIC_LOOT_GEN.get(), SpellParticle.Factory::new);
        particleEngine.func_215234_a((ParticleType)SurvivalParticleTypes.CIVILIAN_LOOT_GEN.get(), SpellParticle.Factory::new);
        particleEngine.func_215234_a((ParticleType)SurvivalParticleTypes.CIVILIAN_RARE_LOOT_GEN.get(), SpellParticle.Factory::new);
        particleEngine.func_215234_a((ParticleType)SurvivalParticleTypes.POLICE_LOOT_GEN.get(), SpellParticle.Factory::new);
    }

    @SubscribeEvent
    public void handleRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerExtension player;
        PlayerExtension playerExtension = player = this.minecraft.func_175606_aa() instanceof AbstractClientPlayerEntity ? (PlayerExtension)this.minecraft.func_175606_aa().getCapability(Capabilities.LIVING_EXTENSION).cast().orElse(null) : null;
        if (player == null) {
            return;
        }
        switch (event.getType()) {
            case ALL: {
                if (!this.minecraft.field_71442_b.func_78755_b() || player.isCombatModeEnabled()) break;
                float healthPercentage = ((AbstractClientPlayerEntity)player.getEntity()).func_110143_aJ() / ((AbstractClientPlayerEntity)player.getEntity()).func_110138_aP();
                if (!((Boolean)ClientDist.clientConfig.displayBlood.get()).booleanValue() || !(healthPercentage < 1.0f) || !((AbstractClientPlayerEntity)player.getEntity()).func_70644_a((Effect)SurvivalMobEffects.BLEEDING.get())) break;
                ClientDist.renderBlood(event.getWindow().func_198107_o(), event.getWindow().func_198087_p(), healthPercentage);
                break;
            }
        }
    }

    private static void renderBlood(int width, int height, float healthPercentage) {
        ResourceLocation res = healthPercentage <= 0.25f ? BLOOD_2 : BLOOD;
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderUtil.bind((ResourceLocation)res);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - healthPercentage));
        RenderUtil.blit((double)0.0, (double)0.0, (double)width, (double)height);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    static {
        Pair clientConfigPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        clientConfigSpec = (ForgeConfigSpec)clientConfigPair.getRight();
        clientConfig = (ClientConfig)clientConfigPair.getLeft();
        BLOOD = new ResourceLocation("craftingdeadsurvival", "textures/gui/blood.png");
        BLOOD_2 = new ResourceLocation("craftingdeadsurvival", "textures/gui/blood_2.png");
    }
}

