/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity;

import com.craftingdead.survival.world.entity.SurvivalEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class SupplyDropEntity
extends Entity
implements INamedContainerProvider {
    private Inventory inventory = new Inventory(54);
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;

    public SupplyDropEntity(EntityType<?> entityType, World world) {
        super(entityType, world);
    }

    public SupplyDropEntity(EntityType<?> entityType, World world, ResourceLocation lootTable, long lootTableSeed, double x, double y, double z) {
        this(entityType, world);
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public SupplyDropEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        this((EntityType)SurvivalEntityTypes.SUPPLY_DROP.get(), world);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70030_z();
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.009, 0.0));
        }
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public void remove(boolean keepData) {
        if (!this.field_70170_p.field_72995_K && !keepData) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.inventory);
        }
        super.remove(keepData);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("lootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("lootTable"));
            this.lootTableSeed = compound.func_74763_f("lootTableSeed");
        } else if (compound.func_74764_b("inventory")) {
            NonNullList items = NonNullList.func_191197_a((int)this.inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("inventory"), (NonNullList)items);
            this.inventory = new Inventory((ItemStack[])items.toArray((Object[])new ItemStack[0]));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.lootTable != null) {
            compound.func_74778_a("lootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.func_74772_a("lootTableSeed", this.lootTableSeed);
            }
        } else {
            NonNullList items = NonNullList.func_191197_a((int)this.inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                items.set(i, (Object)this.inventory.func_70301_a(i));
            }
            compound.func_218657_a("inventory", (INBT)ItemStackHelper.func_191282_a((CompoundNBT)compound.func_74775_l("inventory"), (NonNullList)items));
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        player.func_213829_a((INamedContainerProvider)this);
        return ActionResultType.PASS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.func_180431_b(source)) {
                return false;
            }
            this.func_70106_y();
            return true;
        }
        return true;
    }

    private void addLoot(@Nullable PlayerEntity player) {
        if (this.lootTable != null && this.field_70170_p.func_73046_m() != null) {
            LootTable lootTable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(this.lootTable);
            this.lootTable = null;
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216016_a(this.lootTableSeed);
            builder.func_216015_a(LootParameters.field_216284_d, (Object)this);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
            }
            lootTable.func_216118_a((IInventory)this.inventory, builder.func_216022_a(LootParameterSets.field_216261_b));
        }
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        this.addLoot(playerEntity);
        return ChestContainer.func_216984_b((int)id, (PlayerInventory)playerInventory, (IInventory)this.inventory);
    }
}

