/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.effect.SurvivalMobEffects;
import java.util.Random;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;

public class SurvivalPlayerHandler
implements PlayerHandler {
    public static final ResourceLocation ID = new ResourceLocation("craftingdeadsurvival", "player_handler");
    private static final float ZOMBIE_INFECTION_CHANCE = 0.1f;
    private static final Random random = new Random();
    private final PlayerExtension<?> player;
    private int soundLevel;

    public SurvivalPlayerHandler(PlayerExtension<?> player) {
        this.player = player;
    }

    public PlayerExtension<?> getPlayer() {
        return this.player;
    }

    public int getSoundLevel() {
        return this.soundLevel;
    }

    public void addSoundLevel(int soundLevel) {
        this.soundLevel += soundLevel;
    }

    public void playerTick() {
        if (!this.player.getLevel().func_201670_d()) {
            this.updateEffects();
            if (((PlayerEntity)this.player.getEntity()).field_70173_aa % 5 == 0 && this.soundLevel > 0) {
                --this.soundLevel;
            }
        }
    }

    private void updateEffects() {
        boolean invulnerable;
        boolean bl = invulnerable = ((PlayerEntity)this.player.getEntity()).field_71075_bZ.field_75102_a || this.player.getLevel().func_175659_aa() == Difficulty.PEACEFUL;
        if ((invulnerable || !((Boolean)CraftingDeadSurvival.serverConfig.bleedingEnabled.get()).booleanValue()) && ((PlayerEntity)this.player.getEntity()).func_70644_a((Effect)SurvivalMobEffects.BLEEDING.get())) {
            ((PlayerEntity)this.player.getEntity()).func_195063_d((Effect)SurvivalMobEffects.BLEEDING.get());
        }
        if ((invulnerable || !((Boolean)CraftingDeadSurvival.serverConfig.brokenLegsEnabled.get()).booleanValue()) && ((PlayerEntity)this.player.getEntity()).func_70644_a((Effect)SurvivalMobEffects.BROKEN_LEG.get())) {
            ((PlayerEntity)this.player.getEntity()).func_195063_d((Effect)SurvivalMobEffects.BROKEN_LEG.get());
        }
        if ((invulnerable || !((Boolean)CraftingDeadSurvival.serverConfig.infectionEnabled.get()).booleanValue()) && ((PlayerEntity)this.player.getEntity()).func_70644_a((Effect)SurvivalMobEffects.INFECTION.get())) {
            ((PlayerEntity)this.player.getEntity()).func_195063_d((Effect)SurvivalMobEffects.INFECTION.get());
        }
    }

    public boolean handleHurt(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof ZombieEntity) {
            this.infect(0.1f);
        }
        return false;
    }

    public void infect(float chance) {
        PlayerEntity playerEntity = (PlayerEntity)this.player.getEntity();
        if (!playerEntity.func_184812_l_() && playerEntity.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && playerEntity.func_70681_au().nextFloat() < chance && !playerEntity.func_70644_a((Effect)SurvivalMobEffects.INFECTION.get()) && ((Boolean)CraftingDeadSurvival.serverConfig.infectionEnabled.get()).booleanValue()) {
            playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("message.infected").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}), true);
            playerEntity.func_195064_c(new EffectInstance((Effect)SurvivalMobEffects.INFECTION.get(), 9999999));
        }
    }

    public float handleDamaged(DamageSource source, float amount) {
        boolean invulnerable;
        boolean bl = invulnerable = ((PlayerEntity)this.player.getEntity()).field_71075_bZ.field_75102_a || this.player.getLevel().func_175659_aa() == Difficulty.PEACEFUL;
        if (!invulnerable && ((Boolean)CraftingDeadSurvival.serverConfig.bleedingEnabled.get()).booleanValue() && (source.func_76364_f() != null || source.func_94541_c())) {
            float bleedChance = 0.1f * amount;
            if (random.nextFloat() < bleedChance && !((PlayerEntity)this.player.getEntity()).func_70644_a((Effect)SurvivalMobEffects.BLEEDING.get())) {
                ((PlayerEntity)this.player.getEntity()).func_146105_b((ITextComponent)new TranslationTextComponent("message.bleeding").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}), true);
                ((PlayerEntity)this.player.getEntity()).func_195064_c(new EffectInstance((Effect)SurvivalMobEffects.BLEEDING.get(), 9999999));
            }
        }
        if (!invulnerable && ((Boolean)CraftingDeadSurvival.serverConfig.brokenLegsEnabled.get()).booleanValue() && !((PlayerEntity)this.player.getEntity()).func_70644_a((Effect)SurvivalMobEffects.BROKEN_LEG.get()) && source == DamageSource.field_76379_h && (amount > 0.0f && random.nextInt(3) == 0 || amount > 4.0f)) {
            ((PlayerEntity)this.player.getEntity()).func_146105_b((ITextComponent)new TranslationTextComponent("message.broken_leg").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}), true);
            ((PlayerEntity)this.player.getEntity()).func_195064_c(new EffectInstance((Effect)SurvivalMobEffects.BROKEN_LEG.get(), 9999999, 4));
            ((PlayerEntity)this.player.getEntity()).func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 1));
        }
        return amount;
    }

    public void encode(PacketBuffer out, boolean writeAll) {
    }

    public void decode(PacketBuffer in) {
    }

    public boolean requiresSync() {
        return false;
    }
}

