/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.level.storage.loot;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class BuiltInLootTables {
    private static final Set<ResourceLocation> lootTables = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> READ_ONLY_LOOT_TABLES = Collections.unmodifiableSet(lootTables);
    public static final ResourceLocation MEDICAL_SUPPLY_DROP = BuiltInLootTables.register("supply_drops/medical");
    public static final ResourceLocation MILITARY_SUPPLY_DROP = BuiltInLootTables.register("supply_drops/military");

    private static ResourceLocation register(String location) {
        return BuiltInLootTables.register(new ResourceLocation("craftingdeadsurvival", location));
    }

    private static ResourceLocation register(ResourceLocation location) {
        if (lootTables.add(location)) {
            return location;
        }
        throw new IllegalArgumentException(location + " is already a registered built-in loot table");
    }

    public static Set<ResourceLocation> getLootTables() {
        return READ_ONLY_LOOT_TABLES;
    }
}

