/*
 * Decompiled with CFR 0.152.
 */
package net.wazworld.vbe.block;

import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.wazworld.vbe.vbe;

public class vbe_BlockFenceGate
extends FenceGateBlock {
    protected String name;
    protected Block blockParent;

    public vbe_BlockFenceGate(String name, Block blockIn, AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176466_a, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176465_b, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_176467_M, (Comparable)Boolean.valueOf(false)));
        this.name = name;
        this.blockParent = blockIn;
        this.setRegistryName(name);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockState newState;
        Block newBlock;
        ItemStack itemstack;
        if (BlockTags.field_200031_h.func_230235_a_((Object)this.getBlockParent()) && (itemstack = player.func_184586_b(handIn)).getToolTypes().contains(ToolType.AXE) && player.func_225608_bj_() && state.func_177230_c() != null && (newBlock = vbe.BLOCK_STRIPPING_MAP.get(state.func_177230_c())) != null) {
            newState = (BlockState)((BlockState)((BlockState)((BlockState)newBlock.func_176223_P().func_206870_a((Property)field_185512_D, state.func_177229_b((Property)field_185512_D))).func_206870_a((Property)field_176467_M, state.func_177229_b((Property)field_176467_M))).func_206870_a((Property)field_176466_a, state.func_177229_b((Property)field_176466_a))).func_206870_a((Property)field_176465_b, state.func_177229_b((Property)field_176465_b));
            worldIn.func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, newState, 11);
                itemstack.func_222118_a(1, (LivingEntity)player, p_220040_1_ -> p_220040_1_.func_213334_d(handIn));
            }
        }
        if (this.getBlockParent() == Blocks.field_196658_i && (itemstack = player.func_184586_b(handIn)).getToolTypes().contains(ToolType.SHOVEL) && player.func_225608_bj_() && state.func_177230_c() != null && (newBlock = vbe.BLOCK_STRIPPING_MAP.get(state.func_177230_c())) != null) {
            newState = (BlockState)((BlockState)((BlockState)((BlockState)newBlock.func_176223_P().func_206870_a((Property)field_185512_D, state.func_177229_b((Property)field_185512_D))).func_206870_a((Property)field_176467_M, state.func_177229_b((Property)field_176467_M))).func_206870_a((Property)field_176466_a, state.func_177229_b((Property)field_176466_a))).func_206870_a((Property)field_176465_b, state.func_177229_b((Property)field_176465_b));
            worldIn.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, newState, 11);
                itemstack.func_222118_a(1, (LivingEntity)player, p_220040_1_ -> p_220040_1_.func_213334_d(handIn));
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (this.getBlockParent() == Blocks.field_226907_mc_) {
            entityIn.func_184185_a(SoundEvents.field_226139_eT_, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                worldIn.func_72960_a(entityIn, (byte)54);
            }
            if (entityIn.func_225503_b_(fallDistance, 0.2f)) {
                entityIn.func_184185_a(this.field_149762_H.func_185842_g(), this.field_149762_H.func_185843_a() * 0.5f, this.field_149762_H.func_185847_b() * 0.75f);
            }
        } else {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (this.getBlockParent() == Blocks.field_226907_mc_ && this.isSliding(pos, entityIn)) {
            this.triggerSlideDownBlock(entityIn, pos);
            this.setSlideVelocity(entityIn);
            this.slideEffects(worldIn, entityIn);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    private boolean isSliding(BlockPos pos, Entity entity) {
        if (this.getBlockParent() == Blocks.field_226907_mc_) {
            if (entity.func_233570_aj_()) {
                return false;
            }
            if (entity.func_226278_cu_() > (double)pos.func_177956_o() + 0.9375 - 1.0E-7) {
                return false;
            }
            if (entity.func_213322_ci().field_72448_b >= -0.08) {
                return false;
            }
            double d0 = Math.abs((double)pos.func_177958_n() + 0.5 - entity.func_226277_ct_());
            double d1 = Math.abs((double)pos.func_177952_p() + 0.5 - entity.func_226281_cx_());
            double d2 = 0.4375 + (double)(entity.func_213311_cf() / 2.0f);
            return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
        }
        return false;
    }

    private void triggerSlideDownBlock(Entity entity, BlockPos pos) {
        if (this.getBlockParent() == Blocks.field_226907_mc_ && entity instanceof ServerPlayerEntity && entity.field_70170_p.func_82737_E() % 20L == 0L) {
            CriteriaTriggers.field_229864_K_.func_227152_a_((ServerPlayerEntity)entity, entity.field_70170_p.func_180495_p(pos));
        }
    }

    private void setSlideVelocity(Entity entity) {
        if (this.getBlockParent() == Blocks.field_226907_mc_) {
            Vector3d vector3d = entity.func_213322_ci();
            if (vector3d.field_72448_b < -0.13) {
                double d0 = -0.05 / vector3d.field_72448_b;
                entity.func_213317_d(new Vector3d(vector3d.field_72450_a * d0, -0.05, vector3d.field_72449_c * d0));
            } else {
                entity.func_213317_d(new Vector3d(vector3d.field_72450_a, -0.05, vector3d.field_72449_c));
            }
            entity.field_70143_R = 0.0f;
        }
    }

    private void slideEffects(World world, Entity entity) {
        if (this.getBlockParent() == Blocks.field_226907_mc_ && vbe_BlockFenceGate.hasSlideEffects(entity)) {
            if (world.field_73012_v.nextInt(5) == 0) {
                entity.func_184185_a(SoundEvents.field_226139_eT_, 1.0f, 1.0f);
            }
            if (!world.field_72995_K && world.field_73012_v.nextInt(5) == 0) {
                world.func_72960_a(entity, (byte)53);
            }
        }
    }

    private static boolean hasSlideEffects(Entity entity) {
        return entity instanceof LivingEntity || entity instanceof AbstractMinecartEntity || entity instanceof TNTEntity || entity instanceof BoatEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void entitySlideParticles(Entity entity) {
        vbe_BlockFenceGate.slideParticles(entity, 5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void livingSlideParticles(Entity entity) {
        vbe_BlockFenceGate.slideParticles(entity, 10);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void slideParticles(Entity entity, int particleCount) {
        if (entity.field_70170_p.field_72995_K) {
            BlockState blockstate = Blocks.field_226907_mc_.func_176223_P();
            for (int i = 0; i < particleCount; ++i) {
                entity.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Direction direction;
        if (this.getBlockParent() == Blocks.field_235399_ni_ && rand.nextInt(5) == 0 && (direction = Direction.func_239631_a_((Random)rand)) != Direction.UP) {
            BlockPos blockpos = pos.func_177972_a(direction);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (!stateIn.func_200132_m() || !blockstate.func_224755_d((IBlockReader)worldIn, blockpos, direction.func_176734_d())) {
                double d0 = direction.func_82601_c() == 0 ? rand.nextDouble() : 0.5 + (double)direction.func_82601_c() * 0.6;
                double d1 = direction.func_96559_d() == 0 ? rand.nextDouble() : 0.5 + (double)direction.func_96559_d() * 0.6;
                double d2 = direction.func_82599_e() == 0 ? rand.nextDouble() : 0.5 + (double)direction.func_82599_e() * 0.6;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_239816_ap_, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        if (this.getBlockParent() == Blocks.field_150343_Z) {
            return PushReaction.BLOCK;
        }
        if (this.getBlockParent() == Blocks.field_235399_ni_) {
            return PushReaction.BLOCK;
        }
        if (BlockTags.field_206952_E.func_230235_a_((Object)this)) {
            return PushReaction.DESTROY;
        }
        return PushReaction.NORMAL;
    }

    public Block getBlockParent() {
        return this.blockParent;
    }
}

