/*
 * Decompiled with CFR 0.152.
 */
package net.wazworld.vbe.block;

import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.wazworld.vbe.vbe;

public class vbe_BlockStairs
extends StairsBlock {
    protected String name;
    protected Block blockParent;

    public vbe_BlockStairs(String name, Block blockIn, AbstractBlock.Properties props) {
        super(blockIn.func_176223_P(), props);
        this.name = name;
        this.blockParent = blockIn;
        this.setRegistryName(name);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockState newState;
        Block newBlock;
        ItemStack itemstack;
        if (BlockTags.field_200031_h.func_230235_a_((Object)this.getBlockParent()) && (itemstack = player.func_184586_b(handIn)).getToolTypes().contains(ToolType.AXE) && state.func_177230_c() != null && (newBlock = vbe.BLOCK_STRIPPING_MAP.get(state.func_177230_c())) != null) {
            newState = (BlockState)((BlockState)((BlockState)((BlockState)newBlock.func_176223_P().func_206870_a((Property)field_176309_a, state.func_177229_b((Property)field_176309_a))).func_206870_a((Property)field_176308_b, state.func_177229_b((Property)field_176308_b))).func_206870_a((Property)field_176310_M, state.func_177229_b((Property)field_176310_M))).func_206870_a((Property)field_204513_t, state.func_177229_b((Property)field_204513_t));
            worldIn.func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, newState, 11);
                itemstack.func_222118_a(1, (LivingEntity)player, p_220040_1_ -> p_220040_1_.func_213334_d(handIn));
            }
        }
        if (this.getBlockParent() == Blocks.field_196658_i && (itemstack = player.func_184586_b(handIn)).getToolTypes().contains(ToolType.SHOVEL) && state.func_177230_c() != null && (newBlock = vbe.BLOCK_STRIPPING_MAP.get(state.func_177230_c())) != null) {
            newState = (BlockState)((BlockState)((BlockState)((BlockState)newBlock.func_176223_P().func_206870_a((Property)field_176309_a, state.func_177229_b((Property)field_176309_a))).func_206870_a((Property)field_176308_b, state.func_177229_b((Property)field_176308_b))).func_206870_a((Property)field_176310_M, state.func_177229_b((Property)field_176310_M))).func_206870_a((Property)field_204513_t, state.func_177229_b((Property)field_204513_t));
            worldIn.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, newState, 11);
                itemstack.func_222118_a(1, (LivingEntity)player, p_220040_1_ -> p_220040_1_.func_213334_d(handIn));
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        if (this.getBlockParent() == Blocks.field_185774_da) {
            VoxelShape AABB_SLAB_BOTTOM = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
            VoxelShape NWU_CORNER = Block.func_208617_a((double)0.0, (double)7.0, (double)0.0, (double)8.0, (double)15.0, (double)8.0);
            VoxelShape SWU_CORNER = Block.func_208617_a((double)0.0, (double)7.0, (double)8.0, (double)8.0, (double)15.0, (double)16.0);
            VoxelShape NEU_CORNER = Block.func_208617_a((double)8.0, (double)7.0, (double)0.0, (double)16.0, (double)15.0, (double)8.0);
            VoxelShape SEU_CORNER = Block.func_208617_a((double)8.0, (double)7.0, (double)8.0, (double)16.0, (double)15.0, (double)16.0);
            VoxelShape AABB_SLAB_TOP = Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            VoxelShape NWD_CORNER = Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)8.0, (double)9.0, (double)8.0);
            VoxelShape SWD_CORNER = Block.func_208617_a((double)0.0, (double)1.0, (double)8.0, (double)8.0, (double)9.0, (double)16.0);
            VoxelShape NED_CORNER = Block.func_208617_a((double)8.0, (double)1.0, (double)0.0, (double)16.0, (double)9.0, (double)8.0);
            VoxelShape SED_CORNER = Block.func_208617_a((double)8.0, (double)1.0, (double)8.0, (double)16.0, (double)9.0, (double)16.0);
            VoxelShape[] SLAB_TOP_SHAPES = vbe_BlockStairs.makeShapes(AABB_SLAB_TOP, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
            VoxelShape[] SLAB_BOTTOM_SHAPES = vbe_BlockStairs.makeShapes(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
            int[] field_196522_K = new int[]{3, 12, 5, 10, 7, 14, 13, 11, 11, 13, 7, 14, 1, 8, 4, 2, 2, 4, 1, 8};
            if (this.func_196511_x(state) < 20) {
                return (state.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[field_196522_K[this.func_196511_x(state)]];
            }
        }
        return super.func_220053_a(state, blockReader, pos, selectionContext);
    }

    private static VoxelShape[] makeShapes(VoxelShape p_199779_0_, VoxelShape p_199779_1_, VoxelShape p_199779_2_, VoxelShape p_199779_3_, VoxelShape p_199779_4_) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> vbe_BlockStairs.combineShapes(p_199780_5_, p_199779_0_, p_199779_1_, p_199779_2_, p_199779_3_, p_199779_4_)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int p_199781_0_, VoxelShape p_199781_1_, VoxelShape p_199781_2_, VoxelShape p_199781_3_, VoxelShape p_199781_4_, VoxelShape p_199781_5_) {
        VoxelShape voxelshape = p_199781_1_;
        if ((p_199781_0_ & 1) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)p_199781_1_, (VoxelShape)p_199781_2_);
        }
        if ((p_199781_0_ & 2) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)p_199781_3_);
        }
        if ((p_199781_0_ & 4) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)p_199781_4_);
        }
        if ((p_199781_0_ & 8) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)p_199781_5_);
        }
        return voxelshape;
    }

    private int func_196511_x(BlockState state) {
        return ((StairsShape)state.func_177229_b((Property)BlockStateProperties.field_208146_au)).ordinal() * 4 + ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).ordinal() - 2;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (this.getBlockParent() == Blocks.field_226907_mc_) {
            entityIn.func_184185_a(SoundEvents.field_226139_eT_, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                worldIn.func_72960_a(entityIn, (byte)54);
            }
            if (entityIn.func_225503_b_(fallDistance, 0.2f)) {
                entityIn.func_184185_a(this.field_149762_H.func_185842_g(), this.field_149762_H.func_185843_a() * 0.5f, this.field_149762_H.func_185847_b() * 0.75f);
            }
        } else {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (this.getBlockParent() == Blocks.field_226907_mc_ && this.isSliding(pos, entityIn)) {
            this.triggerSlideDownBlock(entityIn, pos);
            this.setSlideVelocity(entityIn);
            this.slideEffects(worldIn, entityIn);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    private boolean isSliding(BlockPos pos, Entity entity) {
        if (this.getBlockParent() == Blocks.field_226907_mc_) {
            if (entity.func_233570_aj_()) {
                return false;
            }
            if (entity.func_226278_cu_() > (double)pos.func_177956_o() + 0.9375 - 1.0E-7) {
                return false;
            }
            if (entity.func_213322_ci().field_72448_b >= -0.08) {
                return false;
            }
            double d0 = Math.abs((double)pos.func_177958_n() + 0.5 - entity.func_226277_ct_());
            double d1 = Math.abs((double)pos.func_177952_p() + 0.5 - entity.func_226281_cx_());
            double d2 = 0.4375 + (double)(entity.func_213311_cf() / 2.0f);
            return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
        }
        return false;
    }

    private void triggerSlideDownBlock(Entity entity, BlockPos pos) {
        if (this.getBlockParent() == Blocks.field_226907_mc_ && entity instanceof ServerPlayerEntity && entity.field_70170_p.func_82737_E() % 20L == 0L) {
            CriteriaTriggers.field_229864_K_.func_227152_a_((ServerPlayerEntity)entity, entity.field_70170_p.func_180495_p(pos));
        }
    }

    private void setSlideVelocity(Entity entity) {
        if (this.getBlockParent() == Blocks.field_226907_mc_) {
            Vector3d vector3d = entity.func_213322_ci();
            if (vector3d.field_72448_b < -0.13) {
                double d0 = -0.05 / vector3d.field_72448_b;
                entity.func_213317_d(new Vector3d(vector3d.field_72450_a * d0, -0.05, vector3d.field_72449_c * d0));
            } else {
                entity.func_213317_d(new Vector3d(vector3d.field_72450_a, -0.05, vector3d.field_72449_c));
            }
            entity.field_70143_R = 0.0f;
        }
    }

    private void slideEffects(World world, Entity entity) {
        if (this.getBlockParent() == Blocks.field_226907_mc_ && vbe_BlockStairs.hasSlideEffects(entity)) {
            if (world.field_73012_v.nextInt(5) == 0) {
                entity.func_184185_a(SoundEvents.field_226139_eT_, 1.0f, 1.0f);
            }
            if (!world.field_72995_K && world.field_73012_v.nextInt(5) == 0) {
                world.func_72960_a(entity, (byte)53);
            }
        }
    }

    private static boolean hasSlideEffects(Entity entity) {
        return entity instanceof LivingEntity || entity instanceof AbstractMinecartEntity || entity instanceof TNTEntity || entity instanceof BoatEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void entitySlideParticles(Entity entity) {
        vbe_BlockStairs.slideParticles(entity, 5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void livingSlideParticles(Entity entity) {
        vbe_BlockStairs.slideParticles(entity, 10);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void slideParticles(Entity entity, int particleCount) {
        if (entity.field_70170_p.field_72995_K) {
            BlockState blockstate = Blocks.field_226907_mc_.func_176223_P();
            for (int i = 0; i < particleCount; ++i) {
                entity.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Direction direction;
        if (this.getBlockParent() == Blocks.field_235399_ni_ && rand.nextInt(5) == 0 && (direction = Direction.func_239631_a_((Random)rand)) != Direction.UP) {
            BlockPos blockpos = pos.func_177972_a(direction);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (!stateIn.func_200132_m() || !blockstate.func_224755_d((IBlockReader)worldIn, blockpos, direction.func_176734_d())) {
                double d0 = direction.func_82601_c() == 0 ? rand.nextDouble() : 0.5 + (double)direction.func_82601_c() * 0.6;
                double d1 = direction.func_96559_d() == 0 ? rand.nextDouble() : 0.5 + (double)direction.func_96559_d() * 0.6;
                double d2 = direction.func_82599_e() == 0 ? rand.nextDouble() : 0.5 + (double)direction.func_82599_e() * 0.6;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_239816_ap_, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        if (this.getBlockParent() == Blocks.field_150343_Z) {
            return PushReaction.BLOCK;
        }
        if (this.getBlockParent() == Blocks.field_235399_ni_) {
            return PushReaction.BLOCK;
        }
        if (BlockTags.field_206952_E.func_230235_a_((Object)this)) {
            return PushReaction.DESTROY;
        }
        return PushReaction.NORMAL;
    }

    public boolean func_149653_t(BlockState state) {
        if (this.field_149764_J == Material.field_151584_j) {
            return false;
        }
        return super.func_149653_t(state);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.field_149764_J != Material.field_151584_j) {
            super.func_225542_b_(state, worldIn, pos, random);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.field_149764_J != Material.field_151584_j && this.getBlockParent() != Blocks.field_150391_bh && this.getBlockParent() != Blocks.field_235381_mu_ && this.getBlockParent() != Blocks.field_235372_ml_) {
            super.func_225534_a_(state, worldIn, pos, random);
        }
    }

    public Block getBlockParent() {
        return this.blockParent;
    }
}

