/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.vanilla;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.TooltipPosition;
import net.darkhax.wawla.Wawla;
import net.darkhax.wawla.lib.Feature;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;

public class FeatureBlastResistance
extends Feature
implements IComponentProvider {
    private static final ResourceLocation ENABLED = new ResourceLocation("wawla", "blast_resistance");

    @Override
    public void initialize(IRegistrar hwyla) {
        hwyla.addConfig(ENABLED, false);
        hwyla.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, Block.class);
    }

    public void appendBody(List<ITextComponent> info, IDataAccessor accessor, IPluginConfig config) {
        if (config.get(ENABLED)) {
            try {
                float blastResistance = accessor.getBlockState().getExplosionResistance((IBlockReader)accessor.getWorld(), accessor.getPosition(), null);
                info.add((ITextComponent)this.getInfoComponent("blastresist", Wawla.FORMAT.format(blastResistance)));
            }
            catch (Exception e) {
                Wawla.LOG.error("Failed to get explosion resistance for block {}.", (Object)accessor.getBlockState());
                Wawla.LOG.catching((Throwable)e);
            }
        }
    }
}

