/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.FTBLibraryCommon;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.AtlasSpriteIcon;
import dev.ftb.mods.ftblibrary.icon.IconPresets;
import dev.ftb.mods.ftblibrary.icon.IconRenderer;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGroupGuiButton;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.TextureStitchEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.hooks.ScreenHooks;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.ReloadListeners;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class FTBLibraryClient
extends FTBLibraryCommon {
    public static final List<IconRenderer<?>> ICON_RENDERERS = new ArrayList();
    public static int showButtons = 1;
    public CursorType lastCursorType = null;

    @Override
    public void init() {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        TextureStitchEvent.PRE.register(this::textureStitch);
        GuiEvent.INIT_POST.register(this::guiInit);
        GuiEvent.RENDER_PRE.register(this::renderTick);
        ClientTickEvent.CLIENT_POST.register(this::clientTick);
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (IFutureReloadListener)SidebarButtonManager.INSTANCE);
    }

    private void textureStitch(AtlasTexture atlas, Consumer<ResourceLocation> addSprite) {
        if (!atlas.func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        try {
            for (Field field : Icons.class.getDeclaredFields()) {
                field.setAccessible(true);
                Object o = field.get(null);
                if (!(o instanceof AtlasSpriteIcon)) continue;
                AtlasSpriteIcon a = (AtlasSpriteIcon)o;
                addSprite.accept(a.id);
                IconPresets.MAP.put(a.id.toString(), a);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ActionResultType renderTick(Screen screen, MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (!ICON_RENDERERS.isEmpty()) {
            for (IconRenderer<?> iconRenderer : ICON_RENDERERS) {
                iconRenderer.render();
            }
        }
        return ActionResultType.PASS;
    }

    private void guiInit(Screen screen, List<Widget> abstractWidgets, List<IGuiEventListener> guiEventListeners) {
        if (FTBLibraryClient.areButtonsVisible(screen)) {
            SidebarGroupGuiButton group = new SidebarGroupGuiButton((ContainerScreen)screen);
            ScreenHooks.addButton((Screen)screen, (Widget)group);
        }
    }

    private void clientTick(Minecraft client) {
        CursorType t;
        CursorType cursorType = t = client.field_71462_r instanceof IScreenWrapper ? ((IScreenWrapper)client.field_71462_r).getGui().getCursor() : null;
        if (this.lastCursorType != t) {
            this.lastCursorType = t;
            CursorType.set(t);
        }
        if (!ClientUtils.RUN_LATER.isEmpty()) {
            for (Runnable runnable : new ArrayList<Runnable>(ClientUtils.RUN_LATER)) {
                runnable.run();
            }
            ClientUtils.RUN_LATER.clear();
        }
    }

    public static boolean areButtonsVisible(@Nullable Screen gui) {
        if (Platform.isForge() && Platform.isModLoaded((String)"roughlyenoughitems")) {
            return false;
        }
        if (showButtons == 0 || showButtons == 2 && !(gui instanceof DisplayEffectsScreen)) {
            return false;
        }
        return gui instanceof ContainerScreen && !SidebarButtonManager.INSTANCE.groups.isEmpty();
    }

    @Override
    public void testScreen() {
        ConfigGroup group = new ConfigGroup("test");
        group.add("image", new ImageConfig(), "", v -> {}, "");
        new EditConfigScreen(group).openGuiLater();
    }
}

