/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.forge;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButton;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonGroup;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.SystemFavoriteEntryProvider;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.forge.REIPlugin;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@REIPlugin
public class REIIntegration
implements REIClientPlugin {
    public static final ResourceLocation ID = new ResourceLocation("ftblibrary", "sidebar_button");

    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(ID, (FavoriteEntryType)SidebarButtonType.INSTANCE);
        registry.registerSystemFavorites((SystemFavoriteEntryProvider)new SystemFavoriteEntryProvider<FavoriteEntry>(){

            public List<FavoriteEntry> provide() {
                ArrayList<FavoriteEntry> entries = new ArrayList<FavoriteEntry>();
                for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
                    for (SidebarButton button : group.getButtons()) {
                        entries.add(new SidebarButtonEntry(button));
                    }
                }
                return entries;
            }

            public long updateInterval() {
                return 2000L;
            }
        });
    }

    private static class SidebarButtonEntry
    extends FavoriteEntry {
        private final SidebarButton button;

        public SidebarButtonEntry(SidebarButton button) {
            this.button = button;
        }

        public boolean isInvalid() {
            for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
                for (SidebarButton groupButton : group.getButtons()) {
                    if (!groupButton.id.equals((Object)this.button.id) || !groupButton.isActuallyVisible()) continue;
                    return false;
                }
            }
            return true;
        }

        public Renderer getRenderer(boolean showcase) {
            return new Renderer(){

                public void render(MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    GuiHelper.setupDrawing();
                    button.getIcon().draw(matrices, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                }

                @Nullable
                public Tooltip getTooltip(Point mouse) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(I18n.func_135052_a((String)button.getLangKey(), (Object[])new Object[0]));
                    if (button.getTooltipHandler() != null) {
                        button.getTooltipHandler().accept(list);
                    }
                    return Tooltip.create((Point)mouse, (Collection)CollectionUtils.map(list, ImmutableTextComponent::new));
                }

                public int getZ() {
                    return 0;
                }

                public void setZ(int z) {
                }
            };
        }

        public boolean doAction(int button) {
            this.button.onClicked(Screen.func_231173_s_());
            return true;
        }

        public long hashIgnoreAmount() {
            return this.button.id.hashCode();
        }

        public FavoriteEntry copy() {
            return new SidebarButtonEntry(new SidebarButton(this.button.id, null, this.button.json));
        }

        public ResourceLocation getType() {
            return ID;
        }

        public boolean isSame(FavoriteEntry other) {
            if (other instanceof SidebarButtonEntry) {
                return ((SidebarButtonEntry)other).button.id.equals((Object)this.button.id);
            }
            return false;
        }
    }

    private static enum SidebarButtonType implements FavoriteEntryType<SidebarButtonEntry>
    {
        INSTANCE;


        public CompoundNBT save(SidebarButtonEntry entry, CompoundNBT tag) {
            tag.func_74778_a("id", ((SidebarButtonEntry)entry).button.id.toString());
            tag.func_74778_a("json", new Gson().toJson((JsonElement)((SidebarButtonEntry)entry).button.json));
            return tag;
        }

        public DataResult<SidebarButtonEntry> readResult(CompoundNBT object) {
            ResourceLocation id = new ResourceLocation(object.func_74779_i("id"));
            JsonObject json = (JsonObject)new JsonParser().parse(object.func_74779_i("json"));
            return DataResult.success((Object)((Object)new SidebarButtonEntry(new SidebarButton(id, null, json))), (Lifecycle)Lifecycle.stable());
        }

        public DataResult<SidebarButtonEntry> fromArgsResult(Object ... args) {
            if (args.length == 0) {
                return DataResult.error((String)"Cannot create SidebarButtonEntry from empty args!");
            }
            if (!(args[0] instanceof ResourceLocation)) {
                return DataResult.error((String)"Creation of SidebarButtonEntry from args expected ResourceLocation as the first argument!");
            }
            if (!(args[1] instanceof SidebarButton) && !(args[1] instanceof JsonObject)) {
                return DataResult.error((String)"Creation of SidebarButtonEntry from args expected SidebarButton or JsonObject as the second argument!");
            }
            return DataResult.success((Object)((Object)new SidebarButtonEntry(args[1] instanceof SidebarButton ? (SidebarButton)args[1] : new SidebarButton((ResourceLocation)args[0], null, (JsonObject)args[1]))), (Lifecycle)Lifecycle.stable());
        }
    }
}

