/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.SNBTEOFException;
import dev.ftb.mods.ftblibrary.snbt.SNBTSyntaxException;
import dev.ftb.mods.ftblibrary.snbt.SNBTUtils;
import dev.ftb.mods.ftblibrary.snbt.SpecialTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;

class SNBTParser {
    private final char[] buffer;
    private int position;

    static SNBTCompoundTag read(List<String> lines) {
        SNBTParser parser = new SNBTParser(lines);
        return (SNBTCompoundTag)SpecialTag.unwrap(parser.readTag(parser.nextNS()));
    }

    private SNBTParser(List<String> lines) {
        StringBuilder bufferBuilder = new StringBuilder();
        for (String line : lines) {
            String tline = line.trim();
            if (!tline.startsWith("//") && !tline.startsWith("#")) {
                bufferBuilder.append(line);
            }
            bufferBuilder.append('\n');
        }
        this.buffer = bufferBuilder.toString().toCharArray();
        if (this.buffer.length < 2) {
            throw new SNBTSyntaxException("File has to have at least two characters!");
        }
        this.position = 0;
    }

    private String posString() {
        return this.posString(this.position);
    }

    private String posString(int p) {
        if (p >= this.buffer.length) {
            return "EOF";
        }
        int row = 0;
        int col = 0;
        for (int i = 0; i < p; ++i) {
            if (this.buffer[i] == '\n') {
                ++row;
                col = 0;
                continue;
            }
            ++col;
        }
        return row + 1 + ":" + (col + 1);
    }

    private char next() {
        if (this.position >= this.buffer.length) {
            throw new SNBTEOFException();
        }
        char c = this.buffer[this.position];
        ++this.position;
        return c;
    }

    private char nextNS() {
        char c;
        while ((c = this.next()) <= ' ') {
        }
        return c;
    }

    private INBT readTag(char first) {
        String s;
        switch (first) {
            case '{': {
                return this.readCompound();
            }
            case '[': {
                return this.readCollection();
            }
            case '\"': {
                return StringNBT.func_229705_a_((String)this.readQuotedString('\"'));
            }
            case '\'': {
                return StringNBT.func_229705_a_((String)this.readQuotedString('\''));
            }
        }
        switch (s = this.readWordString(first)) {
            case "true": {
                return SpecialTag.TRUE;
            }
            case "false": {
                return SpecialTag.FALSE;
            }
            case "null": 
            case "end": 
            case "END": {
                return EndNBT.field_229686_b_;
            }
            case "Infinity": 
            case "Infinityd": 
            case "+Infinity": 
            case "+Infinityd": 
            case "\u221e": 
            case "\u221ed": 
            case "+\u221e": 
            case "+\u221ed": {
                return SpecialTag.POS_INFINITY_D;
            }
            case "-Infinity": 
            case "-Infinityd": 
            case "-\u221e": 
            case "-\u221ed": {
                return SpecialTag.NEG_INFINITY_D;
            }
            case "NaN": 
            case "NaNd": {
                return SpecialTag.NAN_D;
            }
            case "Infinityf": 
            case "+Infinityf": 
            case "\u221ef": 
            case "+\u221ef": {
                return SpecialTag.POS_INFINITY_F;
            }
            case "-Infinityf": 
            case "-\u221ef": {
                return SpecialTag.NEG_INFINITY_F;
            }
            case "NaNf": {
                return SpecialTag.NAN_F;
            }
        }
        switch (SNBTUtils.getNumberType(s)) {
            case 1: {
                return ByteNBT.func_229671_a_((byte)Byte.parseByte(s.substring(0, s.length() - 1)));
            }
            case 2: {
                return ShortNBT.func_229701_a_((short)Short.parseShort(s.substring(0, s.length() - 1)));
            }
            case 3: {
                return IntNBT.func_229692_a_((int)Integer.parseInt(s));
            }
            case 4: {
                return LongNBT.func_229698_a_((long)Long.parseLong(s.substring(0, s.length() - 1)));
            }
            case 5: {
                return FloatNBT.func_229689_a_((float)Float.parseFloat(s.substring(0, s.length() - 1)));
            }
            case 6: {
                return DoubleNBT.func_229684_a_((double)Double.parseDouble(s.substring(0, s.length() - 1)));
            }
            case -6: {
                return DoubleNBT.func_229684_a_((double)Double.parseDouble(s));
            }
        }
        return StringNBT.func_229705_a_((String)s);
    }

    private SNBTCompoundTag readCompound() {
        char n;
        SNBTCompoundTag tag = new SNBTCompoundTag();
        while (true) {
            char c;
            if ((c = this.nextNS()) == '}') {
                return tag;
            }
            if (c == ',' || c == '\n') continue;
            String key = c == '\"' ? this.readQuotedString('\"') : (c == '\'' ? this.readQuotedString('\'') : this.readWordString(c));
            n = this.nextNS();
            if (n != ':' && n != '=') break;
            INBT t = this.readTag(this.nextNS());
            if (t == SpecialTag.TRUE) {
                tag.getOrCreateProperties((String)key).valueType = 2;
            } else if (t == SpecialTag.FALSE) {
                tag.getOrCreateProperties((String)key).valueType = 1;
            }
            tag.func_218657_a(key, SpecialTag.unwrap(t));
        }
        throw new SNBTSyntaxException("Expected ':', got '" + n + "' @ " + this.posString());
    }

    private CollectionNBT<?> readCollection() {
        int prevPos = this.position;
        char next1 = this.nextNS();
        char next2 = this.nextNS();
        if (next2 == ';' && (next1 == 'I' || next1 == 'i' || next1 == 'L' || next1 == 'l' || next1 == 'B' || next1 == 'b')) {
            return this.readArray(prevPos, next1);
        }
        this.position = prevPos;
        return this.readList();
    }

    private ListNBT readList() {
        ListNBT tag = new ListNBT();
        while (true) {
            int prevPos = this.position;
            char c = this.nextNS();
            if (c == ']') {
                return tag;
            }
            if (c == ',') continue;
            INBT t = SpecialTag.unwrap(this.readTag(c));
            try {
                tag.add((Object)t);
            }
            catch (UnsupportedOperationException ex) {
                throw new SNBTSyntaxException("Unexpected tag '" + t + "' in list @ " + this.posString(prevPos) + " - can't mix two different tag types in a list!");
            }
        }
    }

    private CollectionNBT<?> readArray(int pos, char type) {
        INBT t;
        ArrayList<Number> listOfNumbers = new ArrayList<Number>();
        while (true) {
            char c;
            if ((c = this.nextNS()) == ']') {
                switch (type) {
                    case 'I': 
                    case 'i': {
                        return new IntArrayNBT(listOfNumbers);
                    }
                    case 'L': 
                    case 'l': {
                        return new LongArrayNBT(listOfNumbers);
                    }
                    case 'B': 
                    case 'b': {
                        return new ByteArrayNBT(listOfNumbers);
                    }
                }
                throw new SNBTSyntaxException("Unknown array type: " + type + " @ " + this.posString(pos));
            }
            if (c == ',') continue;
            t = SpecialTag.unwrap(this.readTag(c));
            if (!(t instanceof NumberNBT)) break;
            switch (type) {
                case 'I': 
                case 'i': {
                    listOfNumbers.add(((NumberNBT)t).func_150287_d());
                    break;
                }
                case 'L': 
                case 'l': {
                    listOfNumbers.add(((NumberNBT)t).func_150291_c());
                    break;
                }
                case 'B': 
                case 'b': {
                    listOfNumbers.add(((NumberNBT)t).func_150290_f());
                }
            }
        }
        throw new SNBTSyntaxException("Unexpected tag '" + t + "' in list @ " + this.posString() + " - expected a numeric tag!");
    }

    private String readWordString(char first) {
        char c;
        StringBuilder sb = new StringBuilder();
        sb.append(first);
        while (SNBTUtils.isSimpleCharacter(c = this.next())) {
            sb.append(c);
        }
        --this.position;
        return sb.toString();
    }

    private String readQuotedString(char stop) {
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        while (true) {
            char c;
            if ((c = this.next()) == '\n') {
                throw new SNBTSyntaxException("New line without closing string with " + stop + " @ " + this.posString(this.position - 1) + "!");
            }
            if (escape) {
                escape = false;
                if (SNBTUtils.REVERSE_ESCAPE_CHARS[c] == '\u0000') continue;
                sb.append(SNBTUtils.REVERSE_ESCAPE_CHARS[c]);
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == stop) {
                return sb.toString();
            }
            sb.append(c);
        }
    }
}

