/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.DeskBlock;
import com.mrcrayfish.furniture.tileentity.DeskCabinetTileEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DeskCabinetBlock
extends DeskBlock
implements ISidedInventoryProvider {
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");

    public DeskCabinetBlock(AbstractBlock.Properties properties, DeskBlock.MaterialType materialType) {
        super(properties, materialType);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH)).func_206870_a((Property)TYPE, (Comparable)((Object)DeskBlock.Type.SINGLE))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] DESK_TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] DESK_BACK = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] DESK_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] DESK_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] DESK_DRAWS = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)15.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
            DeskBlock.Type type = (DeskBlock.Type)((Object)state.func_177229_b((Property)TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(DESK_TOP[direction.func_176736_b()]);
            shapes.add(DESK_BACK[direction.func_176736_b()]);
            shapes.add(DESK_DRAWS[direction.func_176736_b()]);
            switch (type) {
                case SINGLE: {
                    shapes.add(DESK_LEFT[direction.func_176736_b()]);
                    shapes.add(DESK_RIGHT[direction.func_176736_b()]);
                    break;
                }
                case LEFT: {
                    shapes.add(DESK_LEFT[direction.func_176736_b()]);
                    break;
                }
                case RIGHT: {
                    shapes.add(DESK_RIGHT[direction.func_176736_b()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (((Direction)state.func_177229_b((Property)DIRECTION)).func_176734_d() == result.func_216354_b()) {
            TileEntity tileEntity;
            if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof DeskCabinetTileEntity) {
                playerEntity.func_213829_a((INamedContainerProvider)tileEntity);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof DeskCabinetTileEntity) {
            ((DeskCabinetTileEntity)tileEntity).onScheduledTick();
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new DeskCabinetTileEntity();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{OPEN});
    }

    public ISidedInventory func_219966_a(BlockState state, IWorld world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ISidedInventory) {
            return (ISidedInventory)tileEntity;
        }
        return null;
    }
}

