/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.orecruncher.lib.math.MathStuff;

public class ObjectArray<T>
implements Collection<T> {
    private static final int DEFAULT_SIZE = 4;
    protected Object[] data;
    protected int insertionIdx;

    public ObjectArray() {
        this(4);
    }

    public ObjectArray(int size) {
        this.data = new Object[size];
    }

    public ObjectArray(@Nonnull ObjectArray<T> input) {
        this.data = Arrays.copyOf(input.data, input.size());
        this.insertionIdx = input.insertionIdx;
    }

    public ObjectArray(@Nonnull T[] input) {
        this.data = Arrays.copyOf(input, input.length);
        this.insertionIdx = input.length;
    }

    private void resize() {
        int newSize = MathHelper.func_151236_b((int)MathStuff.max(this.data.length * 2, 4));
        Object[] t = new Object[newSize];
        if (this.data.length > 0) {
            System.arraycopy(this.data, 0, t, 0, this.data.length);
        }
        this.data = t;
    }

    @Override
    public int size() {
        return this.insertionIdx;
    }

    public T get(int idx) {
        if (idx >= 0 && idx < this.insertionIdx) {
            return (T)this.data[idx];
        }
        return null;
    }

    private void remove0(int idx) {
        Object m = this.data[--this.insertionIdx];
        this.data[this.insertionIdx] = null;
        if (idx < this.insertionIdx) {
            this.data[idx] = m;
        }
    }

    @Override
    public boolean removeIf(@Nonnull Predicate<? super T> pred) {
        boolean result = false;
        for (int i = this.insertionIdx - 1; i >= 0; --i) {
            Object t = this.data[i];
            if (!pred.test(t)) continue;
            result = true;
            this.remove0(i);
        }
        return result;
    }

    @Override
    public void forEach(@Nonnull Consumer<? super T> consumer) {
        for (int i = 0; i < this.insertionIdx; ++i) {
            consumer.accept(this.data[i]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private int find(@Nonnull Object o) {
        for (int i = 0; i < this.insertionIdx; ++i) {
            if (!o.equals(this.data[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(@Nonnull Object o) {
        return this.find(o) != -1;
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        Object[] result = ArrayUtils.EMPTY_OBJECT_ARRAY;
        if (this.insertionIdx > 0) {
            result = new Object[this.insertionIdx];
            System.arraycopy(this.data, 0, result, 0, this.insertionIdx);
        }
        return result;
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        if (a.length < this.insertionIdx) {
            return Arrays.copyOf(this.data, this.insertionIdx, a.getClass());
        }
        System.arraycopy(this.data, 0, a, 0, this.insertionIdx);
        if (a.length > this.insertionIdx) {
            a[this.insertionIdx] = null;
        }
        return a;
    }

    @Override
    public boolean add(@Nonnull T e) {
        if (this.data.length == this.insertionIdx) {
            this.resize();
        }
        this.data[this.insertionIdx++] = e;
        return true;
    }

    @Override
    public boolean remove(@Nonnull Object o) {
        int idx = this.find(o);
        if (idx != -1) {
            this.remove0(idx);
        }
        return idx != -1;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> c) {
        boolean result = false;
        for (T element : c) {
            result |= this.add(element);
        }
        return result;
    }

    public boolean addAll(@Nonnull T[] list) {
        boolean result = false;
        for (T t : list) {
            result |= this.add(t);
        }
        return result;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        return this.removeIf((Predicate<? super T>)((Predicate<Object>)c::contains));
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.removeIf((Predicate<? super T>)((Predicate<Object>)entry -> !c.contains(entry)));
    }

    public void trim() {
        if (this.insertionIdx < this.data.length) {
            if (this.insertionIdx == 0) {
                this.data = ArrayUtils.EMPTY_OBJECT_ARRAY;
            } else {
                Object[] t = new Object[this.insertionIdx];
                System.arraycopy(this.data, 0, t, 0, this.insertionIdx);
                this.data = t;
            }
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.insertionIdx; ++i) {
            this.data[i] = null;
        }
        this.insertionIdx = 0;
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int idx = -1;

            @Override
            public boolean hasNext() {
                return this.idx + 1 < ObjectArray.this.insertionIdx;
            }

            @Override
            public T next() {
                return ObjectArray.this.data[++this.idx];
            }
        };
    }
}

