/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.scripting.sets;

import javax.annotation.Nonnull;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.scripting.VariableSet;
import org.orecruncher.lib.scripting.sets.IPlayerVariables;
import org.orecruncher.lib.scripting.sets.LazyVariable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerVariables
extends VariableSet<IPlayerVariables>
implements IPlayerVariables {
    private final LazyVariable<Boolean> isSuffocating = new LazyVariable<Boolean>(() -> {
        if (GameUtils.isInGame()) {
            PlayerEntity player = GameUtils.getPlayer();
            return !player.func_184812_l_() && player.func_70086_ai() < 0;
        }
        return false;
    });
    private final LazyVariable<Boolean> canSeeSky = new LazyVariable<Boolean>(() -> {
        if (GameUtils.isInGame()) {
            ClientWorld world = GameUtils.getWorld();
            PlayerEntity player = GameUtils.getPlayer();
            return world.func_175710_j(player.func_233580_cy_().func_177982_a(0, 2, 0));
        }
        return false;
    });
    private final LazyVariable<Boolean> canRainOn = new LazyVariable<Boolean>(() -> {
        PlayerEntity player;
        ClientWorld world;
        if (GameUtils.isInGame() && (world = GameUtils.getWorld()).func_175710_j((player = GameUtils.getPlayer()).func_233580_cy_().func_177982_a(0, 2, 0))) {
            return WorldUtils.getTopSolidOrLiquidBlock((IWorldReader)world, player.func_233580_cy_()).func_177956_o() <= player.func_233580_cy_().func_177956_o();
        }
        return false;
    });
    private boolean isCreative;
    private boolean isBurning;
    private boolean isFlying;
    private boolean isSprintnig;
    private boolean isInLava;
    private boolean isInvisible;
    private boolean isBlind;
    private boolean isInWater;
    private boolean isWet;
    private boolean isRiding;
    private boolean isOnGround;
    private boolean isMoving;
    private float health;
    private float maxHealth;
    private float foodLevel;
    private float foodSaturationLevel;
    private double x;
    private double y;
    private double z;

    public PlayerVariables() {
        super("player");
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            PlayerEntity player = GameUtils.getPlayer();
            assert (player != null);
            this.isCreative = player.func_184812_l_();
            this.isBurning = player.func_70027_ad();
            this.isFlying = player.field_70160_al;
            this.isSprintnig = player.func_70051_ag();
            this.isInLava = player.func_180799_ab();
            this.isInvisible = player.func_82150_aj();
            this.isBlind = player.func_70644_a(Effects.field_76440_q);
            this.isInWater = player.func_70090_H();
            this.isWet = player.func_70026_G();
            this.isRiding = player.func_200601_bK();
            this.isOnGround = player.func_233570_aj_();
            this.isMoving = player.field_70140_Q != player.field_70141_P;
            this.health = player.func_110143_aJ();
            this.maxHealth = player.func_110138_aP();
            this.foodLevel = player.func_71024_bL().func_75116_a();
            this.foodSaturationLevel = player.func_71024_bL().func_75115_e();
            this.x = player.func_226277_ct_();
            this.y = player.func_226278_cu_();
            this.z = player.func_226281_cx_();
        } else {
            this.isCreative = false;
            this.isBurning = false;
            this.isFlying = false;
            this.isSprintnig = false;
            this.isInLava = false;
            this.isInvisible = false;
            this.isBlind = false;
            this.isInWater = false;
            this.isWet = false;
            this.isRiding = false;
            this.isOnGround = false;
            this.health = 20.0f;
            this.maxHealth = 20.0f;
            this.foodLevel = 20.0f;
            this.foodSaturationLevel = 20.0f;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        }
        this.isSuffocating.reset();
        this.canRainOn.reset();
        this.canSeeSky.reset();
    }

    @Override
    @Nonnull
    public IPlayerVariables getInterface() {
        return this;
    }

    @Override
    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public boolean isBurning() {
        return this.isBurning;
    }

    @Override
    public boolean isSuffocating() {
        return this.isSuffocating.get();
    }

    @Override
    public boolean isFlying() {
        return this.isFlying;
    }

    @Override
    public boolean isSprintnig() {
        return this.isSprintnig;
    }

    @Override
    public boolean isInLava() {
        return this.isInLava;
    }

    @Override
    public boolean isInvisible() {
        return this.isInvisible;
    }

    @Override
    public boolean isBlind() {
        return this.isBlind;
    }

    @Override
    public boolean isInWater() {
        return this.isInWater;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }

    @Override
    public boolean isWet() {
        return this.isWet;
    }

    @Override
    public boolean isRiding() {
        return this.isRiding;
    }

    @Override
    public boolean isOnGround() {
        return this.isOnGround;
    }

    @Override
    public boolean canRainOn() {
        return this.canRainOn.get();
    }

    @Override
    public boolean canSeeSky() {
        return this.canSeeSky.get();
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public float getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public float getFoodLevel() {
        return this.foodLevel;
    }

    @Override
    public float getFoodSaturationLevel() {
        return this.foodSaturationLevel;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }
}

