/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;
import org.orecruncher.mobeffects.MobEffects;
import org.orecruncher.mobeffects.config.Config;
import org.orecruncher.mobeffects.effects.particles.Collections;
import org.orecruncher.mobeffects.footsteps.AcousticResolver;
import org.orecruncher.mobeffects.footsteps.Association;
import org.orecruncher.mobeffects.footsteps.FootStrikeLocation;
import org.orecruncher.mobeffects.footsteps.Footprint;
import org.orecruncher.mobeffects.footsteps.FootprintStyle;
import org.orecruncher.mobeffects.footsteps.Substrate;
import org.orecruncher.mobeffects.footsteps.Variator;
import org.orecruncher.mobeffects.footsteps.accents.FootstepAccents;
import org.orecruncher.mobeffects.library.Constants;
import org.orecruncher.mobeffects.library.FootstepLibrary;
import org.orecruncher.sndctrl.api.acoustics.AcousticEvent;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.audio.acoustic.AcousticCompiler;

@OnlyIn(value=Dist.CLIENT)
public class Generator {
    protected static final IModLog LOGGER = MobEffects.LOGGER.createChild(Generator.class);
    public static final double PROBE_DEPTH = 0.0625;
    protected static final Random RANDOM = XorShiftRandom.current();
    protected static final int BRUSH_INTERVAL = 2;
    protected final Variator VAR;
    protected float dmwBase;
    protected float dwmYChange;
    protected double yPosition;
    protected double prevX = Double.MIN_VALUE;
    protected double prevY = Double.MIN_VALUE;
    protected double prevZ = Double.MIN_VALUE;
    protected boolean didJump;
    protected boolean isFlying;
    protected float fallDistance;
    protected float lastReference;
    protected boolean isImmobile;
    protected long timeImmobile;
    protected boolean isRightFoot;
    protected boolean isOnGround;
    protected boolean isOnLadder;
    protected boolean isInWater;
    protected boolean isSneaking;
    protected boolean isJumping;
    protected double xMovec;
    protected double zMovec;
    protected boolean scalStat;
    protected boolean stepThisFrame;
    protected BlockPos messyPos = BlockPos.field_177992_a;
    protected long brushesTime;
    protected double distanceWalkedOnStepModified;
    protected int pedometer;
    protected static final ObjectArray<IAcoustic> accents = new ObjectArray();

    public Generator(@Nonnull Variator var) {
        this.VAR = var;
    }

    public int getPedometer() {
        return this.pedometer;
    }

    public void generateFootsteps(@Nonnull LivingEntity entity) {
        if (entity.func_200601_bK() || entity.func_70608_bn()) {
            return;
        }
        if (entity instanceof PlayerEntity && entity.func_175149_v()) {
            return;
        }
        this.didJump = false;
        this.stepThisFrame = false;
        this.isOnGround = entity.func_233570_aj_();
        this.isOnLadder = this.isClimbing(entity);
        this.isInWater = entity.func_70090_H();
        this.isSneaking = entity.func_225608_bj_();
        this.isJumping = entity.field_70703_bu;
        this.simulateFootsteps(entity);
        this.simulateAirborne(entity);
        this.simulateBrushes(entity);
        if (this.stepThisFrame) {
            ++this.pedometer;
        }
        if (Constants.FOOTSTEPS.getVolumeScale() > 0.0f) {
            entity.field_70150_b = Float.MAX_VALUE;
        } else {
            float dist = entity.field_70150_b;
            if (dist == Float.MAX_VALUE) {
                entity.field_70150_b = 0.0f;
            }
        }
    }

    protected boolean isClimbing(@Nonnull LivingEntity entity) {
        BlockPos blockPos;
        World world = entity.func_130014_f_();
        BlockState blockState = world.func_180495_p(blockPos = entity.func_233580_cy_());
        return blockState.func_235714_a_((ITag)BlockTags.field_232878_as_) || ForgeHooks.isLivingOnLadder((BlockState)blockState, (World)world, (BlockPos)blockPos, (LivingEntity)entity);
    }

    protected boolean stoppedImmobile(float reference) {
        long current = TickCounter.getTickCount();
        float diff = this.lastReference - reference;
        this.lastReference = reference;
        if (!this.isImmobile && diff == 0.0f) {
            this.timeImmobile = current;
            this.isImmobile = true;
        } else if (this.isImmobile && diff != 0.0f) {
            this.isImmobile = false;
            return current - this.timeImmobile > (long)this.VAR.IMMOBILE_DURATION;
        }
        return false;
    }

    protected void updateWalkedOnStep(@Nonnull LivingEntity entity) {
        float distance = 0.0f;
        if (Double.compare(this.prevX, Double.MIN_VALUE) == 0) {
            this.prevX = entity.func_226277_ct_();
            this.prevY = entity.func_226278_cu_();
            this.prevZ = entity.func_226281_cx_();
        } else {
            double dX = entity.func_226277_ct_() - this.prevX;
            double dY = entity.func_226278_cu_() - this.prevY;
            double dZ = entity.func_226281_cx_() - this.prevZ;
            this.prevX = entity.func_226277_ct_();
            this.prevY = entity.func_226278_cu_();
            this.prevZ = entity.func_226281_cx_();
            double sqrt = entity.func_233570_aj_() ? Math.sqrt(dX * dX + dZ * dZ) : Math.sqrt(dX * dX + dY * dY + dZ * dZ);
            distance = (float)sqrt * 0.6f;
        }
        this.distanceWalkedOnStepModified += (double)distance;
    }

    protected void simulateFootsteps(@Nonnull LivingEntity entity) {
        double movZ;
        double movX;
        double scal;
        this.updateWalkedOnStep(entity);
        float distanceReference = (float)this.distanceWalkedOnStepModified;
        if (this.dmwBase > distanceReference) {
            this.dmwBase = 0.0f;
            this.dwmYChange = 0.0f;
        }
        if (this.scalStat != (scal = (movX = entity.func_213322_ci().field_72450_a) * this.xMovec + (movZ = entity.func_213322_ci().field_72449_c) * this.zMovec) < (double)0.001f) {
            boolean bl = this.scalStat = !this.scalStat;
            if (this.scalStat && this.VAR.PLAY_WANDER && !this.hasSpecialStoppingConditions(entity)) {
                this.playSinglefoot(entity, 0.0, Constants.WANDER, this.isRightFoot);
            }
        }
        this.xMovec = movX;
        this.zMovec = movZ;
        if (this.isOnGround || this.isInWater || this.isOnLadder) {
            AcousticEvent event = null;
            float dwm = distanceReference - this.dmwBase;
            boolean immobile = this.stoppedImmobile(distanceReference);
            if (immobile && !this.isOnLadder) {
                dwm = 0.0f;
                this.dmwBase = distanceReference;
            }
            float distance = 0.0f;
            if (this.isOnLadder && !this.isOnGround) {
                distance = this.VAR.STRIDE_LADDER;
            } else if (!this.isInWater && MathStuff.abs(this.yPosition - entity.func_226278_cu_()) > 0.4) {
                if (this.yPosition < entity.func_226278_cu_()) {
                    distance = this.VAR.STRIDE_STAIR;
                    event = this.speedDisambiguator(entity, Constants.UP, Constants.UP_RUN);
                } else if (!this.isSneaking) {
                    distance = -1.0f;
                    event = this.speedDisambiguator(entity, Constants.DOWN, Constants.DOWN_RUN);
                }
                this.dwmYChange = distanceReference;
            } else {
                distance = this.VAR.STRIDE;
            }
            if (event == null) {
                event = this.speedDisambiguator(entity, Constants.WALK, Constants.RUN);
            }
            if (dwm > (distance = this.reevaluateDistance(event, distance))) {
                this.produceStep(entity, event, 0.0);
                this.stepped(entity, event);
                this.dmwBase = distanceReference;
            }
        }
        if (this.isOnGround) {
            this.yPosition = entity.func_226278_cu_();
        }
    }

    protected void stepped(@Nonnull LivingEntity entity, @Nonnull AcousticEvent event) {
    }

    protected float reevaluateDistance(@Nonnull AcousticEvent event, float distance) {
        return distance;
    }

    protected void produceStep(@Nonnull LivingEntity entity, @Nonnull AcousticEvent event) {
        this.produceStep(entity, event, 0.0);
    }

    protected void produceStep(@Nonnull LivingEntity entity, @Nullable AcousticEvent event, double verticalOffsetAsMinus) {
        if (!this.playSpecialStoppingConditions(entity)) {
            if (event == null) {
                event = this.speedDisambiguator(entity, Constants.WALK, Constants.RUN);
            }
            this.playSinglefoot(entity, verticalOffsetAsMinus, event, this.isRightFoot);
            this.isRightFoot = !this.isRightFoot;
        }
        this.stepThisFrame = true;
    }

    protected void simulateAirborne(@Nonnull LivingEntity entity) {
        if ((this.isOnGround || this.isOnLadder) == this.isFlying) {
            this.isFlying = !this.isFlying;
            this.simulateJumpingLanding(entity);
        }
        if (this.isFlying) {
            this.fallDistance = entity.field_70143_R;
        }
    }

    protected void simulateJumpingLanding(@Nonnull LivingEntity entity) {
        if (this.hasSpecialStoppingConditions(entity)) {
            return;
        }
        if (this.isFlying && this.isJumping) {
            if (this.VAR.EVENT_ON_JUMP && entity.func_213322_ci().field_72448_b > 0.0) {
                this.didJump = true;
                double speed = entity.func_213322_ci().field_72450_a * entity.func_213322_ci().field_72450_a + entity.func_213322_ci().field_72449_c * entity.func_213322_ci().field_72449_c;
                if (speed < (double)this.VAR.SPEED_TO_JUMP_AS_MULTIFOOT) {
                    this.playMultifoot(entity, 0.4, Constants.JUMP);
                } else {
                    this.playSinglefoot(entity, 0.4, Constants.JUMP, this.isRightFoot);
                }
            }
        } else if (!this.isFlying && this.fallDistance > 0.01f) {
            if (this.fallDistance > this.VAR.LAND_HARD_DISTANCE_MIN) {
                this.playMultifoot(entity, 0.0, Constants.LAND);
            } else if (!this.stepThisFrame && !this.isSneaking) {
                this.playSinglefoot(entity, 0.0, this.speedDisambiguator(entity, Constants.CLIMB, Constants.CLIMB_RUN), this.isRightFoot);
                this.isRightFoot = !this.isRightFoot;
            }
        }
    }

    protected AcousticEvent speedDisambiguator(@Nonnull LivingEntity entity, @Nonnull AcousticEvent walk, @Nonnull AcousticEvent run) {
        double velocity = entity.func_213322_ci().field_72450_a * entity.func_213322_ci().field_72450_a + entity.func_213322_ci().field_72449_c * entity.func_213322_ci().field_72449_c;
        return velocity > (double)this.VAR.SPEED_TO_RUN ? run : walk;
    }

    protected void simulateBrushes(@Nonnull LivingEntity entity) {
        long current = TickCounter.getTickCount();
        if (current >= this.brushesTime) {
            this.brushesTime = current + 2L;
            if (this.proceedWithStep(entity) && (entity.func_213322_ci().field_72450_a != 0.0 || entity.func_213322_ci().field_72449_c != 0.0)) {
                int yy = MathStuff.floor(entity.func_226278_cu_() - 0.0625 - entity.func_70033_W() - (entity.func_233570_aj_() ? 0.0 : 0.25));
                BlockPos pos = new BlockPos(entity.func_226277_ct_(), (double)yy, entity.func_226281_cx_());
                if (!this.messyPos.equals((Object)pos)) {
                    this.messyPos = pos;
                    Association assos = this.findAssociationMessyFoliage(entity, pos);
                    if (assos != null) {
                        this.playAssociation(assos, Constants.WALK);
                    }
                }
            }
        }
    }

    protected boolean proceedWithStep(@Nonnull LivingEntity entity) {
        return !this.isSneaking;
    }

    protected void playSinglefoot(@Nonnull LivingEntity entity, double verticalOffsetAsMinus, @Nonnull AcousticEvent eventType, boolean foot) {
        if (this.proceedWithStep(entity)) {
            Association assos = this.findAssociation(entity, verticalOffsetAsMinus, foot);
            this.playAssociation(assos, eventType);
        }
    }

    protected void playMultifoot(@Nonnull LivingEntity entity, double verticalOffsetAsMinus, AcousticEvent eventType) {
        if (this.proceedWithStep(entity)) {
            Association leftFoot = this.findAssociation(entity, verticalOffsetAsMinus, false);
            Association rightFoot = this.findAssociation(entity, verticalOffsetAsMinus, true);
            this.playAssociation(leftFoot, eventType);
            this.playAssociation(rightFoot, eventType);
        }
    }

    protected void playAssociation(@Nullable Association assoc, @Nonnull AcousticEvent eventType) {
        if (assoc != null) {
            assoc.play(eventType);
        }
    }

    protected boolean shouldProducePrint(@Nonnull LivingEntity entity) {
        return this.VAR.HAS_FOOTPRINT && (Boolean)Config.CLIENT.footsteps.enableFootprintParticles.get() != false && (this.isOnGround || !this.isJumping && !entity.field_70160_al) && !entity.func_98034_c(GameUtils.getPlayer());
    }

    @Nullable
    protected Association findAssociation(@Nonnull LivingEntity entity, double verticalOffsetAsMinus, boolean isRightFoot) {
        Vector3d printPos;
        float rotDegrees = MathStuff.wrapDegrees(entity.field_70177_z);
        double rot = MathStuff.toRadians(rotDegrees);
        float feetDistanceToCenter = isRightFoot ? -this.VAR.DISTANCE_TO_CENTER : this.VAR.DISTANCE_TO_CENTER;
        double xx = entity.func_226277_ct_() + MathStuff.cos(rot) * (double)feetDistanceToCenter;
        double zz = entity.func_226281_cx_() + MathStuff.sin(rot) * (double)feetDistanceToCenter;
        double minY = entity.func_174813_aQ().field_72338_b;
        FootStrikeLocation loc = new FootStrikeLocation(entity, xx, minY - 0.0625 - verticalOffsetAsMinus, zz);
        AcousticResolver resolver = new AcousticResolver((IWorldReader)entity.func_130014_f_(), loc, this.VAR.DISTANCE_TO_CENTER);
        Association result = this.addFootstepAccent(entity, resolver.findAssociation());
        if (result != null && this.shouldProducePrint(entity) && (printPos = result.getStrikeLocation().footprintPosition()) != null) {
            FootprintStyle style = this.VAR.FOOTPRINT_STYLE;
            if (entity instanceof PlayerEntity) {
                style = (FootprintStyle)((Object)Config.CLIENT.footsteps.playerFootprintStyle.get());
            }
            Footprint print = Footprint.produce(style, entity, printPos, rotDegrees, this.VAR.FOOTPRINT_SCALE, isRightFoot);
            Vector3d stepLocation = print.getStepLocation();
            World world = print.getEntity().func_130014_f_();
            Collections.addFootprint(print.getStyle(), world, stepLocation, print.getRotation(), print.getScale(), print.isRightFoot());
        }
        return result;
    }

    protected boolean playSpecialStoppingConditions(@Nonnull LivingEntity entity) {
        if (entity.func_70090_H()) {
            if (this.proceedWithStep(entity)) {
                FluidState fs = entity.func_130014_f_().func_204610_c(new BlockPos(entity.func_174824_e(1.0f)));
                AcousticEvent evt = fs.func_206888_e() ? Constants.WALK : Constants.SWIM;
                FootstepLibrary.getSwimAcoustic().playAt(entity.func_213303_ch(), evt);
            }
            return true;
        }
        return false;
    }

    protected boolean hasSpecialStoppingConditions(@Nonnull LivingEntity entity) {
        return entity.func_70090_H();
    }

    @Nullable
    protected Association findAssociationMessyFoliage(@Nonnull LivingEntity entity, @Nonnull BlockPos pos) {
        IAcoustic acoustics;
        Association result = null;
        BlockPos up = pos.func_177984_a();
        BlockState above = entity.func_130014_f_().func_180495_p(up);
        if (above.func_185904_a() != Material.field_151579_a && (acoustics = FootstepLibrary.getBlockAcoustics(above, Substrate.MESSY)) == Constants.MESSY_GROUND && (acoustics = FootstepLibrary.getBlockAcoustics(above, Substrate.FOLIAGE)) != Constants.NOT_EMITTER) {
            result = new Association(entity, acoustics);
        }
        return result;
    }

    @Nullable
    protected Association addFootstepAccent(@Nonnull LivingEntity entity, @Nullable Association assoc) {
        if (entity.func_233570_aj_()) {
            accents.clear();
            BlockPos pos = assoc != null ? assoc.getStepPos() : entity.func_233580_cy_();
            FootstepAccents.provide(entity, pos, accents);
            if (accents.size() > 0) {
                if (assoc == null) {
                    IAcoustic acoustic = AcousticCompiler.combine(accents);
                    assoc = new Association(entity, acoustic);
                } else {
                    assoc.merge(accents.toArray((IAcoustic[])new IAcoustic[0]));
                }
            }
        }
        return assoc;
    }

    public String toString() {
        return "didJump: " + this.didJump + ' ' + "onLadder: " + this.isOnLadder + ' ' + "flying: " + this.isFlying + ' ' + "immobile: " + this.isImmobile + ' ' + "steps: " + this.pedometer;
    }
}

