/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse;

import com.craftingdead.immerse.ModDist;
import com.craftingdead.immerse.Permissions;
import com.craftingdead.immerse.client.ClientDist;
import com.craftingdead.immerse.command.Commands;
import com.craftingdead.immerse.game.Game;
import com.craftingdead.immerse.game.GameTypes;
import com.craftingdead.immerse.game.module.ModuleTypes;
import com.craftingdead.immerse.game.network.GameNetworkChannel;
import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.server.LogicalServer;
import com.craftingdead.immerse.server.ServerConfig;
import com.craftingdead.immerse.server.ServerDist;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import com.craftingdead.immerse.util.DependencyLoader;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.JarVersionLookupHandler;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="craftingdeadimmerse")
public class CraftingDeadImmerse {
    public static final String ID = "craftingdeadimmerse";
    public static final String VERSION = JarVersionLookupHandler.getImplementationVersion(CraftingDeadImmerse.class).orElse("[version]");
    public static final String DISPLAY_NAME = JarVersionLookupHandler.getImplementationTitle(CraftingDeadImmerse.class).orElse("[display_name]");
    public static final ServerConfig serverConfig;
    public static final ForgeConfigSpec serverConfigSpec;
    private static CraftingDeadImmerse instance;
    private final ModDist modDist;
    private final Path modDir;
    @Nullable
    private LogicalServer logicalServer;

    public CraftingDeadImmerse() {
        instance = this;
        DependencyLoader.loadDependencies();
        this.modDir = FMLPaths.CONFIGDIR.get().resolve(ID);
        if (!Files.exists(this.modDir, new LinkOption[0])) {
            try {
                Files.createDirectory(this.modDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverConfigSpec);
        this.modDist = (ModDist)DistExecutor.safeRunForDist(() -> ClientDist::new, () -> ServerDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        ImmerseSoundEvents.SOUND_EVENTS.register(modEventBus);
        GameTypes.GAME_TYPES.register(modEventBus);
        ModuleTypes.MODULE_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nullable
    public LogicalServer getLogicalServer() {
        return this.logicalServer;
    }

    public ModDist getModDist() {
        return this.modDist;
    }

    public ClientDist getClientDist() {
        if (this.modDist instanceof ClientDist) {
            return (ClientDist)this.modDist;
        }
        throw new IllegalStateException("Accessing client dist on wrong side");
    }

    public Path getModDir() {
        return this.modDir;
    }

    public Game<?> getGame(LogicalSide side) {
        switch (side) {
            case CLIENT: {
                return this.getClientDist().getGameClient();
            }
            case SERVER: {
                return this.getLogicalServer().getGame();
            }
        }
        throw new IllegalArgumentException("Unknown side: " + side.toString());
    }

    public static CraftingDeadImmerse getInstance() {
        return instance;
    }

    public void handleCommonSetup(FMLCommonSetupEvent event) {
        NetworkChannel.loadChannels();
        GameNetworkChannel.load();
        Permissions.register();
    }

    @SubscribeEvent
    public void handleRegisterCommands(RegisterCommandsEvent event) {
        Commands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void handleServerAboutToStart(FMLServerAboutToStartEvent event) {
        this.logicalServer = this.modDist.createLogicalServer(event.getServer());
        this.logicalServer.startLoading();
        MinecraftForge.EVENT_BUS.register((Object)this.logicalServer);
    }

    @SubscribeEvent
    public void handleServerStarting(FMLServerStartingEvent event) {
        this.logicalServer.finishLoading();
    }

    @SubscribeEvent
    public void handleServerStopped(FMLServerStoppedEvent event) {
        if (this.logicalServer != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.logicalServer);
            this.logicalServer = null;
        }
    }

    static {
        Pair serverConfigPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        serverConfigSpec = (ForgeConfigSpec)serverConfigPair.getRight();
        serverConfig = (ServerConfig)serverConfigPair.getLeft();
    }
}

