/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.ModDist;
import com.craftingdead.immerse.client.fake.FakePlayerEntity;
import com.craftingdead.immerse.client.gui.IngameGui;
import com.craftingdead.immerse.client.gui.screen.menu.MainMenuView;
import com.craftingdead.immerse.client.renderer.SpectatorRenderer;
import com.craftingdead.immerse.client.renderer.entity.layer.TeamClothingLayer;
import com.craftingdead.immerse.client.shader.RoundedFrameShader;
import com.craftingdead.immerse.client.shader.RoundedRectShader;
import com.craftingdead.immerse.client.util.ServerPinger;
import com.craftingdead.immerse.game.ClientGameWrapper;
import com.craftingdead.immerse.game.GameClient;
import com.craftingdead.immerse.game.GameType;
import com.craftingdead.immerse.server.LogicalServer;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientDist
implements ModDist,
ISelectiveResourceReloadListener {
    public static final KeyBinding SWITCH_TEAMS = new KeyBinding("key.switch_teams", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, InputMappings.Type.KEYSYM.func_197944_a(77), "key.categories.gameplay");
    public static final ResourceLocation BLUR_SHADER = new ResourceLocation("craftingdeadimmerse", "shaders/post/fade_in_blur.json");
    private static final Logger logger = LogManager.getLogger();
    private final Minecraft minecraft;
    @Nullable
    private LogicalServer logicalServer;
    private ClientGameWrapper gameWrapper;
    private final SpectatorRenderer spectatorRenderer;
    private final IngameGui ingameGui;

    public ClientDist() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.minecraft = Minecraft.func_71410_x();
        ((IReloadableResourceManager)this.minecraft.func_195551_G()).func_219534_a((IFutureReloadListener)this);
        this.spectatorRenderer = new SpectatorRenderer();
        this.ingameGui = new IngameGui();
    }

    @Nullable
    public ClientGameWrapper getGameWrapper() {
        return this.gameWrapper;
    }

    @Nullable
    public GameClient getGameClient() {
        return this.gameWrapper == null ? null : (GameClient)this.gameWrapper.getGame();
    }

    public SpectatorRenderer getSpectatorRenderer() {
        return this.spectatorRenderer;
    }

    public IngameGui getIngameGui() {
        return this.ingameGui;
    }

    public void loadGame(GameType gameType) {
        logger.info("Loading game: {}", (Object)gameType.getRegistryName().toString());
        try {
            if (this.gameWrapper != null) {
                this.gameWrapper.unload();
            }
            this.gameWrapper = new ClientGameWrapper(gameType.createGameClient());
            this.gameWrapper.load();
        }
        catch (Exception e) {
            logger.error("Failed to load game", (Throwable)e);
        }
    }

    @Override
    public LogicalServer createLogicalServer(MinecraftServer minecraftServer) {
        return new LogicalServer(minecraftServer);
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        RoundedRectShader.INSTANCE.compile(resourceManager);
        RoundedFrameShader.INSTANCE.compile(resourceManager);
    }

    private void handleClientSetup(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)SWITCH_TEAMS);
        CraftingDead.getInstance().getClientDist().registerPlayerLayer(TeamClothingLayer::new);
        this.minecraft.func_222817_e(() -> {
            StartupMessageManager.addModMessage((String)"Applying branding");
            try {
                InputStream smallIcon = this.minecraft.func_195551_G().func_199002_a(new ResourceLocation("craftingdeadimmerse", "textures/gui/icons/icon_16x16.png")).func_199027_b();
                InputStream mediumIcon = this.minecraft.func_195551_G().func_199002_a(new ResourceLocation("craftingdeadimmerse", "textures/gui/icons/icon_32x32.png")).func_199027_b();
                this.minecraft.func_228018_at_().func_216529_a(smallIcon, mediumIcon);
            }
            catch (IOException e) {
                logger.error("Couldn't set icon", (Throwable)e);
            }
        });
    }

    @SubscribeEvent
    public void handleRenderNameplate(RenderNameplateEvent event) {
        if (event.getEntity() instanceof FakePlayerEntity) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void handlePlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        if (this.gameWrapper != null) {
            this.gameWrapper.unload();
            this.gameWrapper = null;
        }
    }

    @SubscribeEvent
    public void handleRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerExtension player = CraftingDead.getInstance().getClientDist().getPlayerExtension().orElse(null);
        PlayerExtension viewingPlayer = this.minecraft.func_175606_aa() instanceof AbstractClientPlayerEntity ? (PlayerExtension)((AbstractClientPlayerEntity)this.minecraft.func_175606_aa()).getCapability(Capabilities.LIVING_EXTENSION).cast().orElse(null) : null;
        switch (event.getType()) {
            case ALL: {
                if (viewingPlayer == null || this.getGameClient() == null) break;
                this.ingameGui.renderOverlay((PlayerExtension<AbstractClientPlayerEntity>)viewingPlayer, event.getMatrixStack(), event.getWindow().func_198107_o(), event.getWindow().func_198087_p(), event.getPartialTicks());
                event.setCanceled(this.getGameClient().renderOverlay((PlayerExtension<? extends AbstractClientPlayerEntity>)viewingPlayer, event.getMatrixStack(), event.getWindow().func_198107_o(), event.getWindow().func_198087_p(), event.getPartialTicks()));
                break;
            }
            case PLAYER_LIST: {
                if (player == null || this.getGameClient() == null) break;
                event.setCanceled(this.getGameClient().renderPlayerList((PlayerExtension<? extends AbstractClientPlayerEntity>)player, event.getMatrixStack(), event.getWindow().func_198107_o(), event.getWindow().func_198087_p(), event.getPartialTicks()));
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleGuiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof MainMenuScreen || event.getGui() instanceof MultiplayerScreen) {
            event.setGui(MainMenuView.createScreen());
        }
    }

    @SubscribeEvent
    public void handleClientTick(TickEvent.ClientTickEvent event) {
        switch (event.phase) {
            case START: {
                boolean worldFocused;
                if (this.gameWrapper != null) {
                    this.gameWrapper.tick();
                }
                ServerPinger.INSTANCE.pingPendingNetworks();
                if (this.minecraft.field_71439_g == null) break;
                boolean bl = worldFocused = !this.minecraft.func_147113_T() && this.minecraft.field_213279_p == null && this.minecraft.field_71462_r == null;
                if (this.minecraft.field_71439_g.func_175149_v() && this.minecraft.func_175606_aa() instanceof RemoteClientPlayerEntity) {
                    this.spectatorRenderer.tick((AbstractClientPlayerEntity)this.minecraft.func_175606_aa());
                }
                if (!worldFocused || this.getGameClient() == null || !this.getGameClient().disableSwapHands()) break;
                while (this.minecraft.field_71474_y.field_186718_X.func_151468_f()) {
                }
                break;
            }
        }
    }
}

