/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen;

import com.craftingdead.immerse.client.gui.screen.menu.MainMenuView;
import com.craftingdead.immerse.client.gui.view.Colour;
import com.craftingdead.immerse.client.gui.view.FogView;
import com.craftingdead.immerse.client.gui.view.ParentView;
import com.craftingdead.immerse.client.gui.view.TextView;
import com.craftingdead.immerse.client.gui.view.ViewScreen;
import com.craftingdead.immerse.client.gui.view.event.ActionEvent;
import com.craftingdead.immerse.client.gui.view.layout.yoga.Align;
import com.craftingdead.immerse.client.gui.view.layout.yoga.Justify;
import com.craftingdead.immerse.client.gui.view.layout.yoga.PositionType;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayout;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayoutParent;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.DisconnectedScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.login.ClientLoginNetHandler;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectView
extends ParentView<ConnectView, ViewScreen, YogaLayout> {
    private static final Logger logger = LogManager.getLogger();
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("server-connector-%s").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(logger)).build());
    private final Iterator<String> animation = Iterators.cycle((Object[])new String[]{"O o o", "o O o", "o o O"});
    private long lastAnimationUpdateMs;
    private NetworkManager connection;
    private boolean aborted;
    private final Screen lastScreen;
    private final TextView<YogaLayout> statusView;
    private final TextView<YogaLayout> animationView;

    public ConnectView(ViewScreen layout, Screen lastScreen, String host, int port) {
        super(layout, new YogaLayoutParent().setAlignItems(Align.CENTER).setJustifyContent(Justify.CENTER));
        this.lastScreen = lastScreen;
        this.addChild(MainMenuView.createBackgroundView());
        this.addChild(new FogView<YogaLayout>(new YogaLayout().setPositionType(PositionType.ABSOLUTE).setHeightPercent(100.0f).setWidthPercent(100.0f)));
        this.statusView = new TextView<YogaLayout>(new YogaLayout().setWidthPercent(100.0f).setHeight(15.0f), (ITextComponent)new TranslationTextComponent("connect.connecting")).setCentered(true);
        this.animationView = new TextView<YogaLayout>(new YogaLayout().setWidthPercent(100.0f).setHeight(15.0f), this.nextAnimation()).setCentered(true);
        this.addChild(((ParentView)((ParentView)((ParentView)((ParentView)new ParentView(new YogaLayout().setWidthPercent(60.0f).setHeightPercent(60.0f), new YogaLayoutParent().setAlignItems(Align.CENTER).setJustifyContent(Justify.CENTER)).setBackgroundBlur(50.0f)).setBackgroundColour(new Colour(0x40111111L))).addChild(this.statusView)).addChild(this.animationView)).addChild(((TextView)((TextView)((TextView)new TextView<YogaLayout>(new YogaLayout().setWidth(150.0f).setHeight(20.0f).setTopMargin(50.0f), DialogTexts.field_240633_d_).setCentered(true).setBackgroundColour(new Colour(TextFormatting.RED.func_211163_e() + 0x64000000))).addBackgroundHoverAnimation(new Colour(TextFormatting.DARK_RED.func_211163_e() + 0x64000000), 150.0f)).addActionSound((SoundEvent)ImmerseSoundEvents.BUTTON_CLICK.get())).addListener(ActionEvent.class, (c, e) -> {
            this.aborted = true;
            if (this.connection != null) {
                this.connection.func_150718_a((ITextComponent)new TranslationTextComponent("connect.aborted"));
            }
            this.minecraft.func_147108_a(this.lastScreen);
        })));
        this.minecraft.func_213254_o();
        this.connect(host, port);
    }

    private void connect(String host, int port) {
        logger.info("Connecting to {}, {}", (Object)host, (Object)port);
        executorService.submit(() -> {
            InetAddress address = null;
            try {
                if (this.aborted) {
                    return;
                }
                address = InetAddress.getByName(host);
                this.connection = NetworkManager.func_181124_a((InetAddress)address, (int)port, (boolean)this.minecraft.field_71474_y.func_181148_f());
                this.connection.func_150719_a((INetHandler)new ClientLoginNetHandler(this.connection, this.minecraft, this.lastScreen, this.statusView::setText));
                this.connection.func_179290_a((IPacket)new CHandshakePacket(host, port, ProtocolType.LOGIN));
                this.connection.func_179290_a((IPacket)new CLoginStartPacket(this.minecraft.func_110432_I().func_148256_e()));
            }
            catch (UnknownHostException e) {
                if (this.aborted) {
                    return;
                }
                logger.error("Couldn't connect to server", (Throwable)e);
                this.minecraft.execute(() -> this.minecraft.func_147108_a((Screen)new DisconnectedScreen(this.lastScreen, DialogTexts.field_244280_i, (ITextComponent)new TranslationTextComponent("disconnect.genericReason", new Object[]{"Unknown host"}))));
            }
            catch (Exception e) {
                if (this.aborted) {
                    return;
                }
                logger.error("Couldn't connect to server", (Throwable)e);
                String censoredReason = address == null ? e.toString() : e.toString().replaceAll(address + ":" + port, "");
                this.minecraft.execute(() -> this.minecraft.func_147108_a((Screen)new DisconnectedScreen(this.lastScreen, DialogTexts.field_244280_i, (ITextComponent)new TranslationTextComponent("disconnect.genericReason", new Object[]{censoredReason}))));
            }
        });
    }

    @Override
    public void tick() {
        super.tick();
        if (this.connection != null) {
            if (this.connection.func_150724_d()) {
                this.connection.func_74428_b();
            } else {
                this.connection.func_179293_l();
            }
        }
        long currentTime = Util.func_211177_b();
        if (this.lastAnimationUpdateMs != -1L && currentTime - this.lastAnimationUpdateMs >= 100L) {
            this.lastAnimationUpdateMs = currentTime;
            this.animationView.setText(this.nextAnimation());
        }
    }

    private ITextComponent nextAnimation() {
        return new StringTextComponent(this.animation.next()).func_240699_a_(TextFormatting.GRAY);
    }

    public static Screen createScreen(Screen lastScreen, String host, int port) {
        return new ViewScreen(NarratorChatListener.field_216868_a, layout -> new ConnectView((ViewScreen)layout, lastScreen, host, port));
    }
}

