/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.game.shop;

import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.client.gui.screen.game.shop.GameButton;
import com.craftingdead.immerse.client.gui.screen.game.shop.InfoPanel;
import com.craftingdead.immerse.game.module.shop.ClientShopModule;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractShopScreen
extends Screen {
    private static final ITextComponent TITLE = new TranslationTextComponent("gui.screen.shop.title");
    private final List<GameButton> shopButtons = new ArrayList<GameButton>();
    private final Screen lastScreen;
    private final ClientShopModule shop;
    private final PlayerExtension<?> player;
    private int cachedBuyTime = -1;

    public AbstractShopScreen(Screen lastScreen, ClientShopModule shop, PlayerExtension<?> player) {
        super(TITLE);
        this.lastScreen = lastScreen;
        this.shop = shop;
        this.player = player;
    }

    protected void addShopButton(GameButton shopButton) {
        this.shopButtons.add(shopButton);
    }

    public ClientShopModule getShop() {
        return this.shop;
    }

    public void func_231160_c_() {
        int mx = this.field_230708_k_ / 2;
        int my = this.field_230709_l_ / 2;
        int x = mx - 140;
        int y = my - 72;
        int w1 = 100;
        int h1 = 20;
        int ym = 22;
        for (int i = 0; i < this.shopButtons.size(); ++i) {
            GameButton shopButton = this.shopButtons.get(i);
            shopButton.field_230690_l_ = x;
            shopButton.field_230691_m_ = y + i * ym;
            shopButton.func_230991_b_(w1);
            shopButton.setHeight(h1);
            this.func_230480_a_((Widget)shopButton);
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 66) {
            this.field_230706_i_.func_147108_a(this.lastScreen);
            return true;
        }
        return false;
    }

    public void func_231023_e_() {
        this.cachedBuyTime = this.shop.getBuyTimeSeconds();
        if (this.cachedBuyTime <= 0) {
            this.func_231175_as__();
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        boolean renderMoney;
        this.func_230446_a_(matrixStack);
        int mx = this.field_230708_k_ / 2;
        int my = this.field_230709_l_ / 2;
        com.craftingdead.immerse.client.util.RenderUtil.fillWithShadow(matrixStack, 0.0, 0.0, this.field_230708_k_, 30.0, Integer.MIN_VALUE);
        com.craftingdead.immerse.client.util.RenderUtil.fillWithShadow(matrixStack, 0.0, this.field_230709_l_ - 30, this.field_230708_k_, 30.0, Integer.MIN_VALUE);
        AbstractShopScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.screen.shop.back", new Object[]{"B"}).func_240699_a_(TextFormatting.ITALIC), (int)(mx - 150), (int)18, (int)-1);
        AbstractShopScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.func_231171_q_().func_230532_e_().func_240699_a_(TextFormatting.BOLD), (int)mx, (int)10, (int)-1);
        com.craftingdead.immerse.client.util.RenderUtil.renderTextRight(this.field_230712_o_, matrixStack, (float)(mx + 150), 18.0f, (ITextComponent)new TranslationTextComponent("gui.screen.shop.buy_time", new Object[]{new StringTextComponent(String.valueOf(this.cachedBuyTime)).func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.ITALIC), -1, true);
        int bh = this.shopButtons.size() * 22;
        com.craftingdead.immerse.client.util.RenderUtil.fillWithShadow(matrixStack, mx - 150, my - 80, 120.0, bh + 15, Integer.MIN_VALUE);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        com.craftingdead.immerse.client.util.RenderUtil.fillWithShadow(matrixStack, mx - 25, my - 80, 115.0, 160.0, Integer.MIN_VALUE);
        this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)new TranslationTextComponent("gui.screen.shop.selected").func_240699_a_(TextFormatting.BOLD), (float)(mx - 20), (float)(my - 75), -1);
        for (GameButton shopButton : this.shopButtons) {
            if (!(shopButton instanceof InfoPanel) || !shopButton.func_230449_g_()) continue;
            ((InfoPanel)((Object)shopButton)).renderInfo(mx, my, matrixStack, mouseX, mouseY, partialTicks);
        }
        int spacing = 5;
        int moneyHeight = 15;
        boolean bl = renderMoney = this.shop.getMoney() > -1;
        if (renderMoney) {
            com.craftingdead.immerse.client.util.RenderUtil.fillWithShadow(matrixStack, mx + 95, my - 80, 69.0, 15.0, Integer.MIN_VALUE);
            this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)new StringTextComponent("$" + this.shop.getMoney()).func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.GREEN}), (float)(mx + 100), (float)(my - 76), 0);
        }
        int inventoryYOffset = renderMoney ? 20 : 0;
        com.craftingdead.immerse.client.util.RenderUtil.fillWithShadow(matrixStack, mx + 95, my - 80 + inventoryYOffset, 69.0, 140.0, Integer.MIN_VALUE);
        this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)new TranslationTextComponent("gui.screen.shop.inventory").func_240699_a_(TextFormatting.BOLD), (float)(mx + 100), (float)(my - 75 + inventoryYOffset), -1);
        PlayerInventory inventory = ((PlayerEntity)this.player.getEntity()).field_71071_by;
        for (int i = 0; i < 7; ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            RenderUtil.renderGuiItem((ItemStack)itemStack, (int)(mx + 120), (int)(my - 60 + inventoryYOffset + i * 21), (int)-1, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.FIXED);
        }
    }
}

