/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.server;

import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerEntry;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerProvider;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonServerList
implements ServerProvider {
    private static final Logger logger = LogManager.getLogger();
    private static final Gson gson = new Gson();
    private final Path serverListFile;

    public JsonServerList(Path serverListFile) {
        this.serverListFile = serverListFile;
    }

    @Override
    public void read(final Consumer<ServerEntry> entryConsumer) {
        AsynchronousFileChannel fileChannel;
        try {
            fileChannel = AsynchronousFileChannel.open(this.serverListFile, StandardOpenOption.READ);
        }
        catch (IOException e) {
            logger.warn("Failed to read server list file", (Throwable)e);
            return;
        }
        final ByteBuffer buffer = ByteBuffer.allocate(1024);
        fileChannel.read(buffer, 0L, null, new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer result, Void attachment) {
                buffer.flip();
                byte[] bytes = new byte[buffer.limit()];
                buffer.get(bytes);
                String jsonString = new String(bytes, StandardCharsets.UTF_8).trim();
                JsonArray serverListJson = (JsonArray)gson.fromJson(jsonString, JsonArray.class);
                for (JsonElement jsonElement : serverListJson) {
                    JsonObject serverJson = jsonElement.getAsJsonObject();
                    entryConsumer.accept(new ServerEntry(serverJson.get("map").getAsString(), serverJson.get("hostName").getAsString(), serverJson.get("port").getAsInt()));
                }
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                logger.warn("Failed to read server list file", exc);
            }
        });
    }
}

