/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.server;

import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.MutableServerProvider;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerEntry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTMutableServerList
implements MutableServerProvider {
    private static final Logger logger = LogManager.getLogger();
    private static final Executor executor = Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setNameFormat("NBT Server List #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(logger)).build());
    private final Path serverListFile;

    public NBTMutableServerList(Path serverListFile) {
        this.serverListFile = serverListFile;
    }

    @Override
    public void read(Consumer<ServerEntry> entryConsumer) {
        executor.execute(() -> {
            CompoundNBT compoundNbt;
            try {
                compoundNbt = CompressedStreamTools.func_74797_a((File)this.serverListFile.toFile());
            }
            catch (IOException e) {
                logger.warn("Failed to read server list", (Throwable)e);
                return;
            }
            if (compoundNbt == null) {
                return;
            }
            ListNBT serversNbt = compoundNbt.func_150295_c("servers", 10);
            for (int i = 0; i < serversNbt.size(); ++i) {
                CompoundNBT serverEntry = serversNbt.func_150305_b(i);
                entryConsumer.accept(new ServerEntry(serverEntry.func_74764_b("map") ? serverEntry.func_74779_i("map") : null, serverEntry.func_74779_i("host"), serverEntry.func_74762_e("port")));
            }
        });
    }

    @Override
    public void write(ServerEntry entry) {
        executor.execute(() -> {
            try {
                ListNBT serversNbt;
                CompoundNBT compoundNbt = CompressedStreamTools.func_74797_a((File)this.serverListFile.toFile());
                if (compoundNbt == null) {
                    compoundNbt = new CompoundNBT();
                    serversNbt = new ListNBT();
                    compoundNbt.func_218657_a("servers", (INBT)serversNbt);
                } else {
                    serversNbt = compoundNbt.func_150295_c("servers", 10);
                    for (int i = 0; i < serversNbt.size(); ++i) {
                        CompoundNBT serverEntry = serversNbt.func_150305_b(i);
                        if (!serverEntry.func_74779_i("host").equals(entry.getHostName()) || serverEntry.func_74762_e("port") != entry.getPort()) continue;
                        return;
                    }
                }
                CompoundNBT serverEntry = new CompoundNBT();
                entry.getMap().ifPresent(map -> serverEntry.func_74778_a("map", map));
                serverEntry.func_74778_a("host", entry.getHostName());
                serverEntry.func_74768_a("port", entry.getPort());
                serversNbt.add((Object)serverEntry);
                this.save(compoundNbt);
            }
            catch (IOException e) {
                logger.warn("Failed to write server entry", (Throwable)e);
            }
        });
    }

    @Override
    public void delete(ServerEntry entry) {
        executor.execute(() -> {
            try {
                CompoundNBT compoundNbt = CompressedStreamTools.func_74797_a((File)this.serverListFile.toFile());
                ListNBT serversNbt = compoundNbt.func_150295_c("servers", 10);
                for (int i = 0; i < serversNbt.size(); ++i) {
                    CompoundNBT serverEntry = serversNbt.func_150305_b(i);
                    if (!serverEntry.func_74779_i("host").equals(entry.getHostName()) || serverEntry.func_74762_e("port") != entry.getPort()) continue;
                    serversNbt.remove(i);
                    break;
                }
                this.save(compoundNbt);
            }
            catch (IOException e) {
                logger.warn("Failed to delete server entry", (Throwable)e);
            }
        });
    }

    private void save(CompoundNBT compoundNbt) throws IOException {
        File tempFile = File.createTempFile("servers", ".dat", this.serverListFile.getParent().toFile());
        CompressedStreamTools.func_74795_b((CompoundNBT)compoundNbt, (File)tempFile);
        File oldFile = new File(this.serverListFile.getParent().toString(), "servers.dat_old");
        Util.func_240977_a_((File)this.serverListFile.toFile(), (File)tempFile, (File)oldFile);
    }
}

