/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.server;

import com.craftingdead.immerse.client.gui.screen.ConnectView;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerEntry;
import com.craftingdead.immerse.client.gui.view.Colour;
import com.craftingdead.immerse.client.gui.view.Overflow;
import com.craftingdead.immerse.client.gui.view.ParentView;
import com.craftingdead.immerse.client.gui.view.TextView;
import com.craftingdead.immerse.client.gui.view.event.ActionEvent;
import com.craftingdead.immerse.client.gui.view.layout.yoga.Align;
import com.craftingdead.immerse.client.gui.view.layout.yoga.FlexDirection;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayout;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayoutParent;
import com.craftingdead.immerse.client.util.ServerPinger;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

class ServerItemView
extends ParentView<ServerItemView, YogaLayout, YogaLayout> {
    private final Iterator<String> animation = Iterators.cycle((Object[])new String[]{"O o o", "o O o", "o o O"});
    private final ServerEntry serverEntry;
    private final TextView<YogaLayout> motdComponent;
    private final TextView<YogaLayout> pingComponent;
    private final TextView<YogaLayout> playersAmountComponent;
    private boolean selected = false;
    private long lastAnimationUpdateMs;

    ServerItemView(ServerEntry serverEntry) {
        super(new YogaLayout().setTopMargin(3.0f).setLeftMargin(7.0f).setRightMargin(7.0f).setLeftPadding(10.0f).setRightPadding(20.0f).setHeight(22.0f).setMaxWidth(520.0f), new YogaLayoutParent().setFlexDirection(FlexDirection.ROW).setAlignItems(Align.CENTER));
        this.serverEntry = serverEntry;
        this.motdComponent = ((TextView)new TextView<YogaLayout>(new YogaLayout().setFlex(2.0f).setWidthPercent(100.0f).setHeight(8.0f), "...").setOverflow(Overflow.HIDDEN)).setShadow(false).setCentered(true);
        this.pingComponent = new TextView<YogaLayout>(new YogaLayout().setWidth(60.0f).setLeftMargin(10.0f).setHeight(8.0f), "...").setShadow(false).setCentered(true);
        this.playersAmountComponent = new TextView<YogaLayout>(new YogaLayout().setWidth(60.0f).setLeftMargin(10.0f).setHeight(8.0f), "...").setShadow(false).setCentered(true);
        ((ServerItemView)((ServerItemView)((ServerItemView)((ServerItemView)((ServerItemView)((ServerItemView)this.setBackgroundColour(new Colour(-2010371028L))).setFocusable(true)).setDoubleClick(true)).addListener(ActionEvent.class, (c, e) -> this.connect()).addChild(this.motdComponent)).addChild(((TextView)new TextView<YogaLayout>(new YogaLayout().setFlex(1.0f).setHeight(8.0f), (ITextComponent)new StringTextComponent(this.serverEntry.getMap().orElse("-")).func_240699_a_(TextFormatting.GRAY)).setOverflow(Overflow.HIDDEN)).setShadow(false).setCentered(true))).addChild(this.pingComponent)).addChild(this.playersAmountComponent);
        this.ping();
    }

    @Override
    public void tick() {
        super.tick();
        long currentTime = Util.func_211177_b();
        if (this.lastAnimationUpdateMs != -1L && currentTime - this.lastAnimationUpdateMs >= 100L) {
            this.lastAnimationUpdateMs = currentTime;
            this.motdComponent.setText((ITextComponent)new StringTextComponent(this.animation.next()));
        }
    }

    public void connect() {
        this.getScreen().keepOpen();
        this.minecraft.func_147108_a(ConnectView.createScreen(this.getScreen(), this.serverEntry.getHostName(), this.serverEntry.getPort()));
    }

    public ServerEntry getServerEntry() {
        return this.serverEntry;
    }

    public void ping() {
        this.motdComponent.setText((ITextComponent)new StringTextComponent("..."));
        this.pingComponent.setText((ITextComponent)new StringTextComponent("..."));
        this.playersAmountComponent.setText((ITextComponent)new StringTextComponent("..."));
        this.lastAnimationUpdateMs = 0L;
        ServerPinger.INSTANCE.ping(this.serverEntry.getHostName(), this.serverEntry.getPort(), pingData -> this.minecraft.execute(() -> this.updateServerInfo((ServerPinger.PingData)pingData)));
    }

    private void updateServerInfo(ServerPinger.PingData pingData) {
        this.motdComponent.setText(pingData.getMotd());
        if (pingData.getPing() >= 0L) {
            long ping = pingData.getPing();
            String pingText = ping + "ms";
            pingText = ping < 200L ? TextFormatting.GREEN + pingText : (ping < 400L ? TextFormatting.YELLOW + pingText : (ping < 1200L ? TextFormatting.RED + pingText : TextFormatting.DARK_RED + pingText));
            this.pingComponent.setText((ITextComponent)new StringTextComponent(pingText));
        } else {
            this.pingComponent.setText((ITextComponent)new StringTextComponent("?"));
        }
        this.playersAmountComponent.setText(pingData.getPlayersAmount());
        this.lastAnimationUpdateMs = -1L;
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32 && this.focused) {
            this.selected = !this.selected;
            this.updateBorder();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    protected void focusChanged() {
        this.updateBorder();
    }

    @Override
    public void mouseEntered(double mouseX, double mouseY) {
        super.mouseEntered(mouseX, mouseY);
        this.updateBorder();
    }

    @Override
    public void mouseLeft(double mouseX, double mouseY) {
        super.mouseLeft(mouseX, mouseY);
        this.updateBorder();
    }

    private void updateBorder() {
        if (this.selected) {
            this.setBorderWidth(1.0f);
            this.setBorderColour(Colour.WHITE);
        } else if (this.isHovered() || this.isFocused()) {
            this.setBorderWidth(0.7f);
            this.setBorderColour(Colour.GRAY);
        } else {
            this.setBorderWidth(0.0f);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean consume = super.func_231044_a_(mouseX, mouseY, button);
        if (this.isHovered()) {
            this.selected = true;
            this.updateBorder();
        } else {
            this.selected = false;
            this.updateBorder();
        }
        return consume;
    }
}

