/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.server;

import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerEntry;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerItemView;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerProvider;
import com.craftingdead.immerse.client.gui.view.Colour;
import com.craftingdead.immerse.client.gui.view.Overflow;
import com.craftingdead.immerse.client.gui.view.ParentView;
import com.craftingdead.immerse.client.gui.view.TextView;
import com.craftingdead.immerse.client.gui.view.View;
import com.craftingdead.immerse.client.gui.view.event.ActionEvent;
import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.gui.view.layout.yoga.Align;
import com.craftingdead.immerse.client.gui.view.layout.yoga.FlexDirection;
import com.craftingdead.immerse.client.gui.view.layout.yoga.Justify;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayout;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayoutParent;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ServerListView<L extends Layout>
extends ParentView<ServerListView<L>, L, YogaLayout> {
    protected final ServerProvider serverProvider;
    protected final ParentView<?, YogaLayout, YogaLayout> listView;
    protected final ParentView<?, YogaLayout, YogaLayout> controlsView;
    @Nullable
    private ServerItemView selectedItem;
    private final View<?, YogaLayout> playButton;

    public ServerListView(L layout, ServerProvider serverEntryProvider) {
        super(layout, new YogaLayoutParent().setFlexDirection(FlexDirection.COLUMN));
        this.serverProvider = serverEntryProvider;
        this.listView = ((ParentView)new ParentView(new YogaLayout().setBottomPadding(7.0f).setHeight(60.0f).setFlexGrow(1.0f), new YogaLayoutParent().setFlexDirection(FlexDirection.COLUMN).setAlignItems(Align.CENTER)).setOverflow(Overflow.SCROLL)).addChild(this.firstTableRow());
        this.addChild(this.listView);
        this.playButton = ((View)ServerListView.createButton(new Colour(1716712119L), new Colour(1720905934L), (ITextComponent)new TranslationTextComponent("view.server_list.button.play"), () -> this.getSelectedItem().ifPresent(ServerItemView::connect)).setDisabledBackgroundColour(new Colour(858820974L), 150.0f)).setEnabled(false);
        this.controlsView = ((ParentView)((ParentView)new ParentView(new YogaLayout().setHeight(56.0f), new YogaLayoutParent().setJustifyContent(Justify.CENTER).setAlignItems(Align.CENTER).setFlexDirection(FlexDirection.COLUMN)).setBackgroundColour(new Colour(1074926098L))).addChild(this.createTopRowControls())).addChild(this.createBottomRowControls());
        this.addChild(this.controlsView);
        this.refresh();
    }

    protected ParentView<?, YogaLayout, YogaLayout> createTopRowControls() {
        return new ParentView(new YogaLayout().setFlex(1.0f).setWidth(220.0f), new YogaLayoutParent().setFlexDirection(FlexDirection.ROW).setAlignItems(Align.CENTER)).addChild(this.playButton.configure(view -> ((YogaLayout)view.getLayout()).setMargin(3.0f)));
    }

    protected ParentView<?, YogaLayout, YogaLayout> createBottomRowControls() {
        return ((ParentView)new ParentView(new YogaLayout().setFlex(1.0f).setWidth(220.0f), new YogaLayoutParent().setFlexDirection(FlexDirection.ROW).setAlignItems(Align.CENTER)).addChild(ServerListView.createButton(new Colour(1718925815L), new Colour(1720830975L), (ITextComponent)new TranslationTextComponent("view.server_list.button.quick_refresh"), this::quickRefresh).configure(view -> ((YogaLayout)view.getLayout()).setMargin(3.0f)))).addChild(ServerListView.createButton(new Colour(1718925815L), new Colour(1720830975L), (ITextComponent)new TranslationTextComponent("view.server_list.button.refresh"), this::refresh).configure(view -> ((YogaLayout)view.getLayout()).setMargin(3.0f)));
    }

    protected static View<?, YogaLayout> createButton(Colour colour, Colour hoveredColour, ITextComponent text, Runnable actionListener) {
        return ((ParentView)((ParentView)((ParentView)((ParentView)((View)new ParentView(new YogaLayout().setWidth(30.0f).setHeight(20.0f).setFlex(1.0f), new YogaLayoutParent().setJustifyContent(Justify.CENTER).setAlignItems(Align.CENTER)).addChild(new TextView<YogaLayout>(new YogaLayout().setHeight(8.0f), text).setShadow(false).setCentered(true))).setBackgroundColour(colour)).addBackgroundHoverAnimation(hoveredColour, 150.0f)).addActionSound((SoundEvent)ImmerseSoundEvents.BUTTON_CLICK.get())).setFocusable(true)).addListener(ActionEvent.class, (c, e) -> actionListener.run());
    }

    private View<?, YogaLayout> firstTableRow() {
        return ((ParentView)((ParentView)((ParentView)((ParentView)new ParentView(new YogaLayout().setTopMargin(5.0f).setBottomMargin(1.0f).setLeftMargin(7.0f).setRightMargin(7.0f).setLeftPadding(10.0f).setRightPadding(20.0f).setHeight(22.0f).setMaxWidth(520.0f), new YogaLayoutParent().setFlexDirection(FlexDirection.ROW).setAlignItems(Align.CENTER)).setBackgroundColour(new Colour(-2012081646L))).addChild(new TextView<YogaLayout>(new YogaLayout().setFlex(2.0f).setHeight(8.0f), (ITextComponent)new TranslationTextComponent("view.server_list.motd")).setShadow(false).setCentered(true))).addChild(new TextView<YogaLayout>(new YogaLayout().setFlex(1.0f).setHeight(8.0f), (ITextComponent)new TranslationTextComponent("view.server_list.map")).setShadow(false).setCentered(true))).addChild(new TextView<YogaLayout>(new YogaLayout().setWidth(60.0f).setHeight(8.0f).setLeftMargin(10.0f), (ITextComponent)new TranslationTextComponent("view.server_list.ping")).setShadow(false).setCentered(true))).addChild(new TextView<YogaLayout>(new YogaLayout().setWidth(60.0f).setHeight(8.0f).setLeftMargin(10.0f), (ITextComponent)new TranslationTextComponent("view.server_list.players")).setShadow(false).setCentered(true));
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean result = super.func_231044_a_(mouseX, mouseY, button);
        this.updateSelected();
        return result;
    }

    protected void updateSelected() {
        this.selectedItem = this.listView.getChildViews().stream().filter(child -> child instanceof ServerItemView).map(child -> (ServerItemView)child).filter(ServerItemView::isSelected).findAny().orElse(null);
        this.playButton.setEnabled(this.selectedItem != null);
    }

    public Optional<ServerItemView> getSelectedItem() {
        return Optional.ofNullable(this.selectedItem);
    }

    private void refresh() {
        this.listView.clearChildren();
        this.selectedItem = null;
        this.updateSelected();
        this.serverProvider.read(this::addServer);
    }

    private void quickRefresh() {
        for (View<?, YogaLayout> child : this.listView.getChildViews()) {
            if (!(child instanceof ServerItemView)) continue;
            ((ServerItemView)child).ping();
        }
    }

    protected void addServer(ServerEntry entry) {
        this.listView.addChild(new ServerItemView(entry));
        this.listView.layout();
    }
}

