/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.world;

import com.craftingdead.immerse.client.gui.screen.menu.play.list.world.WorldListView;
import com.craftingdead.immerse.client.gui.view.Colour;
import com.craftingdead.immerse.client.gui.view.ImageView;
import com.craftingdead.immerse.client.gui.view.ParentView;
import com.craftingdead.immerse.client.gui.view.TextView;
import com.craftingdead.immerse.client.gui.view.ViewScreen;
import com.craftingdead.immerse.client.gui.view.event.ActionEvent;
import com.craftingdead.immerse.client.gui.view.layout.yoga.FlexDirection;
import com.craftingdead.immerse.client.gui.view.layout.yoga.Justify;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayout;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayoutParent;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.AlertScreen;
import net.minecraft.client.gui.screen.ConfirmBackupScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.EditWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorkingScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class WorldItemView
extends ParentView<WorldItemView, YogaLayout, YogaLayout> {
    private static final Logger logger = LogManager.getLogger();
    private static final DateFormat dateFormat = new SimpleDateFormat();
    private static final ResourceLocation UNKOWN_SERVER_ICON = new ResourceLocation("textures/misc/unknown_server.png");
    private final WorldSummary worldSummary;
    private final WorldListView<?> parentWorldList;
    private boolean selected = false;

    WorldItemView(WorldSummary worldSummary, WorldListView<?> parentWorldList) {
        super(new YogaLayout().setHeight(46.0f).setTopMargin(6.0f).setMaxWidth(300.0f).setPadding(4.0f), new YogaLayoutParent().setFlexDirection(FlexDirection.ROW));
        this.worldSummary = worldSummary;
        this.parentWorldList = parentWorldList;
        String displayName = worldSummary.func_75788_b();
        String info = worldSummary.func_75786_a() + " (" + dateFormat.format(new Date(worldSummary.func_75784_e())) + ")";
        String description = worldSummary.func_237316_p_().getString();
        String levelId = worldSummary.func_75786_a();
        ResourceLocation dynamicWorldIcon = new ResourceLocation("worlds/" + Util.func_244361_a((String)levelId, ResourceLocation::func_240909_b_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)levelId) + "/icon");
        ResourceLocation worldIcon = this.loadIconTexture(worldSummary, dynamicWorldIcon) != null ? dynamicWorldIcon : UNKOWN_SERVER_ICON;
        ((WorldItemView)((WorldItemView)((WorldItemView)((WorldItemView)this.setBackgroundColour(new Colour(-2010371028L))).setFocusable(true)).setDoubleClick(true)).addListener(ActionEvent.class, (c, e) -> this.joinWorld()).addChild(new ImageView<YogaLayout>(new YogaLayout().setHeight(38.0f).setWidth(38.0f).setRightMargin(5.0f)).setImage(worldIcon))).addChild(((ParentView)((ParentView)new ParentView(new YogaLayout().setWidth(120.0f).setFlexGrow(1.0f).setBottomPadding(1.0f), new YogaLayoutParent().setFlexDirection(FlexDirection.COLUMN).setJustifyContent(Justify.CENTER)).addChild(new TextView<YogaLayout>(new YogaLayout(), (ITextComponent)new StringTextComponent(displayName)).setShadow(false))).addChild(new TextView<YogaLayout>(new YogaLayout().setTopMargin(2.0f), (ITextComponent)new StringTextComponent(info).func_240699_a_(TextFormatting.GRAY)).setShadow(false))).addChild(new TextView<YogaLayout>(new YogaLayout(), (ITextComponent)new StringTextComponent(description).func_240699_a_(TextFormatting.GRAY)).setShadow(false)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private DynamicTexture loadIconTexture(WorldSummary worldSummary, ResourceLocation textureLocation) {
        File iconFile = worldSummary.func_237312_c_();
        if (!iconFile.isFile()) {
            this.minecraft.func_110434_K().func_147645_c(textureLocation);
            return null;
        }
        try (FileInputStream inputStream = new FileInputStream(iconFile);){
            NativeImage image = NativeImage.func_195713_a((InputStream)inputStream);
            Validate.validState((image.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
            Validate.validState((image.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
            DynamicTexture texture = new DynamicTexture(image);
            this.minecraft.func_110434_K().func_229263_a_(textureLocation, (Texture)texture);
            DynamicTexture dynamicTexture = texture;
            return dynamicTexture;
        }
        catch (Throwable throwable6) {
            logger.error("Invalid icon for world {}", (Object)worldSummary.func_75786_a(), (Object)throwable6);
            return null;
        }
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32 && this.focused) {
            this.selected = !this.selected;
            this.updateBorder();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public void mouseEntered(double mouseX, double mouseY) {
        super.mouseEntered(mouseX, mouseY);
        this.updateBorder();
    }

    @Override
    public void mouseLeft(double mouseX, double mouseY) {
        super.mouseLeft(mouseX, mouseY);
        this.updateBorder();
    }

    private void updateBorder() {
        if (this.selected) {
            this.setBorderWidth(1.0f);
            this.setBorderColour(Colour.WHITE);
        } else if (this.isHovered() || this.isFocused()) {
            this.setBorderWidth(0.7f);
            this.setBorderColour(Colour.GRAY);
        } else {
            this.setBorderWidth(0.0f);
        }
    }

    public void removeSelect() {
        this.selected = false;
        this.updateBorder();
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean consume = super.func_231044_a_(mouseX, mouseY, button);
        if (this.isHovered()) {
            this.selected = true;
            this.updateBorder();
        } else {
            this.selected = false;
            this.updateBorder();
        }
        return consume;
    }

    public void joinWorld() {
        if (!this.worldSummary.func_237315_o_()) {
            if (this.worldSummary.func_197731_n()) {
                TranslationTextComponent backupQuestion = new TranslationTextComponent("selectWorld.backupQuestion");
                TranslationTextComponent backupWarning = new TranslationTextComponent("selectWorld.backupWarning", new Object[]{this.worldSummary.func_237313_j_(), SharedConstants.func_215069_a().getName()});
                this.getScreen().keepOpenAndSetScreen((Screen)new ConfirmBackupScreen((Screen)this.getScreen(), (backup, eraseCache) -> {
                    if (backup) {
                        String levelName = this.worldSummary.func_75788_b();
                        try (SaveFormat.LevelSave levelSave = this.minecraft.func_71359_d().func_237274_c_(levelName);){
                            EditWorldScreen.func_239019_a_((SaveFormat.LevelSave)levelSave);
                        }
                        catch (IOException ioexception) {
                            SystemToast.func_238535_a_((Minecraft)this.minecraft, (String)levelName);
                            logger.error("Failed to backup level {}", (Object)levelName, (Object)ioexception);
                        }
                    }
                    this.loadWorld();
                    this.getScreen().func_231164_f_();
                }, (ITextComponent)backupQuestion, (ITextComponent)backupWarning, false));
            } else if (this.worldSummary.func_186356_m()) {
                this.getScreen().keepOpenAndSetScreen((Screen)new ConfirmScreen(confirm -> {
                    if (confirm) {
                        try {
                            this.loadWorld();
                            this.getScreen().func_231164_f_();
                        }
                        catch (Exception exception) {
                            logger.error("Failure to open 'future world'", (Throwable)exception);
                            this.minecraft.func_147108_a((Screen)new AlertScreen(() -> this.minecraft.func_147108_a(this.minecraft.field_71462_r), (ITextComponent)new TranslationTextComponent("selectWorld.futureworld.error.title"), (ITextComponent)new TranslationTextComponent("selectWorld.futureworld.error.text")));
                        }
                    } else {
                        this.minecraft.func_147108_a((Screen)this.getScreen());
                    }
                }, (ITextComponent)new TranslationTextComponent("selectWorld.versionQuestion"), (ITextComponent)new TranslationTextComponent("selectWorld.versionWarning", new Object[]{this.worldSummary.func_237313_j_(), new TranslationTextComponent("selectWorld.versionJoinButton"), DialogTexts.field_240633_d_})));
            } else {
                this.loadWorld();
            }
        }
    }

    private void loadWorld() {
        if (this.minecraft.func_71359_d().func_90033_f(this.worldSummary.func_75788_b())) {
            this.minecraft.func_241562_c_((Screen)new DirtMessageScreen((ITextComponent)new TranslationTextComponent("selectWorld.data_read")));
            this.minecraft.func_238191_a_(this.worldSummary.func_75786_a());
        }
    }

    public void editWorld() {
        String fileName = this.worldSummary.func_75788_b();
        try {
            SaveFormat.LevelSave levelSave = this.minecraft.func_71359_d().func_237274_c_(fileName);
            ViewScreen screen = this.getScreen();
            screen.keepOpenAndSetScreen((Screen)new EditWorldScreen(confirm -> {
                try {
                    levelSave.close();
                }
                catch (IOException ioexception1) {
                    logger.error("Failed to unlock level {}", (Object)fileName, (Object)ioexception1);
                }
                if (confirm) {
                    this.parentWorldList.reloadWorlds();
                }
                this.minecraft.func_147108_a((Screen)screen);
            }, levelSave));
        }
        catch (IOException ioexception) {
            SystemToast.func_238535_a_((Minecraft)this.minecraft, (String)fileName);
            logger.error("Failed to access level {}", (Object)fileName, (Object)ioexception);
            this.parentWorldList.reloadWorlds();
        }
    }

    public void deleteWorld() {
        ViewScreen screen = this.getScreen();
        screen.keepOpenAndSetScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                this.minecraft.func_147108_a((Screen)new WorkingScreen());
                SaveFormat levelSource = this.minecraft.func_71359_d();
                String s = this.worldSummary.func_75788_b();
                try (SaveFormat.LevelSave levelSave = levelSource.func_237274_c_(s);){
                    levelSave.func_237299_g_();
                }
                catch (IOException ioexception) {
                    SystemToast.func_238538_b_((Minecraft)this.minecraft, (String)s);
                    logger.error("Failed to delete world {}", (Object)s, (Object)ioexception);
                }
                this.parentWorldList.reloadWorlds();
            }
            this.minecraft.func_147108_a((Screen)screen);
        }, (ITextComponent)new TranslationTextComponent("selectWorld.deleteQuestion"), (ITextComponent)new TranslationTextComponent("selectWorld.deleteWarning", new Object[]{this.worldSummary.func_75788_b()}), (ITextComponent)new TranslationTextComponent("selectWorld.deleteButton"), DialogTexts.field_240633_d_));
    }

    public void recreateWorld() {
        this.getScreen().keepOpen();
        this.minecraft.func_241562_c_((Screen)new DirtMessageScreen((ITextComponent)new TranslationTextComponent("selectWorld.data_read")));
        DynamicRegistries.Impl dynamicRegistries = DynamicRegistries.func_239770_b_();
        try (SaveFormat.LevelSave levelSave = this.minecraft.func_71359_d().func_237274_c_(this.worldSummary.func_75788_b());
             Minecraft.PackManager serverStem = this.minecraft.func_238189_a_(dynamicRegistries, Minecraft::func_238180_a_, Minecraft::func_238181_a_, false, levelSave);){
            WorldSettings levelSettings = serverStem.func_238226_c_().func_230408_H_();
            DatapackCodec dataPackCodec = levelSettings.func_234958_g_();
            DimensionGeneratorSettings worldGenSettings = serverStem.func_238226_c_().func_230418_z_();
            Path path = CreateWorldScreen.func_238943_a_((Path)levelSave.func_237285_a_(FolderName.field_237251_g_), (Minecraft)this.minecraft);
            if (worldGenSettings.func_236229_j_()) {
                this.minecraft.func_147108_a((Screen)new ConfirmScreen(confirm -> this.minecraft.func_147108_a((Screen)(confirm ? new CreateWorldScreen((Screen)this.getScreen(), levelSettings, worldGenSettings, path, dataPackCodec, dynamicRegistries) : this.getScreen())), (ITextComponent)new TranslationTextComponent("selectWorld.recreate.customized.title"), (ITextComponent)new TranslationTextComponent("selectWorld.recreate.customized.text"), DialogTexts.field_240636_g_, DialogTexts.field_240633_d_));
            } else {
                this.minecraft.func_147108_a((Screen)new CreateWorldScreen((Screen)this.getScreen(), levelSettings, worldGenSettings, path, dataPackCodec, dynamicRegistries));
            }
        }
        catch (Exception e) {
            logger.error("Unable to recreate world", (Throwable)e);
            this.minecraft.func_147108_a((Screen)new AlertScreen(() -> this.minecraft.func_147108_a((Screen)this.getScreen()), (ITextComponent)new TranslationTextComponent("selectWorld.recreate.error.title"), (ITextComponent)new TranslationTextComponent("selectWorld.recreate.error.text")));
        }
    }
}

