/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.world;

import com.craftingdead.immerse.client.gui.screen.menu.play.list.world.WorldItemView;
import com.craftingdead.immerse.client.gui.view.Colour;
import com.craftingdead.immerse.client.gui.view.Overflow;
import com.craftingdead.immerse.client.gui.view.ParentView;
import com.craftingdead.immerse.client.gui.view.TextView;
import com.craftingdead.immerse.client.gui.view.View;
import com.craftingdead.immerse.client.gui.view.event.ActionEvent;
import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.gui.view.layout.yoga.Align;
import com.craftingdead.immerse.client.gui.view.layout.yoga.FlexDirection;
import com.craftingdead.immerse.client.gui.view.layout.yoga.Justify;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayout;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayoutParent;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.WorldSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldListView<L extends Layout>
extends ParentView<WorldListView<L>, L, YogaLayout> {
    private static final Logger logger = LogManager.getLogger();
    private final ParentView<?, YogaLayout, YogaLayout> listView = (ParentView)new ParentView(new YogaLayout().setFlex(1.0f).setTopPadding(4.0f).setBottomPadding(10.0f), new YogaLayoutParent().setFlexDirection(FlexDirection.COLUMN).setAlignItems(Align.CENTER)).setOverflow(Overflow.SCROLL);
    @Nullable
    private WorldItemView selectedItem;
    private final View<?, YogaLayout> playButton;
    private final View<?, YogaLayout> editButton;
    private final View<?, YogaLayout> deleteButton;
    private final View<?, YogaLayout> recreateButton;

    public WorldListView(L layout) {
        super(layout, new YogaLayoutParent().setFlexDirection(FlexDirection.COLUMN));
        this.loadWorlds();
        this.playButton = ((ParentView)WorldListView.createButton(new Colour(1716712119L), new Colour(1720905934L), (ITextComponent)new TranslationTextComponent("view.world_list.button.play"), () -> this.getSelectedItem().ifPresent(WorldItemView::joinWorld)).setDisabledBackgroundColour(new Colour(858820974L), 150.0f)).configure(view -> ((YogaLayout)view.getLayout()).setMargin(3.0f)).setEnabled(false);
        ParentView createButton = WorldListView.createButton(new Colour(1718925815L), new Colour(1720830975L), (ITextComponent)new TranslationTextComponent("view.world_list.button.create"), () -> this.getScreen().keepOpenAndSetScreen((Screen)CreateWorldScreen.func_243425_a((Screen)this.getScreen()))).configure(view -> ((YogaLayout)view.getLayout()).setMargin(3.0f));
        this.editButton = ((ParentView)WorldListView.createButton(new Colour(1718925815L), new Colour(1720830975L), (ITextComponent)new TranslationTextComponent("view.world_list.button.edit"), () -> this.getSelectedItem().ifPresent(WorldItemView::editWorld)).setDisabledBackgroundColour(new Colour(856121776L), 150.0f)).configure(view -> ((YogaLayout)view.getLayout()).setMargin(3.0f)).setEnabled(false);
        this.deleteButton = ((ParentView)WorldListView.createButton(new Colour(1728017795L), new Colour(1728023704L), (ITextComponent)new TranslationTextComponent("view.world_list.button.delete"), () -> this.getSelectedItem().ifPresent(WorldItemView::deleteWorld)).setDisabledBackgroundColour(new Colour(865354571L), 150.0f)).configure(view -> ((YogaLayout)view.getLayout()).setMargin(3.0f)).setEnabled(false);
        this.recreateButton = ((ParentView)WorldListView.createButton(new Colour(1718925815L), new Colour(1720830975L), (ITextComponent)new TranslationTextComponent("view.world_list.button.recreate"), () -> this.getSelectedItem().ifPresent(WorldItemView::recreateWorld)).setDisabledBackgroundColour(new Colour(856121776L), 150.0f)).configure(view -> ((YogaLayout)view.getLayout()).setMargin(3.0f)).setEnabled(false);
        Object controlsContainer = ((ParentView)((ParentView)new ParentView(new YogaLayout().setHeight(56.0f), new YogaLayoutParent().setJustifyContent(Justify.CENTER).setAlignItems(Align.CENTER).setFlexDirection(FlexDirection.COLUMN)).setBackgroundColour(new Colour(1074926098L))).addChild(((ParentView)new ParentView(new YogaLayout().setFlex(1.0f).setWidth(220.0f), new YogaLayoutParent().setFlexDirection(FlexDirection.ROW).setAlignItems(Align.CENTER)).addChild(this.playButton)).addChild(createButton))).addChild(((ParentView)((ParentView)new ParentView(new YogaLayout().setFlex(1.0f).setWidth(220.0f), new YogaLayoutParent().setFlexDirection(FlexDirection.ROW).setAlignItems(Align.CENTER)).addChild(this.deleteButton)).addChild(this.editButton)).addChild(this.recreateButton));
        this.addChild(this.listView);
        this.addChild(controlsContainer);
    }

    private static ParentView<?, YogaLayout, YogaLayout> createButton(Colour colour, Colour hoveredColour, ITextComponent text, Runnable actionListener) {
        return ((ParentView)((ParentView)((ParentView)((ParentView)new ParentView(new YogaLayout().setWidth(30.0f).setHeight(20.0f).setFlex(1.0f), new YogaLayoutParent().setJustifyContent(Justify.CENTER).setAlignItems(Align.CENTER)).addActionSound((SoundEvent)ImmerseSoundEvents.BUTTON_CLICK.get())).setBackgroundColour(colour)).setFocusable(true)).addBackgroundHoverAnimation(hoveredColour, 150.0f)).addListener(ActionEvent.class, (c, e) -> actionListener.run()).addChild(new TextView<YogaLayout>(new YogaLayout().setTopMargin(1.0f), text).setShadow(false).setCentered(true));
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean result = super.func_231044_a_(mouseX, mouseY, button);
        this.updateSelected();
        return result;
    }

    protected void updateSelected() {
        this.selectedItem = this.listView.getChildViews().stream().filter(child -> child instanceof WorldItemView).map(child -> (WorldItemView)child).filter(WorldItemView::isSelected).findAny().orElse(null);
        boolean enabled = this.selectedItem != null;
        this.playButton.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
        this.recreateButton.setEnabled(enabled);
    }

    private void loadWorlds() {
        try {
            List saveList = this.minecraft.func_71359_d().func_75799_b();
            Collections.sort(saveList);
            for (WorldSummary worldSummary : saveList) {
                this.listView.addChild(new WorldItemView(worldSummary, this));
            }
        }
        catch (AnvilConverterException e) {
            logger.error("Unable to load save list", (Throwable)e);
        }
    }

    public void reloadWorlds() {
        this.listView.clearChildren();
        this.selectedItem = null;
        this.updateSelected();
        this.loadWorlds();
    }

    private Optional<WorldItemView> getSelectedItem() {
        return Optional.ofNullable(this.selectedItem);
    }
}

