/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view;

import com.craftingdead.core.client.util.RenderUtil;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Blur
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation BLUR_SHADER = new ResourceLocation("craftingdeadimmerse", "shaders/post/blur.json");
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private ShaderGroup blurShader;
    private float lastFramebufferWidth;
    private float lastFramebufferHeight;

    public Blur() {
        this(-1.0f);
    }

    public Blur(float radius) {
        try {
            this.blurShader = new ShaderGroup(this.minecraft.func_110434_K(), this.minecraft.func_195551_G(), this.minecraft.func_147110_a(), BLUR_SHADER);
            this.setRadius(radius);
            this.blurShader.func_148026_a(this.minecraft.func_228018_at_().func_198109_k(), this.minecraft.func_228018_at_().func_198091_l());
        }
        catch (JsonSyntaxException | IOException ioexception) {
            logger.warn("Failed to load shader: {}", (Object)BLUR_SHADER, (Object)ioexception);
            this.blurShader = null;
        }
    }

    public void setRadius(float radius) {
        if (radius > -1.0f) {
            RenderUtil.updateUniform((String)"Radius", (float)radius, (ShaderGroup)this.blurShader);
        }
    }

    public void tick() {
        float framebufferWidth = this.minecraft.func_147110_a().field_147622_a;
        float framebufferHeight = this.minecraft.func_147110_a().field_147620_b;
        if (framebufferWidth != this.lastFramebufferWidth || framebufferHeight != this.lastFramebufferHeight) {
            if (this.blurShader != null) {
                this.blurShader.func_148026_a(this.minecraft.func_228018_at_().func_198109_k(), this.minecraft.func_228018_at_().func_198091_l());
            }
            this.lastFramebufferWidth = framebufferWidth;
            this.lastFramebufferHeight = framebufferHeight;
        }
    }

    public void render(MatrixStack matrixStack, float x, float y, float width, float height, float partialTicks) {
        this.blurShader.func_148018_a(partialTicks);
        RenderSystem.enableTexture();
        this.minecraft.func_147110_a().func_147610_a(false);
        Framebuffer framebuffer = this.blurShader.func_177066_a("output");
        framebuffer.func_147612_c();
        float textureWidth = (float)((double)framebuffer.field_147622_a / this.minecraft.func_228018_at_().func_198100_s());
        float textureHeight = (float)((double)framebuffer.field_147620_b / this.minecraft.func_228018_at_().func_198100_s());
        float textureX = x;
        float textureY = textureHeight - height - y;
        com.craftingdead.immerse.client.util.RenderUtil.blit(matrixStack, x, y, x + width, y + height, textureX, textureY, textureX + width, textureY + height, textureWidth, textureHeight);
    }

    @Override
    public void close() {
        this.blurShader.close();
    }
}

