/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view;

import com.craftingdead.immerse.client.gui.view.Overflow;
import com.craftingdead.immerse.client.gui.view.View;
import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.gui.view.layout.MeasureMode;
import com.craftingdead.immerse.client.util.RenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;

public class DropdownView<L extends Layout>
extends View<DropdownView<L>, L>
implements INestedGuiEventHandler {
    public static final int DEFAULT_HEIGHT = 14;
    public static final int DEFAULT_ITEM_BACKGROUND_COLOUR = -12303292;
    public static final int DEFAULT_SELECTED_ITEM_BACKGROUND_COLOUR = -14540254;
    public static final int DEFAULT_HOVERED_ITEM_BACKGROUND_COLOUR = -13421773;
    public static final int DEFAULT_Z_LEVEL = 5;
    public static final double DEFAULT_ARROW_WIDTH = 12.0;
    public static final double DEFAULT_ARROW_HEIGHT = 5.0;
    public static final double DEFAULT_ARROW_LINE_WIDTH = 1.6;
    public static final double DEFAULT_X_ARROW_OFFSET = 0.18;
    private final List<Item> items = new ArrayList<Item>();
    private int itemBackgroundColour = -12303292;
    private int selectedItemBackgroundColour = -14540254;
    private int hoveredItemBackgroundColour = -13421773;
    private boolean expanded = false;
    private int selectedItemIndex = -1;
    private boolean init = false;
    private double arrowWidth;
    private double arrowHeight;
    private double arrowLineWidth;
    private double arrowLineWidthX;
    private double arrowLineWidthY;
    private double xArrowOffset;
    @Nullable
    private IGuiEventListener focusedListener;
    private boolean dragging;

    public DropdownView(L layout) {
        super(layout);
        this.setZOffset(5.0f);
        this.arrowWidth = 12.0;
        this.arrowHeight = 5.0;
        this.arrowLineWidth = 1.6;
        this.calculateArrowLineWidthProjections();
        this.xArrowOffset = 0.18;
        this.setOverflow(Overflow.VISIBLE);
    }

    @Override
    protected Vector2f measure(MeasureMode widthMode, float width, MeasureMode heightMode, float height) {
        return new Vector2f(width, 14.0f);
    }

    public DropdownView<L> setArrowWidth(double arrowWidth) {
        this.arrowWidth = arrowWidth;
        this.calculateArrowLineWidthProjections();
        return this;
    }

    public DropdownView<L> setArrowHeight(double arrowHeight) {
        this.arrowHeight = arrowHeight;
        this.calculateArrowLineWidthProjections();
        return this;
    }

    public DropdownView<L> setArrowLineWidth(double arrowLineWidth) {
        this.arrowLineWidth = arrowLineWidth;
        this.calculateArrowLineWidthProjections();
        return this;
    }

    public DropdownView<L> setXArrowOffset(double xArrowOffset) {
        this.xArrowOffset = xArrowOffset;
        return this;
    }

    public DropdownView<L> setItemBackgroundColour(int itemBackgroundColour) {
        this.itemBackgroundColour = itemBackgroundColour;
        return this;
    }

    public DropdownView<L> setSelectedItemBackgroundColour(int selectedItemBackgroundColour) {
        this.selectedItemBackgroundColour = selectedItemBackgroundColour;
        return this;
    }

    public DropdownView<L> setHoveredItemBackgroundColour(int hoveredItemBackgroundColour) {
        this.hoveredItemBackgroundColour = hoveredItemBackgroundColour;
        return this;
    }

    public DropdownView<L> addItem(ITextComponent text, Runnable actionListener) {
        this.items.add(new Item(this.items.size(), text, actionListener));
        return this;
    }

    public DropdownView<L> setDisabled(int itemId, boolean disabled) {
        this.items.get(itemId).setDisabled(disabled);
        return this;
    }

    public Item getSelectedItem() {
        return this.items.get(this.selectedItemIndex);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (super.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.expanded || this.func_231047_b_(mouseX, mouseY)) {
            if (this.expanded) {
                super.func_231044_a_(mouseX, mouseY, button);
            }
            this.expanded = !this.expanded;
            return true;
        }
        return false;
    }

    @Override
    protected void layout() {
        super.layout();
        this.init();
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        if (this.selectedItemIndex == -1 && this.items.size() > 0) {
            this.selectedItemIndex = 0;
            this.items.get(0).actionListener.run();
        }
    }

    @Override
    public boolean func_231049_c__(boolean forward) {
        if (this.expanded) {
            if (!super.func_231049_c__(forward)) {
                this.toggleExpanded();
            }
        } else {
            this.toggleExpanded();
        }
        return this.expanded;
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return super.func_231046_a_(keyCode, scanCode, modifiers) || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return Collections.unmodifiableList(this.items);
    }

    protected void toggleExpanded() {
        this.expanded = !this.expanded;
        this.setZOffset(this.expanded ? 1.0f : 0.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_231047_b_(double mouseX, double mouseY) {
        if (!(mouseX > (double)this.getScaledX())) return false;
        if (!(mouseX < (double)(this.getScaledX() + this.getScaledWidth()))) return false;
        if (!(mouseY > (double)this.getScaledY())) return false;
        float f = this.getScaledY() + this.getScaledHeight();
        int n = this.expanded ? this.items.size() * this.getItemHeight() : 0;
        if (!(mouseY < (double)(f + (float)n))) return false;
        return true;
    }

    protected int getItemHeight() {
        return (int)this.getScaledContentHeight();
    }

    @Override
    public void renderContent(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.renderContent(matrixStack, mouseX, mouseY, partialTicks);
        this.items.get(this.selectedItemIndex).render(matrixStack, Type.SELECTED);
        this.renderArrow();
        if (this.expanded) {
            for (Item item : this.items) {
                Type type = item.disabled ? Type.DISABLED : (item.index == this.selectedItemIndex ? Type.HIGHLIGHTED : (item.func_231047_b_(mouseX, mouseY) || this.focusedListener == item ? Type.HOVERED : Type.NONE));
                item.render(matrixStack, type);
            }
        }
    }

    private void renderArrow() {
        RenderSystem.pushMatrix();
        double xOffset = (double)this.getScaledContentX() + (double)this.getScaledContentWidth() * (1.0 - this.xArrowOffset);
        double yOffset = (double)this.getScaledContentY() + ((double)this.getScaledContentHeight() - this.arrowHeight) / 2.0;
        RenderSystem.translated((double)xOffset, (double)yOffset, (double)0.0);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        builder.func_225582_a_(0.0, 0.0, 0.0).func_181675_d();
        builder.func_225582_a_(this.arrowWidth / 2.0, this.arrowHeight, 0.0).func_181675_d();
        builder.func_225582_a_(this.arrowWidth / 2.0, this.arrowHeight - this.arrowLineWidthY, 0.0).func_181675_d();
        builder.func_225582_a_(this.arrowLineWidthX, 0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        builder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        builder.func_225582_a_(this.arrowWidth - this.arrowLineWidthX, 0.0, 0.0).func_181675_d();
        builder.func_225582_a_(this.arrowWidth / 2.0, this.arrowHeight - this.arrowLineWidthY, 0.0).func_181675_d();
        builder.func_225582_a_(this.arrowWidth / 2.0, this.arrowHeight, 0.0).func_181675_d();
        builder.func_225582_a_(this.arrowWidth, 0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.popMatrix();
    }

    private void calculateArrowLineWidthProjections() {
        double arrowLinePitchRad = Math.toRadians(90.0) - Math.atan(this.arrowWidth / 2.0 / this.arrowHeight);
        this.arrowLineWidthX = this.arrowLineWidth / Math.sin(arrowLinePitchRad);
        this.arrowLineWidthY = this.arrowHeight - Math.tan(arrowLinePitchRad) * (this.arrowWidth / 2.0 - this.arrowLineWidthX);
    }

    public final boolean func_231041_ay__() {
        return this.dragging;
    }

    public final void func_231037_b__(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public IGuiEventListener func_241217_q_() {
        return this.focusedListener;
    }

    public void func_231035_a_(@Nullable IGuiEventListener focusedListener) {
        this.focusedListener = focusedListener;
    }

    public class Item
    implements IGuiEventListener {
        private final int index;
        private final ITextComponent text;
        private final Runnable actionListener;
        private boolean disabled = false;

        public Item(int index, ITextComponent text, Runnable actionListener) {
            this.index = index;
            this.text = text;
            this.actionListener = actionListener;
        }

        private void render(MatrixStack matrixStack, Type type) {
            float y = this.getY();
            int backgroundColour = DropdownView.this.itemBackgroundColour;
            int textColour = TextFormatting.GRAY.func_211163_e();
            switch (type) {
                case SELECTED: {
                    y = DropdownView.this.getScaledContentY();
                    backgroundColour ^= 0xFF000000;
                    backgroundColour -= Integer.MIN_VALUE;
                    textColour = TextFormatting.WHITE.func_211163_e();
                    break;
                }
                case HIGHLIGHTED: {
                    backgroundColour = DropdownView.this.selectedItemBackgroundColour;
                    break;
                }
                case DISABLED: {
                    textColour = TextFormatting.DARK_GRAY.func_211163_e();
                    break;
                }
                case HOVERED: {
                    backgroundColour = DropdownView.this.hoveredItemBackgroundColour;
                    break;
                }
            }
            this.render(matrixStack, DropdownView.this.getScaledContentX(), y, DropdownView.this.getScaledContentWidth(), DropdownView.this.getItemHeight(), backgroundColour, textColour);
        }

        private void render(MatrixStack matrixStack, float x, float y, float width, float height, int backgroundColour, int textColour) {
            RenderUtil.fillWidthHeight(matrixStack, x, y, width, height, backgroundColour);
            FontRenderer font = DropdownView.this.minecraft.field_71466_p;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 400.0);
            DropdownView.this.minecraft.field_71466_p.getClass();
            float textY = y + (height - 9.0f) / 2.0f + 1.0f;
            for (IReorderingProcessor line : font.func_238425_b_((ITextProperties)this.text, (int)width)) {
                font.func_238422_b_(matrixStack, line, x + 3.0f, textY, textColour);
                DropdownView.this.minecraft.field_71466_p.getClass();
                textY += 9.0f;
            }
            matrixStack.func_227865_b_();
        }

        private void click() {
            DropdownView.this.selectedItemIndex = this.index;
            this.actionListener.run();
        }

        public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257) {
                this.click();
                return true;
            }
            return false;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (!this.disabled && this.index != DropdownView.this.selectedItemIndex && this.func_231047_b_(mouseX, mouseY)) {
                this.click();
                return true;
            }
            return false;
        }

        public boolean func_231049_c__(boolean forward) {
            return !this.disabled && DropdownView.this.selectedItemIndex != this.index && DropdownView.this.focusedListener != this;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        private float getY() {
            return DropdownView.this.getScaledContentY() + DropdownView.this.getScaledContentHeight() + (float)(DropdownView.this.getItemHeight() * this.index);
        }

        public boolean func_231047_b_(double mouseX, double mouseY) {
            float y = this.getY();
            return DropdownView.this.func_231047_b_(mouseX, mouseY) && mouseY >= (double)y && mouseY <= (double)(y + (float)DropdownView.this.getItemHeight());
        }
    }

    private static enum Type {
        HIGHLIGHTED,
        SELECTED,
        DISABLED,
        HOVERED,
        NONE;

    }
}

