/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view;

import com.craftingdead.immerse.client.gui.view.View;
import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.util.FitType;
import com.craftingdead.immerse.client.util.RenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;

public class FogView<L extends Layout>
extends View<FogView<L>, L> {
    private static final ResourceLocation SMOKE_TEXTURE = new ResourceLocation("craftingdeadimmerse", "textures/gui/smoke.png");
    private static long fogStartTime = Util.func_211177_b();

    public FogView(L layout) {
        super(layout);
    }

    @Override
    public void renderContent(MatrixStack matrixStack, int mouseX, int mouseY, float paritalTicks) {
        Vector2f fogSize = FitType.COVER.getSize(1920.0f, 1080.0f, this.getScaledContentWidth(), this.getScaledContentHeight());
        float fogWidth = fogSize.field_189982_i;
        float fogHeight = fogSize.field_189983_j;
        float pct = MathHelper.func_76131_a((float)((float)(Util.func_211177_b() - fogStartTime) / 200000.0f), (float)0.0f, (float)1.0f);
        if (pct == 1.0f) {
            fogStartTime = Util.func_211177_b();
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(4.0f, 4.0f, 4.0f);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.3f * this.getAlpha()));
        RenderUtil.bind(SMOKE_TEXTURE);
        float smokeX = this.getScaledX() + pct * this.getContentWidth();
        RenderUtil.blit(matrixStack, smokeX, this.getScaledContentY(), fogWidth, fogHeight);
        RenderUtil.blit(matrixStack, smokeX - fogWidth, this.getScaledContentY(), fogWidth, fogHeight);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        matrixStack.func_227865_b_();
    }
}

