/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view;

import com.craftingdead.immerse.client.gui.tween.ColourTweenType;
import com.craftingdead.immerse.client.gui.view.Colour;
import com.craftingdead.immerse.client.gui.view.View;
import com.craftingdead.immerse.client.gui.view.event.MouseEnterEvent;
import com.craftingdead.immerse.client.gui.view.event.MouseLeaveEvent;
import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.gui.view.layout.MeasureMode;
import com.craftingdead.immerse.client.util.FitType;
import com.craftingdead.immerse.client.util.RenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.noties.tumbleweed.Tween;
import io.noties.tumbleweed.TweenType;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;

public class ImageView<L extends Layout>
extends View<ImageView<L>, L> {
    public static final TweenType<ImageView<?>> COLOUR = new ColourTweenType<ImageView>(view -> view.modifiedColour);
    private ResourceLocation image;
    private FitType fitType = FitType.FILL;
    private boolean depthTest = false;
    private boolean bilinearFiltering = false;
    private Colour colour = new Colour();
    private Colour modifiedColour = new Colour();
    private Vector2f fittedImageSize;

    public ImageView(L layout) {
        super(layout);
    }

    public final ImageView<L> addColourHoverAnimation(Colour colour, float duration) {
        return this.addListener(MouseEnterEvent.class, (view, event) -> {
            if (this.isEnabled()) {
                Tween.to(this.self(), COLOUR, (float)duration).target(colour.getColour4f()).start(this.getTweenManager());
            }
        }).addListener(MouseLeaveEvent.class, (view, event) -> {
            if (this.isEnabled()) {
                Tween.to(this.self(), COLOUR, (float)duration).target(this.colour.getColour4f()).start(this.getTweenManager());
            }
        });
    }

    public final ImageView<L> setImage(ResourceLocation image) {
        this.image = image;
        return this;
    }

    public final ImageView<L> setFitType(FitType fitType) {
        this.fitType = fitType;
        return this;
    }

    public final ImageView<L> setColour(Colour colour) {
        this.colour = this.modifiedColour = colour;
        return this;
    }

    public final ImageView<L> setDepthTest(boolean depthTest) {
        this.depthTest = depthTest;
        return this;
    }

    public final ImageView<L> setBilinearFiltering(boolean bilinearFiltering) {
        this.bilinearFiltering = bilinearFiltering;
        return this;
    }

    private Optional<Vector2f> getImageSize() {
        if (this.bind()) {
            return Optional.of(new Vector2f((float)GlStateManager.func_227692_c_((int)3553, (int)0, (int)4096), (float)GlStateManager.func_227692_c_((int)3553, (int)0, (int)4097)));
        }
        return Optional.empty();
    }

    private Optional<Vector2f> getFittedImageSize() {
        return this.getFittedImageSize(this.getContentWidth(), this.getContentHeight());
    }

    private Optional<Vector2f> getFittedImageSize(float containerWidth, float containerHeight) {
        return this.getImageSize().map(imageSize -> this.fitType.getSize(imageSize.field_189982_i, imageSize.field_189983_j, containerWidth, containerHeight));
    }

    @Override
    public void layout() {
        super.layout();
        this.fittedImageSize = this.getFittedImageSize().orElse(null);
    }

    @Override
    public Vector2f measure(MeasureMode widthMode, float width, MeasureMode heightMode, float height) {
        return this.getFittedImageSize(widthMode == MeasureMode.UNDEFINED ? 2.1474836E9f : width, heightMode == MeasureMode.UNDEFINED ? 2.1474836E9f : height).orElse(new Vector2f(width, height));
    }

    private boolean bind() {
        if (this.image != null) {
            RenderUtil.bind(this.image);
            return true;
        }
        return false;
    }

    @Override
    public void renderContent(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.renderContent(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (this.depthTest) {
            RenderSystem.enableDepthTest();
        }
        float[] colour = this.modifiedColour.getColour4f();
        RenderSystem.color4f((float)colour[0], (float)colour[1], (float)colour[2], (float)colour[3]);
        if (this.bind()) {
            if (this.bilinearFiltering) {
                this.minecraft.func_110434_K().func_229267_b_(this.image).func_174937_a(true, true);
            }
            RenderUtil.blit(matrixStack, this.getScaledContentX(), this.getScaledContentY(), this.fittedImageSize.field_189982_i * this.getXScale(), this.fittedImageSize.field_189983_j * this.getYScale());
        } else {
            RenderUtil.fill(matrixStack, this.getScaledContentX(), this.getScaledContentY(), this.getScaledX() + this.getScaledContentWidth(), this.getScaledContentY() + this.getScaledContentHeight(), -1L);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.depthTest) {
            RenderSystem.disableDepthTest();
        }
        RenderSystem.disableBlend();
    }
}

