/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view;

import com.craftingdead.immerse.client.gui.view.View;
import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.util.RenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.renderer.RenderSkybox;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.util.ResourceLocation;

public class PanoramaView<L extends Layout>
extends View<PanoramaView<L>, L> {
    private static final ResourceLocation PANORAMA_OVERLAY_TEXTURES = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private final RenderSkybox panorama;
    private final ResourceLocation panoramaTexture;

    public PanoramaView(L layout, ResourceLocation panoramaTexture) {
        super(layout);
        Objects.requireNonNull(panoramaTexture, "Panorama texture cannot be null");
        this.panoramaTexture = panoramaTexture;
        this.panorama = new RenderSkybox(new RenderSkyboxCube(this.panoramaTexture));
    }

    @Override
    public void renderContent(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.renderContent(matrixStack, mouseX, mouseY, partialTicks);
        this.panorama.func_217623_a(partialTicks, 1.0f);
        RenderUtil.bind(PANORAMA_OVERLAY_TEXTURES);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderUtil.blit(matrixStack, this.getScaledContentX(), this.getScaledContentY(), this.getScaledContentWidth(), this.getScaledContentHeight());
        RenderSystem.disableBlend();
    }
}

