/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view;

import com.craftingdead.immerse.client.gui.view.View;
import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.gui.view.layout.LayoutParent;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ParentView<SELF extends ParentView<SELF, L, C>, L extends Layout, C extends Layout>
extends View<SELF, L>
implements INestedGuiEventHandler {
    private final List<View<?, C>> children = new ArrayList();
    private View<?, C>[] sortedChildren = new View[0];
    private final Deque<Pair<View<?, C>, Runnable>> pendingRemoval = new ArrayDeque();
    private final LayoutParent<C> layoutParent;
    @Nullable
    private IGuiEventListener focusedListener;
    private boolean dragging;

    public ParentView(L layout, LayoutParent<C> layoutParent) {
        super(layout);
        this.layoutParent = layoutParent;
    }

    public final List<? extends View<?, C>> getChildViews() {
        return this.children;
    }

    public final LayoutParent<C> getLayoutParent() {
        return this.layoutParent;
    }

    public final SELF addChild(View<?, C> view) {
        if (!this.minecraft.func_213162_bc()) {
            return (SELF)((ParentView)this.minecraft.func_213169_a(() -> this.addChild(view)).join());
        }
        if (view.parent != null) {
            return (SELF)((ParentView)this.self());
        }
        this.updatePendingRemoval();
        view.index = this.children.size();
        this.children.add(view);
        this.sortedChildren = this.children.toArray(new View[0]);
        this.sortChildren();
        this.layoutParent.addChild(view.getLayout(), view.index);
        view.parent = this;
        view.layout();
        view.added();
        return (SELF)((ParentView)this.self());
    }

    public final SELF removeChild(View<?, C> view) {
        if (!this.minecraft.func_213162_bc()) {
            return (SELF)((ParentView)this.minecraft.func_213169_a(() -> this.removeChild(view)).join());
        }
        this.assertChildPresent(view);
        this.prepareForRemoval(view);
        this.children.remove(view);
        this.indexAndSortChildren();
        return (SELF)((ParentView)this.self());
    }

    public final SELF clearChildren() {
        if (!this.minecraft.func_213162_bc()) {
            return (SELF)((ParentView)this.minecraft.func_213169_a(this::clearChildren).join());
        }
        this.children.forEach(this::prepareForRemoval);
        this.children.clear();
        this.sortedChildren = new View[0];
        return (SELF)((ParentView)this.self());
    }

    public final SELF queueChildForRemoval(View<?, C> view) {
        return this.queueChildForRemoval(view, null);
    }

    public final SELF queueChildForRemoval(View<?, C> view, Runnable callback) {
        if (!this.minecraft.func_213162_bc()) {
            return (SELF)((ParentView)this.minecraft.func_213169_a(() -> this.queueChildForRemoval(view, callback)).join());
        }
        this.assertChildPresent(view);
        view.queueRemoval(() -> {
            view.pendingRemoval = true;
            this.pendingRemoval.add(Pair.of((Object)view, (Object)callback));
        });
        return (SELF)((ParentView)this.self());
    }

    public final SELF queueAllForRemoval() {
        if (!this.minecraft.func_213162_bc()) {
            return (SELF)((ParentView)this.minecraft.func_213169_a(this::queueAllForRemoval).join());
        }
        this.children.forEach(this::queueChildForRemoval);
        return (SELF)((ParentView)this.self());
    }

    private void prepareForRemoval(View<?, C> view) {
        view.removed();
        view.parent = null;
        this.layoutParent.removeChild(view.getLayout());
        view.pendingRemoval = false;
    }

    private final void assertChildPresent(View<?, C> view) {
        if (this.children.size() <= view.index || this.children.get(view.index) != view) {
            throw new IllegalArgumentException("View not added");
        }
    }

    private void indexAndSortChildren() {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get((int)i).index = i;
        }
        this.sortedChildren = this.children.toArray(new View[0]);
        this.sortChildren();
    }

    private void updatePendingRemoval() {
        if (!this.pendingRemoval.isEmpty()) {
            this.pendingRemoval.forEach(pair -> {
                View view = (View)pair.getLeft();
                this.prepareForRemoval(view);
                this.children.remove(view);
                Runnable callback = (Runnable)pair.getRight();
                if (callback != null) {
                    callback.run();
                }
            });
            this.pendingRemoval.clear();
            this.indexAndSortChildren();
        }
    }

    @Override
    public float computeFullHeight() {
        float height = (float)(this.children.stream().mapToDouble(c -> c.getY() + c.getHeight()).max().orElse(0.0) - (double)super.getScaledContentY());
        return Math.max(height, 0.0f);
    }

    @Override
    public void layout() {
        if (!this.minecraft.func_213162_bc()) {
            this.minecraft.func_222817_e(this::layout).join();
            return;
        }
        this.layoutParent.layout(this.getContentWidth(), this.getContentHeight());
        this.children.forEach(View::layout);
        super.layout();
    }

    @Override
    public void tick() {
        this.updatePendingRemoval();
        super.tick();
        this.children.forEach(View::tick);
    }

    @Override
    public void renderContent(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.renderContent(matrixStack, mouseX, mouseY, partialTicks);
        for (View<?, C> view : this.sortedChildren) {
            if (view.pendingRemoval) continue;
            view.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void close() {
        this.children.forEach(View::close);
        this.layoutParent.close();
        super.close();
    }

    public void sortChildren() {
        Arrays.sort(this.sortedChildren);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return Lists.reverse(Arrays.asList(this.sortedChildren));
    }

    @Override
    public void func_212927_b(double mouseX, double mouseY) {
        this.func_231039_at__().forEach(listener -> listener.func_212927_b(mouseX, mouseY));
        super.func_212927_b(mouseX, mouseY);
    }

    @Override
    public boolean func_231047_b_(double mouseX, double mouseY) {
        for (IGuiEventListener eventListener : this.func_231039_at__()) {
            if (!eventListener.func_231047_b_(mouseX, mouseY)) continue;
            return true;
        }
        return super.func_231047_b_(mouseX, mouseY);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return super.func_231044_a_(mouseX, mouseY, button) || super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY) || super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double scrollDelta) {
        return super.func_231043_a_(mouseX, mouseY, scrollDelta) || super.func_231043_a_(mouseX, mouseY, scrollDelta);
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return super.func_231046_a_(keyCode, scanCode, modifiers) || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return super.func_223281_a_(keyCode, scanCode, modifiers) || super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean func_231042_a_(char codePoint, int modifiers) {
        return super.func_231042_a_(codePoint, modifiers) || super.func_231042_a_(codePoint, modifiers);
    }

    public boolean func_231041_ay__() {
        return this.dragging;
    }

    public void func_231037_b__(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public IGuiEventListener func_241217_q_() {
        return this.focusedListener;
    }

    @Override
    public boolean func_231049_c__(boolean focus) {
        return super.func_231049_c__(focus) || super.func_231049_c__(focus);
    }

    public void func_231035_a_(@Nullable IGuiEventListener focusedListener) {
        this.focusedListener = focusedListener;
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.func_231037_b__(false);
        return this.func_241217_q_() != null && this.func_241217_q_().func_231048_c_(mouseX, mouseY, button);
    }
}

