/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view;

import com.craftingdead.immerse.client.gui.view.Colour;
import com.craftingdead.immerse.client.gui.view.ParentView;
import com.craftingdead.immerse.client.gui.view.TextView;
import com.craftingdead.immerse.client.gui.view.event.ActionEvent;
import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.gui.view.layout.yoga.FlexDirection;
import com.craftingdead.immerse.client.gui.view.layout.yoga.FlexWrap;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayout;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayoutParent;
import com.craftingdead.immerse.client.util.RenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TabsView<L extends Layout>
extends ParentView<TabsView<L>, L, YogaLayout> {
    private final List<Tab> tabList = new ArrayList<Tab>();
    private Tab selectedTab = null;
    private float tabWidth = 60.0f;
    private float tabHeight = 20.0f;
    private boolean init = false;

    public TabsView(L layout) {
        super(layout, new YogaLayoutParent().setFlexDirection(FlexDirection.ROW).setFlexWrap(FlexWrap.WRAP));
    }

    public TabsView<L> addTab(Tab tab) {
        this.tabList.add(tab);
        return this;
    }

    @Override
    public void layout() {
        this.init();
        super.layout();
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        Tab newSelectedTab = null;
        for (Tab tab : this.tabList) {
            ((YogaLayout)tab.getLayout()).setWidth(this.tabWidth);
            this.minecraft.field_71466_p.getClass();
            float y = (this.tabHeight - 9.0f) / 2.0f;
            ((YogaLayout)tab.getLayout()).setTopPadding(y);
            ((YogaLayout)tab.getLayout()).setBottomPadding(y);
            this.addChild(tab);
            if (tab.isSelected() && this.selectedTab == null) {
                newSelectedTab = tab;
            } else if (tab.isSelected()) {
                tab.setSelected(false);
            }
            tab.layout();
            tab.addListener(ActionEvent.class, (c, e) -> this.changeTab((Tab)c));
        }
        if (newSelectedTab != null) {
            this.changeTab(newSelectedTab);
        } else if (this.tabList.size() > 0) {
            this.changeTab(this.tabList.get(0));
        }
    }

    private void changeTab(Tab newTab) {
        Tab previousTab = this.selectedTab;
        this.selectedTab = newTab;
        if (previousTab != newTab) {
            if (previousTab != null) {
                previousTab.setSelected(false);
            }
            newTab.setSelected(true);
        }
    }

    public static class Tab
    extends TextView<YogaLayout> {
        public static final Colour DEFAULT_UNDERSCORE_COLOR = Colour.WHITE;
        public static final double DEFAULT_UNDERSCORE_HEIGHT = 2.5;
        public static final int DEFAULT_UNDERSCORE_OFFSET = 1;
        public static final boolean DEFAULT_DISABLED = false;
        public static final boolean DEFAULT_SHADOW = false;
        public static final boolean DEFAULT_CENTERED = true;
        private boolean selected = false;
        private Colour underscoreColor = DEFAULT_UNDERSCORE_COLOR;
        private double underscoreHeight = 2.5;
        private boolean disabled = false;
        private float underscoreYOffset = 1.0f;
        private Runnable selectedListener;

        public Tab(ITextComponent text, Runnable selectedListener) {
            super(new YogaLayout(), text);
            this.setShadow(false);
            this.setCentered(true);
            this.selectedListener = selectedListener;
        }

        public Tab(String text, Runnable selectedListener) {
            this((ITextComponent)new StringTextComponent(text), selectedListener);
        }

        @Override
        public void renderContent(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.renderContent(matrixStack, mouseX, mouseY, partialTicks);
            if (this.selected) {
                RenderUtil.fill(matrixStack, this.getScaledX(), (double)(this.getScaledY() + this.getScaledHeight()) - this.underscoreHeight + (double)this.underscoreYOffset, this.getScaledX() + this.getScaledWidth(), this.getScaledY() + this.getScaledHeight() + this.underscoreYOffset, this.underscoreColor.getHexColour());
            } else if (this.isHovered()) {
                RenderUtil.fill(matrixStack, this.getScaledX(), (double)(this.getScaledY() + this.getScaledHeight()) - this.underscoreHeight / 1.5 + (double)this.underscoreYOffset, this.getScaledX() + this.getScaledWidth(), this.getScaledY() + this.getScaledHeight() + this.underscoreYOffset, this.underscoreColor.getHexColour());
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        public Tab setSelected(boolean selected) {
            if (selected) {
                this.selectedListener.run();
            }
            this.selected = selected;
            return this;
        }

        public Colour getUnderscoreColor() {
            return this.underscoreColor;
        }

        public Tab setUnderscoreColor(Colour underscoreColor) {
            this.underscoreColor = underscoreColor;
            return this;
        }

        public double getUnderscoreHeight() {
            return this.underscoreHeight;
        }

        public Tab setUnderscoreHeight(double underscoreHeight) {
            this.underscoreHeight = underscoreHeight;
            return this;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public Tab setDisabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public float getUnderscoreYOffset() {
            return this.underscoreYOffset;
        }

        public Tab setUnderscoreYOffset(float underscoreYOffset) {
            this.underscoreYOffset = underscoreYOffset;
            return this;
        }
    }
}

