/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view;

import com.craftingdead.immerse.client.gui.view.View;
import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.gui.view.layout.MeasureMode;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class TextView<L extends Layout>
extends View<TextView<L>, L> {
    private ITextComponent text;
    private FontRenderer font;
    private boolean shadow;
    private boolean centered;
    private List<IReorderingProcessor> lines = new ArrayList<IReorderingProcessor>();

    public TextView(L layout, ITextComponent text) {
        super(layout);
        this.text = text;
        this.font = this.minecraft.field_71466_p;
        this.shadow = true;
        this.centered = false;
    }

    public TextView(L layout, String text) {
        this(layout, (ITextComponent)new StringTextComponent(text));
    }

    public TextView<L> setFontRenderer(FontRenderer fontRenderer) {
        this.font = fontRenderer;
        return this;
    }

    public TextView<L> setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public TextView<L> setCentered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public TextView<L> setText(ITextComponent text) {
        this.text = text;
        this.generateLines(this.getContentWidth());
        return this;
    }

    @Override
    public void layout() {
        this.generateLines(this.getContentWidth());
        super.layout();
    }

    @Override
    protected Vector2f measure(MeasureMode widthMode, float width, MeasureMode heightMode, float height) {
        if (widthMode == MeasureMode.UNDEFINED) {
            width = this.font.func_78256_a(this.text.getString());
        }
        this.generateLines(width);
        int n = this.lines.size();
        this.font.getClass();
        return new Vector2f(width, (float)(n * 9));
    }

    private void generateLines(float width) {
        this.lines = this.font.func_238425_b_((ITextProperties)this.text, MathHelper.func_76123_f((float)width));
    }

    @Override
    public float computeFullHeight() {
        int n = this.lines.size();
        this.font.getClass();
        return n * 9;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (super.func_231044_a_(mouseX, mouseY, button)) return true;
        if (this.componentStyleAtWidth(mouseX, mouseY).map(arg_0 -> ((Screen)this.minecraft.field_71462_r).func_230455_a_(arg_0)).orElse(false) == false) return false;
        return true;
    }

    @Override
    public void renderContent(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        float f;
        super.renderContent(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.func_227860_a_();
        double d = this.getScaledContentX();
        float f2 = this.getScaledContentY();
        if (this.centered) {
            float f3 = this.getContentHeight();
            this.font.getClass();
            f = (f3 - (float)(9 * this.lines.size())) / 2.0f;
        } else {
            f = 0.0f;
        }
        matrixStack.func_227861_a_(d, (double)(f2 + f), 400.0);
        matrixStack.func_227862_a_(this.getXScale(), this.getYScale(), 1.0f);
        IRenderTypeBuffer.Impl renderTypeBuffer = this.minecraft.func_228019_au_().func_228487_b_();
        for (int i = 0; i < this.lines.size(); ++i) {
            IReorderingProcessor line = this.lines.get(i);
            matrixStack.func_227860_a_();
            this.font.getClass();
            matrixStack.func_227861_a_(0.0, (double)(i * 9), 0.0);
            float x = this.centered ? (this.getContentWidth() - (float)this.font.func_243245_a(line)) / 2.0f : 0.0f;
            this.font.func_238416_a_(line, x, 0.0f, 0xFFFFFF + ((int)(this.getAlpha() * 255.0f) << 24), this.shadow, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
            matrixStack.func_227865_b_();
        }
        renderTypeBuffer.func_228461_a_();
        matrixStack.func_227865_b_();
    }

    public Optional<Style> componentStyleAtWidth(double mouseX, double mouseY) {
        int offsetMouseX = MathHelper.func_76128_c((double)((mouseX - (double)this.getContentX()) / (double)this.getXScale()));
        int offsetMouseY = MathHelper.func_76128_c((double)((mouseY - (double)this.getContentY()) / (double)this.getYScale()));
        int lines = this.lines.size();
        if (offsetMouseX >= 0 && offsetMouseY >= 0 && (float)offsetMouseX <= this.getContentWidth()) {
            this.font.getClass();
            if (offsetMouseY < 9 * lines + lines) {
                this.font.getClass();
                int maxLines = offsetMouseY / 9;
                if (maxLines >= 0 && maxLines < this.lines.size()) {
                    IReorderingProcessor line = this.lines.get(maxLines);
                    return Optional.ofNullable(this.font.func_238420_b_().func_243239_a(line, offsetMouseX));
                }
            }
        }
        return Optional.empty();
    }
}

