/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view;

import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.client.ClientDist;
import com.craftingdead.immerse.client.gui.view.Blur;
import com.craftingdead.immerse.client.gui.view.Colour;
import com.craftingdead.immerse.client.gui.view.Overflow;
import com.craftingdead.immerse.client.gui.view.ParentView;
import com.craftingdead.immerse.client.gui.view.Tooltip;
import com.craftingdead.immerse.client.gui.view.ViewScreen;
import com.craftingdead.immerse.client.gui.view.event.ActionEvent;
import com.craftingdead.immerse.client.gui.view.event.CharTypeEvent;
import com.craftingdead.immerse.client.gui.view.event.EnabledChangedEvent;
import com.craftingdead.immerse.client.gui.view.event.FocusChangedEvent;
import com.craftingdead.immerse.client.gui.view.event.KeyEvent;
import com.craftingdead.immerse.client.gui.view.event.MouseEnterEvent;
import com.craftingdead.immerse.client.gui.view.event.MouseEvent;
import com.craftingdead.immerse.client.gui.view.event.MouseLeaveEvent;
import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.gui.view.layout.MeasureMode;
import com.craftingdead.immerse.client.util.RenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.noties.tumbleweed.Timeline;
import io.noties.tumbleweed.Tween;
import io.noties.tumbleweed.TweenEquation;
import io.noties.tumbleweed.TweenManager;
import io.noties.tumbleweed.TweenType;
import io.noties.tumbleweed.equations.Sine;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import org.lwjgl.opengl.GL11;

public class View<SELF extends View<SELF, L>, L extends Layout>
extends AbstractGui
implements IGuiEventListener,
IRenderable,
Comparable<View<?, ?>> {
    public static final TweenType<View<?, ?>> X_SCALE;
    public static final TweenType<View<?, ?>> Y_SCALE;
    public static final TweenType<View<?, ?>> X_TRANSLATION;
    public static final TweenType<View<?, ?>> Y_TRANSLATION;
    public static final TweenType<View<?, ?>> BACKGROUND_COLOUR;
    public static final TweenType<View<?, ?>> BORDER_WIDTH;
    public static final TweenType<View<?, ?>> ALPHA;
    private static final TweenType<View<?, ?>> SCROLL_OFFSET;
    private static final int SCROLLBAR_WIDTH = 4;
    private static final float SCROLL_CHUNK = 50.0f;
    private static final float SCROLL_MOMENTUM_DAMPING = 3.0f;
    private static final int DOUBLE_CLICK_DURATION_MS = 500;
    protected final Minecraft minecraft = Minecraft.func_71410_x();
    protected final MainWindow mainWindow = this.minecraft.func_228018_at_();
    protected final ClientDist clientDist = (ClientDist)CraftingDeadImmerse.getInstance().getModDist();
    private final IEventBus eventBus = BusBuilder.builder().build();
    private final TweenManager tweenManager = TweenManager.create();
    protected final L layout;
    @Nullable
    ViewScreen screen;
    @Nullable
    ParentView<?, ?, ? extends L> parent;
    int index;
    private float lastScrollOffset;
    private float scrollOffset;
    private float scrollVelocity;
    private float fullHeight;
    private float xScale = 1.0f;
    private float yScale = 1.0f;
    private float xOffset = 0.0f;
    private float yOffset = 0.0f;
    private float zOffset = 0.0f;
    private Overflow overflow = Overflow.VISIBLE;
    private float alpha = 1.0f;
    private float topBorderWidth = 0.0f;
    private Colour topBorderColour = Colour.WHITE;
    private float rightBorderWidth = 0.0f;
    private Colour rightBorderColour = Colour.WHITE;
    private float bottomBorderWidth = 0.0f;
    private Colour bottomBorderColour = Colour.WHITE;
    private float leftBorderWidth = 0.0f;
    private Colour leftBorderColour = Colour.WHITE;
    @Nullable
    private Tooltip tooltip;
    @Nullable
    private Colour modifiedBackgroundColour;
    @Nullable
    private Colour backgroundColour;
    @Nullable
    private Blur backgroundBlur;
    protected boolean pendingRemoval;
    private boolean hovered;
    protected boolean focused;
    protected boolean focusable;
    private boolean unscaleWidth;
    private boolean unscaleHeight;
    private boolean doubleClick;
    private long lastClickTimeMs;
    private boolean enabled = true;

    public View(L layout) {
        this.layout = layout;
        this.layout.setMeasureFunction(this::measure);
        this.eventBus.start();
    }

    protected Vector2f measure(MeasureMode widthMode, float width, MeasureMode heightMode, float height) {
        return new Vector2f(width, height);
    }

    protected float computeFullHeight() {
        return this.getContentHeight();
    }

    protected void added() {
    }

    protected void removed() {
    }

    protected void queueRemoval(Runnable remove) {
        remove.run();
    }

    protected void layout() {
        this.fullHeight = this.computeFullHeight();
        this.scrollOffset = this.clampScrollOffset(this.scrollOffset);
        this.layout.layout();
    }

    public void tick() {
        this.lastScrollOffset = this.scrollOffset;
        this.scrollVelocity *= 0.33333334f;
        if (Math.abs(this.scrollVelocity) < 0.08f) {
            this.scrollVelocity = 0.0f;
        }
        this.scrollOffset += this.scrollVelocity;
        if (this.scrollOffset < 0.0f || this.scrollOffset > this.fullHeight - this.getHeight()) {
            this.scrollVelocity = 0.0f;
        }
        this.scrollOffset = this.clampScrollOffset(this.scrollOffset);
        if (this.backgroundBlur != null) {
            this.backgroundBlur.tick();
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        boolean scissor;
        this.tweenManager.update(partialTicks * 100.0f);
        if (this.backgroundBlur != null) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
            this.backgroundBlur.render(matrixStack, this.getScaledX(), this.getScaledY(), this.getScaledWidth(), this.getScaledHeight(), partialTicks);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        if (this.modifiedBackgroundColour != null) {
            RenderSystem.enableBlend();
            float[] colour = this.modifiedBackgroundColour.getColour4f();
            colour[3] = colour[3] * this.getAlpha();
            RenderUtil.fill(matrixStack.func_227866_c_().func_227870_a_(), this.getScaledX(), this.getScaledY(), this.getZOffset(), this.getScaledX() + this.getScaledWidth(), this.getScaledY() + this.getScaledHeight(), colour[0], colour[1], colour[2], colour[3]);
            RenderSystem.disableBlend();
        }
        if (this.topBorderWidth > 0.0f) {
            RenderUtil.fill(matrixStack, this.getScaledX(), this.getScaledY(), this.getScaledX() + this.getScaledWidth(), this.getScaledY() + this.topBorderWidth, this.topBorderColour.getHexColour());
        }
        if (this.rightBorderWidth > 0.0f) {
            RenderUtil.fill(matrixStack, this.getScaledX() + this.getScaledWidth() - this.rightBorderWidth, this.getScaledY(), this.getScaledX() + this.getScaledWidth(), this.getScaledY() + this.getScaledHeight(), this.rightBorderColour.getHexColour());
        }
        if (this.bottomBorderWidth > 0.0f) {
            RenderUtil.fill(matrixStack, this.getScaledX(), this.getScaledY() + this.getScaledHeight() - this.bottomBorderWidth, this.getScaledX() + this.getScaledWidth(), this.getScaledY() + this.getScaledHeight(), this.bottomBorderColour.getHexColour());
        }
        if (this.leftBorderWidth > 0.0f) {
            RenderUtil.fill(matrixStack, this.getScaledX(), this.getScaledY(), this.getScaledX() + this.leftBorderWidth, this.getScaledY() + this.getScaledHeight(), this.leftBorderColour.getHexColour());
        }
        if (this.tooltip != null && this.isHovered()) {
            this.tooltip.render(this.minecraft.field_71466_p, matrixStack, 10.0 + (double)this.getX() + (double)this.getWidth(), this.getY());
        }
        boolean bl = scissor = this.getOverflow() == Overflow.HIDDEN || this.getOverflow() == Overflow.SCROLL;
        if (scissor) {
            if (!this.minecraft.func_147110_a().isStencilEnabled()) {
                this.minecraft.func_147110_a().enableStencil();
            }
            GL11.glEnable((int)2960);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.stencilFunc((int)512, (int)1, (int)255);
            RenderSystem.stencilOp((int)7681, (int)7680, (int)7680);
            RenderSystem.stencilMask((int)255);
            RenderSystem.clear((int)1024, (boolean)false);
            RenderUtil.fillWidthHeight(matrixStack, this.getScaledX(), this.getScaledY(), this.getScaledWidth(), this.getScaledHeight(), 0);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.stencilMask((int)0);
            RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        }
        this.renderContent(matrixStack, mouseX, mouseY, partialTicks);
        if (scissor) {
            GL11.glDisable((int)2960);
        }
        if (this.isScrollbarEnabled()) {
            RenderUtil.roundedFill(matrixStack, this.getScrollbarX(), this.getScaledY(), this.getScrollbarX() + 4.0, this.getScaledY() + this.getScaledHeight(), 0x40000000, 2.0f);
            RenderUtil.roundedFill(matrixStack, this.getScrollbarX(), this.getScrollbarY(), this.getScrollbarX() + 4.0, this.getScrollbarY() + (double)this.getScrollbarHeight(), 0x4CFFFFFF, 2.0f);
        }
    }

    protected final boolean isScrollbarEnabled() {
        return this.getOverflow() == Overflow.SCROLL && this.fullHeight > this.getHeight();
    }

    protected void renderContent(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    private final double getScrollbarX() {
        return this.getScaledX() + this.getScaledWidth() - 4.0f;
    }

    private final double getScrollbarY() {
        return this.getScaledY() + this.getScrollOffset(this.minecraft.func_184121_ak()) / this.fullHeight * this.getScaledHeight();
    }

    private final float getScrollOffset(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastScrollOffset, (float)this.scrollOffset);
    }

    private final float getScrollbarHeight() {
        return MathHelper.func_76131_a((float)(this.getScaledHeight() * (this.getContentHeight() / this.fullHeight)), (float)10.0f, (float)this.getScaledHeight());
    }

    private final void scrollTo(float y, float duration) {
        Tween.to((Object)this, SCROLL_OFFSET, (float)duration).target(new float[]{this.clampScrollOffset(y)}).ease((TweenEquation)Sine.OUT).start(this.getTweenManager());
    }

    private final float clampScrollOffset(float scrollOffset) {
        return MathHelper.func_76131_a((float)scrollOffset, (float)0.0f, (float)(this.fullHeight - this.getContentHeight()));
    }

    public void mouseEntered(double mouseX, double mouseY) {
        this.hovered = true;
        if (this.tooltip != null) {
            Timeline.createParallel((float)150.0f).push(Tween.to((Object)this.tooltip, Tooltip.ALPHA).ease((TweenEquation)Sine.INOUT).target(new float[]{1.0f})).push(Tween.to((Object)this.tooltip, Tooltip.TEXT_ALPHA).delay(100.0f).target(new float[]{1.0f})).start(this.getTweenManager());
        }
        this.post(new MouseEnterEvent());
    }

    public void mouseLeft(double mouseX, double mouseY) {
        this.hovered = false;
        if (this.tooltip != null) {
            Timeline.createParallel((float)250.0f).push(Tween.to((Object)this.tooltip, Tooltip.ALPHA).target(new float[]{0.0f})).push(Tween.to((Object)this.tooltip, Tooltip.TEXT_ALPHA).target(new float[]{0.0f})).start(this.getTweenManager());
        }
        this.post(new MouseLeaveEvent());
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.post(new MouseEvent.MoveEvent(mouseX, mouseY));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (!this.isHovered()) {
            return false;
        }
        if (this.isScrollbarEnabled() && mouseX >= (double)(this.getScaledX() + this.getScaledWidth() - 4.0f) && mouseX <= (double)(this.getScaledX() + this.getScaledWidth()) && mouseY >= (double)this.getScaledY() && mouseY <= (double)(this.getScaledY() + this.getScaledHeight())) {
            if (!(mouseX >= this.getScrollbarX() && mouseX <= this.getScrollbarX() + 4.0 && mouseY >= this.getScrollbarY() && mouseY <= this.getScrollbarY() + (double)this.getScrollbarHeight())) {
                this.scrollTo(this.scrollOffset + (mouseY > this.getScrollbarY() ? this.getScaledHeight() : -this.getScaledHeight()), 200.0f);
            }
            return true;
        }
        if (this.post(new MouseEvent.ButtonEvent(mouseX, mouseY, button, 1)) == Event.Result.ALLOW) {
            return true;
        }
        long currentTime = Util.func_211177_b();
        long deltaTime = currentTime - this.lastClickTimeMs;
        this.lastClickTimeMs = currentTime;
        return this.enabled && (!this.doubleClick || deltaTime < 500L) && this.post(new ActionEvent()) == Event.Result.ALLOW;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        return this.post(new MouseEvent.ButtonEvent(mouseX, mouseY, button, 0)) == Event.Result.ALLOW;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseY >= (double)this.getScaledY() && mouseY <= (double)(this.getScaledY() + this.getScaledHeight())) {
            this.scrollOffset = this.clampScrollOffset(this.scrollOffset + (float)deltaY * this.fullHeight / this.getScaledHeight());
            return true;
        }
        return this.post(new MouseEvent.DragEvent(mouseX, mouseY, button, deltaX, deltaY)) == Event.Result.ALLOW;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollDelta) {
        if (this.isScrollbarEnabled()) {
            this.scrollVelocity += (float)(-scrollDelta * 50.0);
        }
        return this.post(new MouseEvent.ScrollEvent(mouseX, mouseY, scrollDelta)) == Event.Result.ALLOW;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.post(new KeyEvent(keyCode, scanCode, 1, modifiers)) == Event.Result.ALLOW) {
            return true;
        }
        return keyCode == 257 && this.post(new ActionEvent()) == Event.Result.ALLOW;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return this.post(new KeyEvent(keyCode, scanCode, 0, modifiers)) == Event.Result.ALLOW;
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        return this.post(new CharTypeEvent(codePoint, modifiers)) == Event.Result.ALLOW;
    }

    public boolean func_231049_c__(boolean forward) {
        if (this.focusable) {
            this.focused = !this.focused;
            this.focusChanged();
            return this.focused;
        }
        return false;
    }

    protected void focusChanged() {
        if (this.focused) {
            this.setBorderWidth(0.7f);
        } else {
            this.setBorderWidth(0.0f);
        }
        this.post(new FocusChangedEvent());
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return mouseX > (double)this.getScaledX() && mouseX < (double)(this.getScaledX() + this.getScaledWidth()) && mouseY > (double)this.getScaledY() && mouseY < (double)(this.getScaledY() + this.getScaledHeight());
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public final TweenManager getTweenManager() {
        return this.tweenManager;
    }

    public void close() {
        if (this.backgroundBlur != null) {
            this.backgroundBlur.close();
        }
        this.layout.close();
    }

    public final SELF addHoverAnimation(TweenType<View<?, ?>> tweenType, float[] target, float duration) {
        float[] original = new float[tweenType.getValuesSize()];
        tweenType.getValues((Object)this, original);
        return (SELF)this.addHoverAnimation(tweenType, target, __ -> original, duration);
    }

    public final SELF addBackgroundHoverAnimation(Colour colour, float duration) {
        return (SELF)this.addHoverAnimation(BACKGROUND_COLOUR, colour.getColour4f(), view -> view.getBackgroundColour().map(Colour::getColour4f).get(), duration);
    }

    public final SELF addHoverAnimation(TweenType<View<?, ?>> tweenType, float[] target, Function<SELF, float[]> original, float duration) {
        return (SELF)this.addListener(MouseEnterEvent.class, (view, event) -> {
            if (this.enabled) {
                Tween.to(this.self(), (TweenType)tweenType, (float)duration).target(target).start(this.tweenManager);
            }
        }).addListener(MouseLeaveEvent.class, (view, event) -> {
            if (this.enabled) {
                Tween.to(this.self(), (TweenType)tweenType, (float)duration).target((float[])original.apply(this.self())).start(this.tweenManager);
            }
        });
    }

    public final SELF setDisabledBackgroundColour(Colour colour, float duration) {
        return (SELF)this.addListener(EnabledChangedEvent.class, (view, event) -> {
            if (!this.enabled) {
                if (this.parent == null) {
                    this.modifiedBackgroundColour.setColour4f(colour.getColour4f());
                } else {
                    Tween.to(this.self(), BACKGROUND_COLOUR, (float)duration).target(colour.getColour4f()).start(this.tweenManager);
                }
            } else if (this.parent == null) {
                this.modifiedBackgroundColour.setColour4f(this.backgroundColour.getColour4f());
            } else {
                Tween.to(this.self(), BACKGROUND_COLOUR, (float)duration).target(this.backgroundColour.getColour4f()).start(this.tweenManager);
            }
        });
    }

    public final SELF addActionSound(SoundEvent soundEvent) {
        return (SELF)this.addListener(ActionEvent.class, (component, event) -> this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)soundEvent, (float)1.0f)));
    }

    public final <T extends Event> SELF addListener(Class<T> eventType, BiConsumer<SELF, T> consumer) {
        return this.addListener(eventType, consumer, true);
    }

    public final <T extends Event> SELF addListener(Class<T> eventType, BiConsumer<SELF, T> consumer, boolean consumeEvent) {
        this.eventBus.addListener(EventPriority.NORMAL, true, eventType, event -> {
            if (event.hasResult() && consumeEvent) {
                event.setResult(Event.Result.ALLOW);
            }
            consumer.accept(this.self(), event);
        });
        return this.self();
    }

    public final Event.Result post(Event event) {
        this.eventBus.post(event);
        return event.getResult();
    }

    public final float getScaledContentX() {
        return this.getContentX() + (this.getContentWidth() - this.getContentWidth() * this.xScale) / 2.0f;
    }

    public float getContentX() {
        return this.getX() + this.layout.getLeftPadding() * this.getXScale();
    }

    public final float getScaledX() {
        return this.getX() + (this.getWidth() - this.getWidth() * this.xScale) / 2.0f;
    }

    public final float getX() {
        float left = this.layout.getLeft();
        return left + left * this.getXScale() - left * this.xScale + this.xOffset + (this.parent == null ? 0.0f : this.parent.getScaledContentX()) + (this.unscaleWidth ? this.getWidth() * (float)this.mainWindow.func_198100_s() - this.getWidth() : 0.0f);
    }

    public final float getScaledContentY() {
        return this.getContentY() + (this.getContentHeight() - this.getContentHeight() * this.yScale) / 2.0f;
    }

    public float getContentY() {
        return this.getY() + this.layout.getTopPadding() * this.getYScale() - (this.fullHeight > this.getHeight() ? this.getScrollOffset(this.minecraft.func_184121_ak()) * this.getYScale() : 0.0f);
    }

    public final float getScaledY() {
        return this.getY() + (this.getHeight() - this.getHeight() * this.yScale) / 2.0f;
    }

    public final float getY() {
        float top = this.layout.getTop();
        return top + top * this.getYScale() - top * this.yScale + this.yOffset + (this.parent == null ? 0.0f : this.parent.getScaledContentY()) + (this.unscaleHeight ? this.getHeight() * (float)this.mainWindow.func_198100_s() - this.getHeight() : 0.0f);
    }

    public final float getScaledContentWidth() {
        return this.getContentWidth() * this.getXScale();
    }

    public float getContentWidth() {
        return this.getWidth() - this.layout.getRightPadding() - (this.isScrollbarEnabled() ? 4.0f : 0.0f);
    }

    public final float getScaledWidth() {
        return this.getWidth() * this.getXScale();
    }

    public final float getWidth() {
        return (float)((double)this.layout.getWidth() / (this.unscaleWidth ? this.mainWindow.func_198100_s() : 1.0));
    }

    public final float getScaledContentHeight() {
        return this.getContentHeight() * this.getYScale();
    }

    public final float getContentHeight() {
        return this.getHeight() - this.layout.getBottomPadding();
    }

    public float getScaledHeight() {
        return this.getHeight() * this.getYScale();
    }

    public final float getHeight() {
        return (float)((double)this.layout.getHeight() / (this.unscaleHeight ? this.mainWindow.func_198100_s() : 1.0));
    }

    public final SELF setXOffset(float xOffset) {
        this.xOffset = xOffset;
        return this.self();
    }

    public final SELF setYOffset(float yOffset) {
        this.yOffset = yOffset;
        return this.self();
    }

    public final float getZOffset() {
        return (float)this.index + this.zOffset;
    }

    public final SELF setZOffset(float zOffset) {
        if (this.zOffset != zOffset) {
            this.zOffset = zOffset;
            if (this.parent != null) {
                this.parent.sortChildren();
            }
        }
        return this.self();
    }

    public final float getXScale() {
        return (this.parent == null ? 1.0f : this.parent.getXScale()) * this.xScale;
    }

    public final SELF setXScale(float xScale) {
        this.xScale = xScale;
        return this.self();
    }

    public final float getYScale() {
        return (this.parent == null ? 1.0f : this.parent.getYScale()) * this.yScale;
    }

    public final SELF setYScale(float yScale) {
        this.yScale = yScale;
        return this.self();
    }

    public final Overflow getOverflow() {
        return this.overflow;
    }

    public final SELF setOverflow(Overflow overflow) {
        this.overflow = overflow;
        return this.self();
    }

    public final SELF setScale(float scale) {
        return ((View)this.setXScale(scale)).setYScale(scale);
    }

    public final SELF setTopBorderWidth(float width) {
        this.topBorderWidth = width;
        return this.self();
    }

    public final SELF setRightBorderWidth(float width) {
        this.rightBorderWidth = width;
        return this.self();
    }

    public final SELF setBotBorderWidth(float width) {
        this.bottomBorderWidth = width;
        return this.self();
    }

    public final SELF setLeftBorderWidth(float width) {
        this.leftBorderWidth = width;
        return this.self();
    }

    public final SELF setTopBorderColour(Colour colour) {
        this.topBorderColour = colour;
        return this.self();
    }

    public final SELF setRightBorderColour(Colour colour) {
        this.rightBorderColour = colour;
        return this.self();
    }

    public final SELF setBotBorderColour(Colour colour) {
        this.bottomBorderColour = colour;
        return this.self();
    }

    public final SELF setLeftBorderColour(Colour colour) {
        this.leftBorderColour = colour;
        return this.self();
    }

    public final SELF setBorderWidth(float width) {
        this.topBorderWidth = width;
        this.rightBorderWidth = width;
        this.bottomBorderWidth = width;
        this.leftBorderWidth = width;
        return this.self();
    }

    public final SELF setBorderColour(Colour colour) {
        this.topBorderColour = colour;
        this.rightBorderColour = colour;
        this.bottomBorderColour = colour;
        this.leftBorderColour = colour;
        return this.self();
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final SELF setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return this.self();
        }
        this.enabled = enabled;
        this.post(new EnabledChangedEvent());
        return this.self();
    }

    public final SELF setTooltip(@Nullable Tooltip tooltip) {
        this.tooltip = tooltip;
        return this.self();
    }

    public Optional<Colour> getBackgroundColour() {
        return Optional.ofNullable(this.backgroundColour);
    }

    public final SELF setBackgroundColour(@Nullable Colour backgroundColour) {
        this.backgroundColour = backgroundColour;
        this.modifiedBackgroundColour = new Colour(backgroundColour);
        return this.self();
    }

    public final SELF setBackgroundBlur() {
        return this.setBackgroundBlur(0.0f);
    }

    public final SELF setBackgroundBlur(float blurRadius) {
        if (this.backgroundBlur != null) {
            this.backgroundBlur.close();
        }
        this.backgroundBlur = new Blur(blurRadius);
        return this.self();
    }

    public final SELF setFocusable(boolean focusable) {
        this.focusable = focusable;
        return this.self();
    }

    public final SELF setDoubleClick(boolean doubleClick) {
        this.doubleClick = doubleClick;
        return this.self();
    }

    public final SELF setUnscaleWidth() {
        this.unscaleWidth = true;
        return this.self();
    }

    public final SELF setUnscaleHeight() {
        this.unscaleHeight = true;
        return this.self();
    }

    public final float getAlpha() {
        return (this.parent == null ? 1.0f : this.parent.getAlpha()) * this.alpha;
    }

    public final SELF setAlpha(float alpha) {
        this.alpha = alpha;
        return this.self();
    }

    public final SELF configure(Consumer<SELF> configurer) {
        configurer.accept(this.self());
        return this.self();
    }

    public final L getLayout() {
        return this.layout;
    }

    public final ViewScreen getScreen() {
        if (this.screen == null) {
            if (this.parent == null) {
                throw new IllegalStateException("Root view has no screen");
            }
            return this.parent.getScreen();
        }
        return this.screen;
    }

    public final ParentView<?, ?, ? extends L> getParent() {
        return this.parent;
    }

    public final boolean isAdded() {
        return this.parent != null || this.screen != null;
    }

    @Override
    public int compareTo(View<?, ?> another) {
        if (another == null) {
            return 1;
        }
        if (this.getZOffset() < another.getZOffset()) {
            return -1;
        }
        if (this.getZOffset() > another.getZOffset()) {
            return 1;
        }
        return 0;
    }

    protected final SELF self() {
        return (SELF)this;
    }

    private static /* synthetic */ void lambda$static$7(View c, Float v) {
        c.scrollOffset = v.floatValue();
    }

    private static /* synthetic */ Float lambda$static$6(View c) {
        return Float.valueOf(c.scrollOffset);
    }

    private static /* synthetic */ Float lambda$static$5(View c) {
        return Float.valueOf(c.alpha);
    }

    private static /* synthetic */ void lambda$static$4(View t, float[] v) {
        t.topBorderWidth = v[0];
        t.rightBorderWidth = v[1];
        t.bottomBorderWidth = v[2];
        t.leftBorderWidth = v[3];
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

