/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view;

import com.craftingdead.immerse.client.gui.view.ImageView;
import com.craftingdead.immerse.client.gui.view.ParentView;
import com.craftingdead.immerse.client.gui.view.TextView;
import com.craftingdead.immerse.client.gui.view.View;
import com.craftingdead.immerse.client.gui.view.layout.yoga.YogaLayout;
import com.craftingdead.immerse.client.util.DownloadUtil;
import com.craftingdead.immerse.client.util.FitType;
import com.craftingdead.immerse.client.util.LoggingErrorHandler;
import com.google.common.base.Strings;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ViewUtil {
    private static final Logger logger = LogManager.getLogger();

    public static <T extends ParentView<?, ?, YogaLayout>> T addAll(T parentView, File file) {
        return ViewUtil.addAll(parentView, file, c -> ((YogaLayout)c.getLayout()).setFlex(1.0f));
    }

    public static <T extends ParentView<?, ?, YogaLayout>> T addAll(T parentView, File file, Consumer<View<?, YogaLayout>> configurer) {
        CompletableFuture<Document> documentFuture;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(LoggingErrorHandler.INSTANCE);
            documentFuture = CompletableFuture.supplyAsync(() -> {
                try {
                    return builder.parse(file);
                }
                catch (IOException | SAXException e) {
                    logger.warn("Failed to parse xml {} {}", (Object)file.getAbsolutePath(), (Object)e);
                    return null;
                }
            }, Util.func_215072_e());
        }
        catch (ParserConfigurationException e) {
            logger.warn("Failed to create document builder", (Throwable)e);
            return parentView;
        }
        documentFuture.thenAcceptAsync(document -> ViewUtil.parseDocument(document, file, parentView, configurer), (Executor)parentView.minecraft);
        return parentView;
    }

    private static <T extends ParentView<?, ?, YogaLayout>> void parseDocument(Document document, File file, T parentView, Consumer<View<?, YogaLayout>> configurer) {
        NodeList nodes = document.getDocumentElement().getChildNodes();
        block14: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeName()) {
                case "text": {
                    Node shadowNode;
                    String text = node.getTextContent();
                    boolean shadow = true;
                    float scale = 1.0f;
                    Node scaleNode = node.getAttributes().getNamedItem("scale");
                    if (scaleNode != null && scaleNode.getNodeValue() != null) {
                        try {
                            scale = Float.valueOf(scaleNode.getNodeValue()).floatValue();
                        }
                        catch (NullPointerException | NumberFormatException e) {
                            logger.warn("Float expected for property 'scale' in {}", (Object)file.getAbsolutePath());
                        }
                    }
                    if ((shadowNode = node.getAttributes().getNamedItem("shadow")) != null && shadowNode.getNodeValue() != null) {
                        try {
                            shadow = Boolean.valueOf(shadowNode.getNodeValue());
                        }
                        catch (NullPointerException | NumberFormatException e) {
                            logger.warn("Boolean expected for property 'shadow' in {}", (Object)file.getAbsolutePath());
                        }
                    }
                    if (text == null) continue block14;
                    Object view = new TextView<YogaLayout>(new YogaLayout().setWidthPercent(100.0f), ForgeHooks.newChatWithLinks((String)text)).setShadow(shadow).setScale(scale);
                    parentView.addChild(view);
                    continue block14;
                }
                case "image": {
                    Either<Integer, Float> height;
                    Either<Integer, Float> width;
                    String url = null;
                    FitType fitType = FitType.FILL;
                    Node urlNode = node.getAttributes().getNamedItem("url");
                    if (urlNode == null || urlNode.getNodeValue() == null) {
                        logger.warn("No URL declared for image in {}", (Object)file.getAbsolutePath());
                        continue block14;
                    }
                    url = urlNode.getNodeValue();
                    Node widthNode = node.getAttributes().getNamedItem("width");
                    if (widthNode != null && widthNode.getNodeValue() != null) {
                        String widthString = widthNode.getNodeValue();
                        width = ViewUtil.extractSize(widthString);
                        if (width == null) {
                            logger.warn("Invalid width '{}' for image in {}", (Object)widthString, (Object)file.getAbsolutePath());
                        }
                    } else {
                        width = null;
                    }
                    Node heightNode = node.getAttributes().getNamedItem("height");
                    if (heightNode != null && heightNode.getNodeValue() != null) {
                        String heightString = heightNode.getNodeValue();
                        height = ViewUtil.extractSize(heightString);
                        if (height == null) {
                            logger.warn("Invalid height '{}' for image in {}", (Object)heightString, (Object)file.getAbsolutePath());
                        }
                    } else {
                        height = null;
                    }
                    if (width == null && height == null) {
                        logger.warn("Both width and height cannot be empty for image in {}", (Object)file.getAbsolutePath());
                        continue block14;
                    }
                    Node fitNode = node.getAttributes().getNamedItem("fit");
                    if (fitNode != null && fitNode.getNodeValue() != null) {
                        try {
                            fitType = FitType.valueOf(fitNode.getNodeValue());
                        }
                        catch (IllegalArgumentException e) {
                            logger.warn("Invalid fit type {} in {}", (Object)heightNode.getNodeValue(), (Object)file.getAbsolutePath());
                        }
                    }
                    YogaLayout layout = new YogaLayout();
                    if (width != null) {
                        width.ifLeft(layout::setWidth).ifRight(layout::setWidthPercent);
                    }
                    if (height != null) {
                        height.ifLeft(layout::setHeight).ifRight(layout::setHeightPercent);
                    }
                    ImageView<YogaLayout> view = new ImageView<YogaLayout>(layout).setFitType(fitType);
                    parentView.addChild(view);
                    DownloadUtil.downloadImageAsTexture(url).thenAcceptAsync(result -> result.ifPresent(image -> {
                        view.setImage((ResourceLocation)image);
                        if (parentView.isAdded()) {
                            parentView.layout();
                        }
                    }), (Executor)parentView.minecraft);
                    continue block14;
                }
            }
        }
        if (parentView.isAdded()) {
            parentView.layout();
        }
    }

    @Nullable
    private static Either<Integer, Float> extractSize(String size) {
        if (Strings.isNullOrEmpty((String)size)) {
            return null;
        }
        if (size.contains("%")) {
            String pctString = size.split("%")[0];
            try {
                return Either.right((Object)Float.valueOf(pctString));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (size.contains("px")) {
            String pxString = size.split("px")[0];
            try {
                return Either.left((Object)Integer.valueOf(pxString));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

