/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.view.layout.yoga;

import com.craftingdead.immerse.client.gui.view.layout.Layout;
import com.craftingdead.immerse.client.gui.view.layout.MeasureMode;
import com.craftingdead.immerse.client.gui.view.layout.yoga.Align;
import com.craftingdead.immerse.client.gui.view.layout.yoga.Display;
import com.craftingdead.immerse.client.gui.view.layout.yoga.PositionType;
import net.minecraft.util.math.vector.Vector2f;
import org.lwjgl.util.yoga.YGMeasureFunc;
import org.lwjgl.util.yoga.YGSize;
import org.lwjgl.util.yoga.Yoga;

public class YogaLayout
implements Layout {
    private static final MeasureMode[] measureModes = new MeasureMode[]{MeasureMode.UNDEFINED, MeasureMode.EXACTLY, MeasureMode.AT_MOST};
    final long node = Yoga.YGNodeNew();

    public final YogaLayout setLeft(float left) {
        Yoga.YGNodeStyleSetPosition((long)this.node, (int)0, (float)left);
        return this;
    }

    public final YogaLayout setLeftPercent(float leftPercent) {
        Yoga.YGNodeStyleSetPositionPercent((long)this.node, (int)0, (float)leftPercent);
        return this;
    }

    public final YogaLayout setRight(float right) {
        Yoga.YGNodeStyleSetPosition((long)this.node, (int)2, (float)right);
        return this;
    }

    public final YogaLayout setRightPercent(float rightPercent) {
        Yoga.YGNodeStyleSetPositionPercent((long)this.node, (int)2, (float)rightPercent);
        return this;
    }

    public final YogaLayout setTop(float top) {
        Yoga.YGNodeStyleSetPosition((long)this.node, (int)1, (float)top);
        return this;
    }

    public final YogaLayout setTopPercent(float topPercent) {
        Yoga.YGNodeStyleSetPositionPercent((long)this.node, (int)1, (float)topPercent);
        return this;
    }

    public final YogaLayout setBottom(float bottom) {
        Yoga.YGNodeStyleSetPosition((long)this.node, (int)3, (float)bottom);
        return this;
    }

    public final YogaLayout setBottomPercent(float bottomPercent) {
        Yoga.YGNodeStyleSetPositionPercent((long)this.node, (int)3, (float)bottomPercent);
        return this;
    }

    public final YogaLayout setLeftPadding(float leftPadding) {
        Yoga.YGNodeStyleSetPadding((long)this.node, (int)0, (float)leftPadding);
        return this;
    }

    public final YogaLayout setLeftPaddingPercent(float leftPaddingPercent) {
        Yoga.YGNodeStyleSetPaddingPercent((long)this.node, (int)0, (float)leftPaddingPercent);
        return this;
    }

    public final YogaLayout setRightPadding(float rightPadding) {
        Yoga.YGNodeStyleSetPadding((long)this.node, (int)2, (float)rightPadding);
        return this;
    }

    public final YogaLayout setRightPaddingPercent(float rightPaddingPercent) {
        Yoga.YGNodeStyleSetPaddingPercent((long)this.node, (int)2, (float)rightPaddingPercent);
        return this;
    }

    public final YogaLayout setTopPadding(float topPadding) {
        Yoga.YGNodeStyleSetPadding((long)this.node, (int)1, (float)topPadding);
        return this;
    }

    public final YogaLayout setTopPaddingPercent(float topPaddingPercent) {
        Yoga.YGNodeStyleSetPaddingPercent((long)this.node, (int)1, (float)topPaddingPercent);
        return this;
    }

    public final YogaLayout setBottomPadding(float bottomPadding) {
        Yoga.YGNodeStyleSetPadding((long)this.node, (int)3, (float)bottomPadding);
        return this;
    }

    public final YogaLayout setBottomPaddingPercent(float bottomPaddingPercent) {
        Yoga.YGNodeStyleSetPaddingPercent((long)this.node, (int)3, (float)bottomPaddingPercent);
        return this;
    }

    public final YogaLayout setPadding(float padding) {
        Yoga.YGNodeStyleSetPadding((long)this.node, (int)8, (float)padding);
        return this;
    }

    public final YogaLayout setPaddingPercent(float paddingPercent) {
        Yoga.YGNodeStyleSetPaddingPercent((long)this.node, (int)8, (float)paddingPercent);
        return this;
    }

    public final YogaLayout setLeftMargin(float leftMargin) {
        Yoga.YGNodeStyleSetMargin((long)this.node, (int)0, (float)leftMargin);
        return this;
    }

    public final YogaLayout setLeftMarginPercent(float leftMarginPercent) {
        Yoga.YGNodeStyleSetMarginPercent((long)this.node, (int)0, (float)leftMarginPercent);
        return this;
    }

    public final YogaLayout setRightMargin(float rightMargin) {
        Yoga.YGNodeStyleSetMargin((long)this.node, (int)2, (float)rightMargin);
        return this;
    }

    public final YogaLayout setRightMarginPercent(float rightMarginPercent) {
        Yoga.YGNodeStyleSetMarginPercent((long)this.node, (int)2, (float)rightMarginPercent);
        return this;
    }

    public final YogaLayout setTopMargin(float topMargin) {
        Yoga.YGNodeStyleSetMargin((long)this.node, (int)1, (float)topMargin);
        return this;
    }

    public final YogaLayout setTopMarginPercent(float topMarginPercent) {
        Yoga.YGNodeStyleSetMarginPercent((long)this.node, (int)1, (float)topMarginPercent);
        return this;
    }

    public final YogaLayout setBottomMargin(float bottomMargin) {
        Yoga.YGNodeStyleSetMargin((long)this.node, (int)3, (float)bottomMargin);
        return this;
    }

    public final YogaLayout setBottomMarginPercent(float bottomMarginPercent) {
        Yoga.YGNodeStyleSetMarginPercent((long)this.node, (int)3, (float)bottomMarginPercent);
        return this;
    }

    public final YogaLayout setMargin(float margin) {
        Yoga.YGNodeStyleSetMargin((long)this.node, (int)8, (float)margin);
        return this;
    }

    public final YogaLayout setMarginPercent(float marginPercent) {
        Yoga.YGNodeStyleSetMarginPercent((long)this.node, (int)8, (float)marginPercent);
        return this;
    }

    public final YogaLayout setLeftMarginAuto() {
        Yoga.YGNodeStyleSetMarginAuto((long)this.node, (int)0);
        return this;
    }

    public final YogaLayout setRightMarginAuto() {
        Yoga.YGNodeStyleSetMarginAuto((long)this.node, (int)2);
        return this;
    }

    public final YogaLayout setTopMarginAuto() {
        Yoga.YGNodeStyleSetMarginAuto((long)this.node, (int)1);
        return this;
    }

    public final YogaLayout setBottomMarginAuto() {
        Yoga.YGNodeStyleSetMarginAuto((long)this.node, (int)3);
        return this;
    }

    public final YogaLayout setMarginAuto() {
        Yoga.YGNodeStyleSetMarginAuto((long)this.node, (int)8);
        return this;
    }

    public final YogaLayout setPositionType(PositionType positionType) {
        Yoga.YGNodeStyleSetPositionType((long)this.node, (int)(positionType == PositionType.ABSOLUTE ? 1 : 0));
        return this;
    }

    public final YogaLayout setFlexGrow(float flexGrow) {
        Yoga.YGNodeStyleSetFlexGrow((long)this.node, (float)flexGrow);
        return this;
    }

    public final YogaLayout setFlexShrink(float flexShrink) {
        Yoga.YGNodeStyleSetFlexShrink((long)this.node, (float)flexShrink);
        return this;
    }

    public final YogaLayout setFlexBasis(float flexBasis) {
        Yoga.YGNodeStyleSetFlexBasis((long)this.node, (float)flexBasis);
        return this;
    }

    public final YogaLayout setFlex(float flex) {
        Yoga.YGNodeStyleSetFlex((long)this.node, (float)flex);
        return this;
    }

    public final YogaLayout setAspectRatio(float aspectRatio) {
        Yoga.YGNodeStyleSetAspectRatio((long)this.node, (float)aspectRatio);
        return this;
    }

    public final YogaLayout setAlignSelf(Align align) {
        Yoga.YGNodeStyleSetAlignSelf((long)this.node, (int)align.getYogaType());
        return this;
    }

    public final YogaLayout setDisplay(Display display) {
        Yoga.nYGNodeStyleSetDisplay((long)this.node, (int)display.getYogaType());
        return this;
    }

    public YogaLayout setWidth(float width) {
        Yoga.YGNodeStyleSetWidth((long)this.node, (float)width);
        return this;
    }

    public final YogaLayout setWidthPercent(float widthPercent) {
        Yoga.YGNodeStyleSetWidthPercent((long)this.node, (float)widthPercent);
        return this;
    }

    public final YogaLayout setWidthAuto() {
        Yoga.YGNodeStyleSetWidthAuto((long)this.node);
        return this;
    }

    public YogaLayout setMaxWidth(float maxWidth) {
        Yoga.YGNodeStyleSetMaxWidth((long)this.node, (float)maxWidth);
        return this;
    }

    public final YogaLayout setHeight(float height) {
        Yoga.YGNodeStyleSetHeight((long)this.node, (float)height);
        return this;
    }

    public final YogaLayout setHeightPercent(float heightPercent) {
        Yoga.YGNodeStyleSetHeightPercent((long)this.node, (float)heightPercent);
        return this;
    }

    public final YogaLayout setHeightAuto() {
        Yoga.YGNodeStyleSetHeightAuto((long)this.node);
        return this;
    }

    public YogaLayout setMaxHeight(float maxHeight) {
        Yoga.YGNodeStyleSetMaxHeight((long)this.node, (float)maxHeight);
        return this;
    }

    public YogaLayout setMinWidth(float minWidth) {
        Yoga.YGNodeStyleSetMinWidth((long)this.node, (float)minWidth);
        return this;
    }

    public YogaLayout setMinHeight(float minHeight) {
        Yoga.YGNodeStyleSetMinHeight((long)this.node, (float)minHeight);
        return this;
    }

    @Override
    public float getLeft() {
        return Yoga.YGNodeLayoutGetLeft((long)this.node);
    }

    @Override
    public float getLeftPadding() {
        return Yoga.YGNodeLayoutGetPadding((long)this.node, (int)0);
    }

    @Override
    public float getRight() {
        return Yoga.YGNodeLayoutGetRight((long)this.node);
    }

    @Override
    public float getRightPadding() {
        return Yoga.YGNodeLayoutGetPadding((long)this.node, (int)2);
    }

    @Override
    public float getTop() {
        return Yoga.YGNodeLayoutGetTop((long)this.node);
    }

    @Override
    public float getTopPadding() {
        return Yoga.YGNodeLayoutGetPadding((long)this.node, (int)1);
    }

    @Override
    public float getBottom() {
        return Yoga.YGNodeLayoutGetBottom((long)this.node);
    }

    @Override
    public float getBottomPadding() {
        return Yoga.YGNodeLayoutGetPadding((long)this.node, (int)3);
    }

    @Override
    public float getWidth() {
        return Yoga.YGNodeLayoutGetWidth((long)this.node);
    }

    @Override
    public float getHeight() {
        return Yoga.YGNodeLayoutGetHeight((long)this.node);
    }

    @Override
    public void layout() {
        Yoga.YGNodeMarkDirty((long)this.node);
    }

    @Override
    public void close() {
        Yoga.YGNodeFree((long)this.node);
    }

    @Override
    public void setMeasureFunction(Layout.MeasureFunction measureFunction) {
        Yoga.YGNodeSetMeasureFunc((long)this.node, (node, width, widthMode, height, heightMode) -> {
            Vector2f size = measureFunction.measure(measureModes[widthMode], width, measureModes[heightMode], height);
            return YGMeasureFunc.toLong((YGSize)YGSize.create().width(size.field_189982_i).height(size.field_189983_j));
        });
    }
}

