/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.renderer;

import com.craftingdead.immerse.mixin.FirstPersonRendererAccessor;
import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;

public class SpectatorRenderer {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private float prevEquippedProgressMainHand;
    private float equippedProgressMainHand;
    private float prevEquippedProgressOffHand;
    private float equippedProgressOffHand;
    private ItemStack itemStackOffHand = ItemStack.field_190927_a;
    private ItemStack itemStackMainHand = ItemStack.field_190927_a;

    public void renderItemInFirstPerson(float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, AbstractClientPlayerEntity playerEntity, int packetLight) {
        float leftHandSwingProgress;
        float equippedProgress;
        float rightHandSwingProgress;
        float swingProgress = playerEntity.func_70678_g(partialTicks);
        Hand hand = (Hand)MoreObjects.firstNonNull((Object)playerEntity.field_184622_au, (Object)Hand.MAIN_HAND);
        float rotationPitch = MathHelper.func_219799_g((float)partialTicks, (float)playerEntity.field_70127_C, (float)playerEntity.field_70125_A);
        ItemStack heldStack = playerEntity.func_184614_ca();
        ItemStack offStack = playerEntity.func_184592_cb();
        boolean renderRightHand = true;
        boolean renderLeftHand = true;
        if (playerEntity.func_184587_cr()) {
            Hand activeHand;
            ItemStack itemstack = playerEntity.func_184607_cu();
            if (itemstack.func_77973_b() instanceof ShootableItem) {
                renderRightHand = playerEntity.func_184600_cs() == Hand.MAIN_HAND;
                boolean bl = renderLeftHand = !renderRightHand;
            }
            if ((activeHand = playerEntity.func_184600_cs()) == Hand.MAIN_HAND && offStack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)offStack)) {
                renderLeftHand = false;
            }
        } else {
            if (heldStack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)heldStack)) {
                boolean bl = renderLeftHand = !renderRightHand;
            }
            if (offStack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)offStack)) {
                renderRightHand = !heldStack.func_190926_b();
                renderLeftHand = !renderRightHand;
            }
        }
        FirstPersonRendererAccessor firstPersonRenderer = (FirstPersonRendererAccessor)this.minecraft.func_175597_ag();
        if (renderRightHand && !ForgeHooksClient.renderSpecificFirstPersonHand((Hand)Hand.MAIN_HAND, (MatrixStack)matrixStack, (IRenderTypeBuffer)renderTypeBuffer, (int)packetLight, (float)partialTicks, (float)rotationPitch, (float)(rightHandSwingProgress = hand == Hand.MAIN_HAND ? swingProgress : 0.0f), (float)(equippedProgress = 1.0f - MathHelper.func_219799_g((float)partialTicks, (float)this.prevEquippedProgressMainHand, (float)this.equippedProgressMainHand)), (ItemStack)this.itemStackMainHand)) {
            firstPersonRenderer.invokeRenderArmWithItem(playerEntity, partialTicks, rotationPitch, Hand.MAIN_HAND, rightHandSwingProgress, this.itemStackMainHand, equippedProgress, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, packetLight);
        }
        if (renderLeftHand && !ForgeHooksClient.renderSpecificFirstPersonHand((Hand)Hand.OFF_HAND, (MatrixStack)matrixStack, (IRenderTypeBuffer)renderTypeBuffer, (int)packetLight, (float)partialTicks, (float)rotationPitch, (float)(leftHandSwingProgress = hand == Hand.OFF_HAND ? swingProgress : 0.0f), (float)(equippedProgress = 1.0f - MathHelper.func_219799_g((float)partialTicks, (float)this.prevEquippedProgressOffHand, (float)this.equippedProgressOffHand)), (ItemStack)this.itemStackOffHand)) {
            firstPersonRenderer.invokeRenderArmWithItem(playerEntity, partialTicks, rotationPitch, Hand.OFF_HAND, leftHandSwingProgress, this.itemStackOffHand, equippedProgress, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, packetLight);
        }
        renderTypeBuffer.func_228461_a_();
    }

    public void tick(AbstractClientPlayerEntity playerEntity) {
        this.prevEquippedProgressMainHand = this.equippedProgressMainHand;
        this.prevEquippedProgressOffHand = this.equippedProgressOffHand;
        ItemStack heldStack = playerEntity.func_184614_ca();
        ItemStack offStack = playerEntity.func_184592_cb();
        if (ItemStack.func_77989_b((ItemStack)this.itemStackMainHand, (ItemStack)heldStack)) {
            this.itemStackMainHand = heldStack;
        }
        if (ItemStack.func_77989_b((ItemStack)this.itemStackOffHand, (ItemStack)offStack)) {
            this.itemStackOffHand = offStack;
        }
        float cooledAttackStrength = playerEntity.func_184825_o(1.0f);
        boolean requipMainHand = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.itemStackMainHand, (ItemStack)heldStack, (int)playerEntity.field_71071_by.field_70461_c);
        boolean requipOffHand = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.itemStackOffHand, (ItemStack)offStack, (int)-1);
        if (!requipMainHand && this.itemStackMainHand != heldStack) {
            this.itemStackMainHand = heldStack;
        }
        if (!requipOffHand && this.itemStackOffHand != offStack) {
            this.itemStackOffHand = offStack;
        }
        this.equippedProgressMainHand += MathHelper.func_76131_a((float)((!requipMainHand ? cooledAttackStrength * cooledAttackStrength * cooledAttackStrength : 0.0f) - this.equippedProgressMainHand), (float)-0.4f, (float)0.4f);
        this.equippedProgressOffHand += MathHelper.func_76131_a((float)((float)(!requipOffHand ? 1 : 0) - this.equippedProgressOffHand), (float)-0.4f, (float)0.4f);
        if (this.equippedProgressMainHand < 0.1f) {
            this.itemStackMainHand = heldStack;
        }
        if (this.equippedProgressOffHand < 0.1f) {
            this.itemStackOffHand = offStack;
        }
    }
}

