/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.shader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.minecraft.client.shader.IShaderManager;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShaderProgram
implements IShaderManager {
    public static final Logger logger = LogManager.getLogger();
    private int program;
    private ShaderLoader vertexShader;
    private ShaderLoader fragmentShader;
    @Nonnull
    private final ResourceLocation vertexShaderLocation;
    @Nonnull
    private final ResourceLocation fragmentShaderLocation;

    public ShaderProgram(@Nonnull ResourceLocation vert, @Nonnull ResourceLocation frag) {
        this.vertexShaderLocation = vert;
        this.fragmentShaderLocation = frag;
    }

    public ShaderProgram(@Nonnull String vert, @Nonnull String frag) {
        this(new ResourceLocation("craftingdeadimmerse", String.format("shaders/%s.vert", vert)), new ResourceLocation("craftingdeadimmerse", String.format("shaders/%s.frag", frag)));
    }

    public void compile(IResourceManager manager) {
        if (this.vertexShader != null || this.fragmentShader != null) {
            ShaderLinkHelper.func_148077_a((IShaderManager)this);
        }
        try {
            this.vertexShader = ShaderProgram.createShader(manager, this.vertexShaderLocation, ShaderLoader.ShaderType.VERTEX);
            this.fragmentShader = ShaderProgram.createShader(manager, this.fragmentShaderLocation, ShaderLoader.ShaderType.FRAGMENT);
            this.program = ShaderLinkHelper.func_148078_c();
            ShaderLinkHelper.func_148075_b((IShaderManager)this);
        }
        catch (IOException e) {
            logger.fatal("Can't create program {}", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    @Nonnull
    private static ShaderLoader createShader(IResourceManager manager, @Nonnull ResourceLocation location, ShaderLoader.ShaderType type) throws IOException {
        IResource resource = manager.func_199002_a(location);
        try (BufferedInputStream stream = new BufferedInputStream(resource.func_199027_b());){
            ShaderLoader shaderLoader = ShaderLoader.func_216534_a((ShaderLoader.ShaderType)type, (String)location.toString(), (InputStream)stream, (String)resource.func_199026_d());
            return shaderLoader;
        }
    }

    public int func_147986_h() {
        return this.program;
    }

    public void func_147985_d() {
    }

    @Nonnull
    public ShaderLoader func_147989_e() {
        return this.vertexShader;
    }

    @Nonnull
    public ShaderLoader func_147994_f() {
        return this.fragmentShader;
    }
}

