/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.util;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DownloadUtil {
    private static final Logger logger = LogManager.getLogger();
    private static final String USER_AGENT = "Minecraft Java/" + SharedConstants.func_215069_a().getName();

    public static CompletableFuture<Optional<ResourceLocation>> downloadImageAsTexture(String imageUrl) {
        return DownloadUtil.downloadImage(imageUrl).thenApplyAsync(result -> result.map(image -> {
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            ResourceLocation textureLocation = new ResourceLocation("craftingdeadimmerse", String.valueOf(imageUrl.hashCode()));
            textureManager.func_229263_a_(textureLocation, (Texture)new DynamicTexture(image));
            return textureLocation;
        }), (Executor)Minecraft.func_71410_x());
    }

    public static CompletableFuture<Optional<NativeImage>> downloadImage(String imageUrl) {
        return CompletableFuture.supplyAsync(() -> {
            HttpURLConnection httpUrlConnection = null;
            logger.debug("Downloading image from {} to {}", (Object)imageUrl);
            try {
                httpUrlConnection = (HttpURLConnection)new URL(imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                httpUrlConnection.setRequestProperty("User-Agent", USER_AGENT);
                httpUrlConnection.setDoInput(true);
                httpUrlConnection.setDoOutput(false);
                httpUrlConnection.connect();
                if (httpUrlConnection.getResponseCode() / 100 == 2) {
                    Optional<NativeImage> optional = Optional.of(NativeImage.func_195713_a((InputStream)httpUrlConnection.getInputStream()));
                    return optional;
                }
            }
            catch (Throwable t) {
                logger.error("Couldn't download image", t);
            }
            finally {
                if (httpUrlConnection != null) {
                    httpUrlConnection.disconnect();
                }
            }
            return Optional.empty();
        }, Util.func_215072_e());
    }
}

