/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.util;

import com.craftingdead.immerse.client.shader.RoundedFrameShader;
import com.craftingdead.immerse.client.shader.RoundedRectShader;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class RenderUtil {
    private static final Minecraft minecraft = Minecraft.func_71410_x();

    public static void renderTextRight(FontRenderer fontRenderer, MatrixStack matrixStack, float x, float y, ITextComponent text, int colour, boolean shadow) {
        if (shadow) {
            fontRenderer.func_243246_a(matrixStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text), y, colour);
        } else {
            fontRenderer.func_243248_b(matrixStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text), y, colour);
        }
    }

    public static void renderTextRight(FontRenderer fontRenderer, MatrixStack matrixStack, float x, float y, String text, int colour, boolean shadow) {
        fontRenderer.func_238406_a_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text), y, colour, shadow);
    }

    public static void drawRoundedFrame(MatrixStack matrixStack, double x, double y, double x2, double y2, int colour, float radius) {
        ShaderLinkHelper.func_227804_a_((int)RoundedFrameShader.INSTANCE.func_147986_h());
        RoundedFrameShader.INSTANCE.setRadius(radius - 1.0f);
        RoundedRectShader.INSTANCE.setInnerRect((float)x + radius, (float)y + radius, (float)x2 - radius, (float)y2 - radius);
        RenderUtil.fill(matrixStack, x, y, x2, y2, colour);
        ShaderLinkHelper.func_227804_a_((int)0);
    }

    public static void roundedFill(MatrixStack matrixStack, double x, double y, double x2, double y2, int colour, float radius) {
        ShaderLinkHelper.func_227804_a_((int)RoundedRectShader.INSTANCE.func_147986_h());
        RoundedRectShader.INSTANCE.setRadius(radius - 1.0f);
        RoundedRectShader.INSTANCE.setInnerRect((float)x + radius, (float)y + radius, (float)x2 - radius, (float)y2 - radius);
        RenderUtil.fill(matrixStack, x, y, x2, y2, colour);
        ShaderLinkHelper.func_227804_a_((int)0);
    }

    public static void fillWithShadow(MatrixStack matrixStack, double x, double y, double width, double height, int colour) {
        RenderUtil.fill(matrixStack, x - 1.0, y - 1.0, x + width + 1.0, y + height + 1.0, 0x4D000000L);
        RenderUtil.fill(matrixStack, x, y, x + width, y + height, colour);
    }

    public static void fillWidthHeight(MatrixStack matrixStack, double x, double y, double width, double height, int colour) {
        RenderUtil.fill(matrixStack, x, y, x + width, y + height, colour);
    }

    public static void fill(MatrixStack matrixStack, double x, double y, double x2, double y2, long colour) {
        RenderUtil.fill(matrixStack, x, y, 0.0, x2, y2, colour);
    }

    public static void fill(MatrixStack matrixStack, double x, double y, double z, double x2, double y2, long colour) {
        float alpha = (float)(colour >> 24 & 0xFFL) / 255.0f;
        float red = (float)(colour >> 16 & 0xFFL) / 255.0f;
        float green = (float)(colour >> 8 & 0xFFL) / 255.0f;
        float blue = (float)(colour & 0xFFL) / 255.0f;
        RenderUtil.fill(matrixStack.func_227866_c_().func_227870_a_(), x, y, z, x2, y2, red, green, blue, alpha);
    }

    public static void fill(Matrix4f matrix, double x, double y, double z, double x2, double y2, float red, float green, float blue, float alpha) {
        if (x < x2) {
            double i = x;
            x = x2;
            x2 = i;
        }
        if (y < y2) {
            double j = y;
            y = y2;
            y2 = j;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_225582_a_(x, y2, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y2, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x2, y, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_225582_a_(x, y, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void blit(MatrixStack matrixStack, float x, float y, float width, float height) {
        RenderUtil.blit(matrixStack.func_227866_c_().func_227870_a_(), x, y, x + width, y + height, 0.0f, 1.0f, 1.0f, 0.0f);
    }

    public static void blit(MatrixStack matrixStack, float x, float y, float x2, float y2, float textureX, float textureY, float textureX2, float textureY2, float width, float height) {
        float u = textureX / width;
        float u2 = textureX2 / width;
        float v = textureY / height;
        float v2 = textureY2 / height;
        RenderUtil.blit(matrixStack.func_227866_c_().func_227870_a_(), x, y, x2, y2, u, v, u2, v2);
    }

    public static void blit(Matrix4f matrix, float x, float y, float x2, float y2, float u, float v, float u2, float v2) {
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_227888_a_(matrix, x, y2, 0.0f).func_225583_a_(u, v).func_181675_d();
        builder.func_227888_a_(matrix, x2, y2, 0.0f).func_225583_a_(u2, v).func_181675_d();
        builder.func_227888_a_(matrix, x2, y, 0.0f).func_225583_a_(u2, v2).func_181675_d();
        builder.func_227888_a_(matrix, x, y, 0.0f).func_225583_a_(u, v2).func_181675_d();
        builder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)builder);
    }

    public static void bind(ResourceLocation resourceLocation) {
        minecraft.func_110434_K().func_110577_a(resourceLocation);
    }

    public static long lerp(int colour1, int colour2, float pct) {
        return RenderUtil.getColour(RenderUtil.lerp(RenderUtil.getColour4i(colour1), RenderUtil.getColour4i(colour2), pct));
    }

    public static int[] lerp(int[] colour1, int[] colour2, float pct) {
        int[] rgba = new int[4];
        for (int i = 0; i < 4; ++i) {
            rgba[i] = MathHelper.func_76123_f((float)MathHelper.func_219799_g((float)pct, (float)colour1[i], (float)colour2[i]));
        }
        return rgba;
    }

    public static float[] getColour4f(int[] colour4i) {
        return new float[]{(float)colour4i[0] / 255.0f, (float)colour4i[1] / 255.0f, (float)colour4i[2] / 255.0f, (float)colour4i[3] / 255.0f};
    }

    public static int[] getColour4i(long colour) {
        int[] rgba = new int[]{(int)(colour >> 16 & 0xFFL), (int)(colour >> 8) & 0xFF, (int)(colour >> 0) & 0xFF, (int)(colour >> 24) & 0xFF};
        return rgba;
    }

    public static int[] getColour4i(float[] colour4f) {
        return new int[]{MathHelper.func_76123_f((float)(colour4f[0] * 255.0f)), MathHelper.func_76123_f((float)(colour4f[1] * 255.0f)), MathHelper.func_76123_f((float)(colour4f[2] * 255.0f)), MathHelper.func_76123_f((float)(colour4f[3] * 255.0f))};
    }

    public static long getColour(int[] colour4i) {
        return (long)(colour4i[3] & 0xFF) << 24 | (long)((colour4i[0] & 0xFF) << 16) | (long)((colour4i[1] & 0xFF) << 8) | (long)((colour4i[2] & 0xFF) << 0);
    }

    public static void renderHead(ResourceLocation skin, MatrixStack matrixStack, int x, int y, int width, int height) {
        RenderUtil.bind(skin);
        AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)width, (int)height, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
    }

    public static void renderPlayerListRow(MatrixStack matrixStack, int x, int y, int width, int height, ITextComponent ping, ITextComponent username, ITextComponent ... stats) {
        int statWidth = 31;
        int pingWidth = 26;
        boolean columnSpacing = true;
        RenderUtil.minecraft.field_71466_p.getClass();
        int textYOffset = 1 + (height - 9) / 2;
        RenderUtil.fillWidthHeight(matrixStack, x, y, 26.0, height, -1275068416);
        AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)RenderUtil.minecraft.field_71466_p, (ITextComponent)ping, (int)(x + 13), (int)(y + textYOffset), (int)-1);
        int usernameColumnWidth = width - 26 - 1 - stats.length * 31;
        RenderUtil.fillWidthHeight(matrixStack, x + 26 + 1, y, usernameColumnWidth, height, -1275068416);
        RenderUtil.minecraft.field_71466_p.func_243246_a(matrixStack, username, (float)(x + 54), (float)(y + textYOffset), -1);
        int statsX = x + 26 - 8 + usernameColumnWidth;
        for (int i = 0; i < stats.length; ++i) {
            ITextComponent stat = stats[i];
            RenderUtil.fillWidthHeight(matrixStack, statsX + 10 + i * 31, y, 30.0, height, -1275068416);
            AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)RenderUtil.minecraft.field_71466_p, (ITextComponent)stat, (int)(statsX + 10 + i * 31 + 16), (int)(y + textYOffset), (int)-1);
        }
    }
}

